@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumnDelimiter The column delimiter. For example, in a CSV format, a comma (`,`) is the typical column delimiter.
 * @property recordRowDelimiter The row delimiter. For example, in a CSV format, `\n` is the typical row delimiter.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs(
    public val recordColumnDelimiter: Output<String>,
    public val recordRowDelimiter: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs.builder()
            .recordColumnDelimiter(recordColumnDelimiter.applyValue({ args0 -> args0 }))
            .recordRowDelimiter(recordRowDelimiter.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgsBuilder
internal constructor() {
    private var recordColumnDelimiter: Output<String>? = null

    private var recordRowDelimiter: Output<String>? = null

    /**
     * @param value The column delimiter. For example, in a CSV format, a comma (`,`) is the typical column delimiter.
     */
    @JvmName("kocaypnwudavhuto")
    public suspend fun recordColumnDelimiter(`value`: Output<String>) {
        this.recordColumnDelimiter = value
    }

    /**
     * @param value The row delimiter. For example, in a CSV format, `\n` is the typical row delimiter.
     */
    @JvmName("vorhgjihlixabbwy")
    public suspend fun recordRowDelimiter(`value`: Output<String>) {
        this.recordRowDelimiter = value
    }

    /**
     * @param value The column delimiter. For example, in a CSV format, a comma (`,`) is the typical column delimiter.
     */
    @JvmName("vojgylpybouubymu")
    public suspend fun recordColumnDelimiter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumnDelimiter = mapped
    }

    /**
     * @param value The row delimiter. For example, in a CSV format, `\n` is the typical row delimiter.
     */
    @JvmName("spkmxyabbywsajbe")
    public suspend fun recordRowDelimiter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordRowDelimiter = mapped
    }

    internal fun build():
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCsvMappingParametersArgs(
            recordColumnDelimiter = recordColumnDelimiter ?: throw
                PulumiNullFieldException("recordColumnDelimiter"),
            recordRowDelimiter = recordRowDelimiter ?: throw PulumiNullFieldException("recordRowDelimiter"),
        )
}
