@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds The Security Group IDs used by the VPC configuration.
 * @property subnetIds The Subnet IDs used by the VPC configuration.
 * @property vpcConfigurationId
 * @property vpcId
 */
public data class ApplicationApplicationConfigurationVpcConfigurationArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcConfigurationId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationVpcConfigurationArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcConfigurationId(vpcConfigurationId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationVpcConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationVpcConfigurationArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcConfigurationId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The Security Group IDs used by the VPC configuration.
     */
    @JvmName("djldxfyndufmfhgk")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("gifhqeyqntowsgjb")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The Security Group IDs used by the VPC configuration.
     */
    @JvmName("tpwmfpwquodplors")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The Subnet IDs used by the VPC configuration.
     */
    @JvmName("vgkbktkdstvsfuxp")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("plexppebhlttsdmt")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The Subnet IDs used by the VPC configuration.
     */
    @JvmName("xljumrlhnoacotrb")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("majlvptetbraprft")
    public suspend fun vpcConfigurationId(`value`: Output<String>) {
        this.vpcConfigurationId = value
    }

    /**
     * @param value
     */
    @JvmName("flmdvxijpyhmgfnj")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The Security Group IDs used by the VPC configuration.
     */
    @JvmName("olgllfmspviibukm")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The Security Group IDs used by the VPC configuration.
     */
    @JvmName("igbpxxckthpytrhf")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The Subnet IDs used by the VPC configuration.
     */
    @JvmName("cjqvtwjmwfrwttta")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The Subnet IDs used by the VPC configuration.
     */
    @JvmName("yjwsgfxgoqcxfkhp")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("aulaansdggrlnrrk")
    public suspend fun vpcConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfigurationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vngssconhprgydfu")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationVpcConfigurationArgs =
        ApplicationApplicationConfigurationVpcConfigurationArgs(
            securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
            subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
            vpcConfigurationId = vpcConfigurationId,
            vpcId = vpcId,
        )
}
