@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLoggingOptionId
 * @property logStreamArn The ARN of the CloudWatch log stream to receive application messages.
 */
public data class ApplicationCloudwatchLoggingOptionsArgs(
    public val cloudwatchLoggingOptionId: Output<String>? = null,
    public val logStreamArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationCloudwatchLoggingOptionsArgs.builder()
            .cloudwatchLoggingOptionId(cloudwatchLoggingOptionId?.applyValue({ args0 -> args0 }))
            .logStreamArn(logStreamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationCloudwatchLoggingOptionsArgs].
 */
@PulumiTagMarker
public class ApplicationCloudwatchLoggingOptionsArgsBuilder internal constructor() {
    private var cloudwatchLoggingOptionId: Output<String>? = null

    private var logStreamArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cluefwaugupniyfv")
    public suspend fun cloudwatchLoggingOptionId(`value`: Output<String>) {
        this.cloudwatchLoggingOptionId = value
    }

    /**
     * @param value The ARN of the CloudWatch log stream to receive application messages.
     */
    @JvmName("dossnweugsogpybm")
    public suspend fun logStreamArn(`value`: Output<String>) {
        this.logStreamArn = value
    }

    /**
     * @param value
     */
    @JvmName("jmbgrdwsnnnbdjpx")
    public suspend fun cloudwatchLoggingOptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptionId = mapped
    }

    /**
     * @param value The ARN of the CloudWatch log stream to receive application messages.
     */
    @JvmName("uysvhrbvjkectkhg")
    public suspend fun logStreamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreamArn = mapped
    }

    internal fun build(): ApplicationCloudwatchLoggingOptionsArgs =
        ApplicationCloudwatchLoggingOptionsArgs(
            cloudwatchLoggingOptionId = cloudwatchLoggingOptionId,
            logStreamArn = logStreamArn ?: throw PulumiNullFieldException("logStreamArn"),
        )
}
