@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketArn The ARN for the S3 bucket containing the application code.
 * @property fileKey The file key for the object containing the application code.
 * @property objectVersion The version of the object containing the application code.
 */
public data class
ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocation(
    public val bucketArn: String,
    public val fileKey: String,
    public val objectVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocation):
            ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocation =
            ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocation(
                bucketArn = javaType.bucketArn(),
                fileKey = javaType.fileKey(),
                objectVersion = javaType.objectVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
