@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property checkpointConfiguration Describes an application's checkpointing configuration.
 * @property monitoringConfiguration Describes configuration parameters for CloudWatch logging for an application.
 * @property parallelismConfiguration Describes parameters for how an application executes multiple tasks simultaneously.
 */
public data class ApplicationApplicationConfigurationFlinkApplicationConfiguration(
    public val checkpointConfiguration:
    ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration? =
        null,
    public val monitoringConfiguration:
    ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration? =
        null,
    public val parallelismConfiguration:
    ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationFlinkApplicationConfiguration):
            ApplicationApplicationConfigurationFlinkApplicationConfiguration =
            ApplicationApplicationConfigurationFlinkApplicationConfiguration(
                checkpointConfiguration = javaType.checkpointConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                monitoringConfiguration = javaType.monitoringConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                parallelismConfiguration = javaType.parallelismConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
