@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property checkpointInterval Describes the interval in milliseconds between checkpoint operations.
 * @property checkpointingEnabled Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
 * @property configurationType Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `checkpointing_enabled`, `checkpoint_interval`, or `min_pause_between_checkpoints` attribute values to be effective. If this attribute is set to `DEFAULT`, the application will always use the following values:
 * * `checkpointing_enabled = true`
 * * `checkpoint_interval = 60000`
 * * `min_pause_between_checkpoints = 5000`
 * @property minPauseBetweenCheckpoints Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration(
    public val checkpointInterval: Int? = null,
    public val checkpointingEnabled: Boolean? = null,
    public val configurationType: String,
    public val minPauseBetweenCheckpoints: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration):
            ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfiguration(
                checkpointInterval = javaType.checkpointInterval().map({ args0 -> args0 }).orElse(null),
                checkpointingEnabled = javaType.checkpointingEnabled().map({ args0 -> args0 }).orElse(null),
                configurationType = javaType.configurationType(),
                minPauseBetweenCheckpoints = javaType.minPauseBetweenCheckpoints().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
