@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configurationType Describes whether to use the default CloudWatch logging configuration for an application. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `log_level` or `metrics_level` attribute values to be effective.
 * @property logLevel Describes the verbosity of the CloudWatch Logs for an application. Valid values: `DEBUG`, `ERROR`, `INFO`, `WARN`.
 * @property metricsLevel Describes the granularity of the CloudWatch Logs for an application. Valid values: `APPLICATION`, `OPERATOR`, `PARALLELISM`, `TASK`.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration(
    public val configurationType: String,
    public val logLevel: String? = null,
    public val metricsLevel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration):
            ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfiguration(
                configurationType = javaType.configurationType(),
                logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
                metricsLevel = javaType.metricsLevel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
