@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationRestoreType Specifies how the application should be restored. Valid values: `RESTORE_FROM_CUSTOM_SNAPSHOT`, `RESTORE_FROM_LATEST_SNAPSHOT`, `SKIP_RESTORE_FROM_SNAPSHOT`.
 * @property snapshotName The identifier of an existing snapshot of application state to use to restart an application. The application uses this value if `RESTORE_FROM_CUSTOM_SNAPSHOT` is specified for `application_restore_type`.
 */
public data class
ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration(
    public val applicationRestoreType: String? = null,
    public val snapshotName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration):
            ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration =
            ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration(
                applicationRestoreType = javaType.applicationRestoreType().map({ args0 -> args0 }).orElse(null),
                snapshotName = javaType.snapshotName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
