@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property inAppStreamNames
 * @property inputId
 * @property inputParallelism Describes the number of in-application streams to create.
 * @property inputProcessingConfiguration The input processing configuration for the input.
 * An input processor transforms records as they are received from the stream, before the application's SQL code executes.
 * @property inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
 * @property inputStartingPositionConfigurations The point at which the application starts processing records from the streaming source.
 * @property kinesisFirehoseInput If the streaming source is a Kinesis Data Firehose delivery stream, identifies the delivery stream's ARN.
 * @property kinesisStreamsInput If the streaming source is a Kinesis data stream, identifies the stream's Amazon Resource Name (ARN).
 * @property namePrefix The name prefix to use when creating an in-application stream.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationInput(
    public val inAppStreamNames: List<String>? = null,
    public val inputId: String? = null,
    public val inputParallelism:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelism? = null,
    public val inputProcessingConfiguration:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfiguration? =
        null,
    public val inputSchema:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema,
    public val inputStartingPositionConfigurations:
    List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfiguration>? =
        null,
    public val kinesisFirehoseInput:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInput? =
        null,
    public val kinesisStreamsInput:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInput? =
        null,
    public val namePrefix: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInput):
            ApplicationApplicationConfigurationSqlApplicationConfigurationInput =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInput(
                inAppStreamNames = javaType.inAppStreamNames().map({ args0 -> args0 }),
                inputId = javaType.inputId().map({ args0 -> args0 }).orElse(null),
                inputParallelism = javaType.inputParallelism().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputParallelism.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                inputProcessingConfiguration = javaType.inputProcessingConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputProcessingConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                inputSchema = javaType.inputSchema().let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema.Companion.toKotlin(args0)
                }),
                inputStartingPositionConfigurations = javaType.inputStartingPositionConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputStartingPositionConfiguration.Companion.toKotlin(args0)
                    })
                }),
                kinesisFirehoseInput = javaType.kinesisFirehoseInput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisFirehoseInput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                kinesisStreamsInput = javaType.kinesisStreamsInput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputKinesisStreamsInput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                namePrefix = javaType.namePrefix(),
            )
    }
}
