@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property recordColumns Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
 * @property recordEncoding Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
 * @property recordFormat Specifies the format of the records on the streaming source.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema(
    public val recordColumns:
    List<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumn>,
    public val recordEncoding: String? = null,
    public val recordFormat:
    ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormat,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema):
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchema(
                recordColumns = javaType.recordColumns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordColumn.Companion.toKotlin(args0)
                    })
                }),
                recordEncoding = javaType.recordEncoding().map({ args0 -> args0 }).orElse(null),
                recordFormat = javaType.recordFormat().let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormat.Companion.toKotlin(args0)
                }),
            )
    }
}
