@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property referenceId
 * @property referenceSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
 * @property s3ReferenceDataSource Identifies the S3 bucket and object that contains the reference data.
 * @property tableName The name of the in-application table to create.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource(
    public val referenceId: String? = null,
    public val referenceSchema:
    ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchema,
    public val s3ReferenceDataSource:
    ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSource,
    public val tableName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource):
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource(
                referenceId = javaType.referenceId().map({ args0 -> args0 }).orElse(null),
                referenceSchema = javaType.referenceSchema().let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchema.Companion.toKotlin(args0)
                }),
                s3ReferenceDataSource = javaType.s3ReferenceDataSource().let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSource.Companion.toKotlin(args0)
                }),
                tableName = javaType.tableName(),
            )
    }
}
