@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.aws.kms.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

/**
 * Provides an alias for a KMS customer master key. AWS Console enforces 1-to-1 mapping between aliases & keys,
 * but API (hence this provider too) allows you to create as many aliases as
 * the [account limits](http://docs.aws.amazon.com/kms/latest/developerguide/limits.html) allow you.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.Alias;
 * import com.pulumi.aws.kms.AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key");
 *         var alias = new Alias("alias", AliasArgs.builder()
 *             .targetKeyId(key.keyId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS aliases using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:kms/alias:Alias a alias/my-key-alias
 * ```
 *
 */
public class Alias internal constructor(
    override val javaResource: com.pulumi.aws.kms.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    /**
     * The Amazon Resource Name (ARN) of the key alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates an unique alias beginning with the specified prefix.
     * The name must start with the word "alias" followed by a forward slash (alias/).  Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the target key identifier.
     */
    public val targetKeyArn: Output<String>
        get() = javaResource.targetKeyArn().applyValue({ args0 -> args0 })

    /**
     * Identifier for the key for which the alias is for, can be either an ARN or key_id.
     */
    public val targetKeyId: Output<String>
        get() = javaResource.targetKeyId().applyValue({ args0 -> args0 })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(javaResource as com.pulumi.aws.kms.Alias)
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
