@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.AliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an alias for a KMS customer master key. AWS Console enforces 1-to-1 mapping between aliases & keys,
 * but API (hence this provider too) allows you to create as many aliases as
 * the [account limits](http://docs.aws.amazon.com/kms/latest/developerguide/limits.html) allow you.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.Alias;
 * import com.pulumi.aws.kms.AliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key");
 *         var alias = new Alias("alias", AliasArgs.builder()
 *             .targetKeyId(key.keyId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS aliases using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:kms/alias:Alias a alias/my-key-alias
 * ```
 * @property name The display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
 * @property namePrefix Creates an unique alias beginning with the specified prefix.
 * The name must start with the word "alias" followed by a forward slash (alias/).  Conflicts with `name`.
 * @property targetKeyId Identifier for the key for which the alias is for, can be either an ARN or key_id.
 */
public data class AliasArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val targetKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.AliasArgs> {
    override fun toJava(): com.pulumi.aws.kms.AliasArgs = com.pulumi.aws.kms.AliasArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .targetKeyId(targetKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var targetKeyId: Output<String>? = null

    /**
     * @param value The display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
     */
    @JvmName("jqgyvwmucvcbajgh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates an unique alias beginning with the specified prefix.
     * The name must start with the word "alias" followed by a forward slash (alias/).  Conflicts with `name`.
     */
    @JvmName("dnawbkaddyjitodt")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Identifier for the key for which the alias is for, can be either an ARN or key_id.
     */
    @JvmName("ykduvedabvpfxhhk")
    public suspend fun targetKeyId(`value`: Output<String>) {
        this.targetKeyId = value
    }

    /**
     * @param value The display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
     */
    @JvmName("tstgudtcjikjetil")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates an unique alias beginning with the specified prefix.
     * The name must start with the word "alias" followed by a forward slash (alias/).  Conflicts with `name`.
     */
    @JvmName("xoegjwqwrqtpldsw")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Identifier for the key for which the alias is for, can be either an ARN or key_id.
     */
    @JvmName("kawilunboannlrvh")
    public suspend fun targetKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetKeyId = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        name = name,
        namePrefix = namePrefix,
        targetKeyId = targetKeyId,
    )
}
