@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ciphertext].
 */
@PulumiTagMarker
public class CiphertextResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CiphertextArgs = CiphertextArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CiphertextArgsBuilder.() -> Unit) {
        val builder = CiphertextArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Ciphertext {
        val builtJavaResource = com.pulumi.aws.kms.Ciphertext(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ciphertext(builtJavaResource)
    }
}

/**
 * The KMS ciphertext resource allows you to encrypt plaintext into ciphertext
 * by using an AWS KMS customer master key. The value returned by this resource
 * is stable across every apply. For a changing ciphertext value each apply, see
 * the `aws.kms.Ciphertext` data source.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.Ciphertext;
 * import com.pulumi.aws.kms.CiphertextArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oauthConfig = new Key("oauthConfig", KeyArgs.builder()
 *             .description("oauth config")
 *             .isEnabled(true)
 *             .build());
 *         var oauth = new Ciphertext("oauth", CiphertextArgs.builder()
 *             .keyId(oauthConfig.keyId())
 *             .plaintext("""
 * {
 *   "client_id": "e587dbae22222f55da22",
 *   "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 */
public class Ciphertext internal constructor(
    override val javaResource: com.pulumi.aws.kms.Ciphertext,
) : KotlinCustomResource(javaResource, CiphertextMapper) {
    /**
     * Base64 encoded ciphertext
     */
    public val ciphertextBlob: Output<String>
        get() = javaResource.ciphertextBlob().applyValue({ args0 -> args0 })

    /**
     * An optional mapping that makes up the encryption context.
     */
    public val context: Output<Map<String, String>>?
        get() = javaResource.context().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Globally unique key ID for the customer master key.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
     */
    public val plaintext: Output<String>
        get() = javaResource.plaintext().applyValue({ args0 -> args0 })
}

public object CiphertextMapper : ResourceMapper<Ciphertext> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.Ciphertext::class == javaResource::class

    override fun map(javaResource: Resource): Ciphertext = Ciphertext(
        javaResource as
            com.pulumi.aws.kms.Ciphertext,
    )
}

/**
 * @see [Ciphertext].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ciphertext].
 */
public suspend fun ciphertext(name: String, block: suspend CiphertextResourceBuilder.() -> Unit):
    Ciphertext {
    val builder = CiphertextResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ciphertext].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ciphertext(name: String): Ciphertext {
    val builder = CiphertextResourceBuilder()
    builder.name(name)
    return builder.build()
}
