@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomKeyStore].
 */
@PulumiTagMarker
public class CustomKeyStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomKeyStoreArgs = CustomKeyStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomKeyStoreArgsBuilder.() -> Unit) {
        val builder = CustomKeyStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomKeyStore {
        val builtJavaResource = com.pulumi.aws.kms.CustomKeyStore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomKeyStore(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS KMS (Key Management) Custom Key Store.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.CustomKeyStore;
 * import com.pulumi.aws.kms.CustomKeyStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CustomKeyStore("test", CustomKeyStoreArgs.builder()
 *             .cloudHsmClusterId(var_.cloud_hsm_cluster_id())
 *             .customKeyStoreName("kms-custom-key-store-test")
 *             .keyStorePassword("noplaintextpasswords1")
 *             .trustAnchorCertificate(Files.readString(Paths.get("anchor-certificate.crt")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
 * ```
 *
 */
public class CustomKeyStore internal constructor(
    override val javaResource: com.pulumi.aws.kms.CustomKeyStore,
) : KotlinCustomResource(javaResource, CustomKeyStoreMapper) {
    /**
     * Cluster ID of CloudHSM.
     */
    public val cloudHsmClusterId: Output<String>
        get() = javaResource.cloudHsmClusterId().applyValue({ args0 -> args0 })

    /**
     * Unique name for Custom Key Store.
     */
    public val customKeyStoreName: Output<String>
        get() = javaResource.customKeyStoreName().applyValue({ args0 -> args0 })

    /**
     * Password for `kmsuser` on CloudHSM.
     */
    public val keyStorePassword: Output<String>
        get() = javaResource.keyStorePassword().applyValue({ args0 -> args0 })

    /**
     * Customer certificate used for signing on CloudHSM.
     */
    public val trustAnchorCertificate: Output<String>
        get() = javaResource.trustAnchorCertificate().applyValue({ args0 -> args0 })
}

public object CustomKeyStoreMapper : ResourceMapper<CustomKeyStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.CustomKeyStore::class == javaResource::class

    override fun map(javaResource: Resource): CustomKeyStore = CustomKeyStore(
        javaResource as
            com.pulumi.aws.kms.CustomKeyStore,
    )
}

/**
 * @see [CustomKeyStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomKeyStore].
 */
public suspend fun customKeyStore(
    name: String,
    block: suspend CustomKeyStoreResourceBuilder.() -> Unit,
): CustomKeyStore {
    val builder = CustomKeyStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomKeyStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customKeyStore(name: String): CustomKeyStore {
    val builder = CustomKeyStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
