@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.CustomKeyStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS KMS (Key Management) Custom Key Store.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.CustomKeyStore;
 * import com.pulumi.aws.kms.CustomKeyStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CustomKeyStore("test", CustomKeyStoreArgs.builder()
 *             .cloudHsmClusterId(var_.cloud_hsm_cluster_id())
 *             .customKeyStoreName("kms-custom-key-store-test")
 *             .keyStorePassword("noplaintextpasswords1")
 *             .trustAnchorCertificate(Files.readString(Paths.get("anchor-certificate.crt")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
 * ```
 * @property cloudHsmClusterId Cluster ID of CloudHSM.
 * @property customKeyStoreName Unique name for Custom Key Store.
 * @property keyStorePassword Password for `kmsuser` on CloudHSM.
 * @property trustAnchorCertificate Customer certificate used for signing on CloudHSM.
 */
public data class CustomKeyStoreArgs(
    public val cloudHsmClusterId: Output<String>? = null,
    public val customKeyStoreName: Output<String>? = null,
    public val keyStorePassword: Output<String>? = null,
    public val trustAnchorCertificate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.CustomKeyStoreArgs> {
    override fun toJava(): com.pulumi.aws.kms.CustomKeyStoreArgs =
        com.pulumi.aws.kms.CustomKeyStoreArgs.builder()
            .cloudHsmClusterId(cloudHsmClusterId?.applyValue({ args0 -> args0 }))
            .customKeyStoreName(customKeyStoreName?.applyValue({ args0 -> args0 }))
            .keyStorePassword(keyStorePassword?.applyValue({ args0 -> args0 }))
            .trustAnchorCertificate(trustAnchorCertificate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomKeyStoreArgs].
 */
@PulumiTagMarker
public class CustomKeyStoreArgsBuilder internal constructor() {
    private var cloudHsmClusterId: Output<String>? = null

    private var customKeyStoreName: Output<String>? = null

    private var keyStorePassword: Output<String>? = null

    private var trustAnchorCertificate: Output<String>? = null

    /**
     * @param value Cluster ID of CloudHSM.
     */
    @JvmName("nfymsoecadbbqbky")
    public suspend fun cloudHsmClusterId(`value`: Output<String>) {
        this.cloudHsmClusterId = value
    }

    /**
     * @param value Unique name for Custom Key Store.
     */
    @JvmName("ykgcobhxyoamrqkj")
    public suspend fun customKeyStoreName(`value`: Output<String>) {
        this.customKeyStoreName = value
    }

    /**
     * @param value Password for `kmsuser` on CloudHSM.
     */
    @JvmName("lxfiguwekqijnxdd")
    public suspend fun keyStorePassword(`value`: Output<String>) {
        this.keyStorePassword = value
    }

    /**
     * @param value Customer certificate used for signing on CloudHSM.
     */
    @JvmName("xapypkcghxnevgot")
    public suspend fun trustAnchorCertificate(`value`: Output<String>) {
        this.trustAnchorCertificate = value
    }

    /**
     * @param value Cluster ID of CloudHSM.
     */
    @JvmName("dufgqrjlkhpfcafe")
    public suspend fun cloudHsmClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudHsmClusterId = mapped
    }

    /**
     * @param value Unique name for Custom Key Store.
     */
    @JvmName("lmdyqtvmtanpgatf")
    public suspend fun customKeyStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeyStoreName = mapped
    }

    /**
     * @param value Password for `kmsuser` on CloudHSM.
     */
    @JvmName("qckhmqwxihlguuxt")
    public suspend fun keyStorePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyStorePassword = mapped
    }

    /**
     * @param value Customer certificate used for signing on CloudHSM.
     */
    @JvmName("nguvotskidlihvla")
    public suspend fun trustAnchorCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustAnchorCertificate = mapped
    }

    internal fun build(): CustomKeyStoreArgs = CustomKeyStoreArgs(
        cloudHsmClusterId = cloudHsmClusterId,
        customKeyStoreName = customKeyStoreName,
        keyStorePassword = keyStorePassword,
        trustAnchorCertificate = trustAnchorCertificate,
    )
}
