@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.ExternalKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a single-Region or multi-Region primary KMS key that uses external key material.
 * To instead manage a single-Region or multi-Region primary KMS key where AWS automatically generates and potentially rotates key material, see the `aws.kms.Key` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.ExternalKey;
 * import com.pulumi.aws.kms.ExternalKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExternalKey("example", ExternalKeyArgs.builder()
 *             .description("KMS EXTERNAL for AMI encryption")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS External Keys using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/externalKey:ExternalKey a arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property bypassPolicyLockoutSafetyCheck Specifies whether to disable the policy lockout check performed when creating or updating the key's policy. Setting this value to `true` increases the risk that the key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the AWS Key Management Service Developer Guide. Defaults to `false`.
 * @property deletionWindowInDays Duration in days after which the key is deleted after destruction of the resource. Must be between `7` and `30` days. Defaults to `30`.
 * @property description Description of the key.
 * @property enabled Specifies whether the key is enabled. Keys pending import can only be `false`. Imported keys default to `true` unless expired.
 * @property keyMaterialBase64 Base64 encoded 256-bit symmetric encryption key material to import. The CMK is permanently associated with this key material. The same key material can be reimported, but you cannot import different key material.
 * @property multiRegion Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
 * @property policy A key policy JSON document. If you do not provide a key policy, AWS KMS attaches a default key policy to the CMK.
 * @property tags A key-value map of tags to assign to the key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property validTo Time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. If not specified, key material does not expire. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 */
public data class ExternalKeyArgs(
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null,
    public val deletionWindowInDays: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val keyMaterialBase64: Output<String>? = null,
    public val multiRegion: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validTo: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.ExternalKeyArgs> {
    override fun toJava(): com.pulumi.aws.kms.ExternalKeyArgs =
        com.pulumi.aws.kms.ExternalKeyArgs.builder()
            .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck?.applyValue({ args0 -> args0 }))
            .deletionWindowInDays(deletionWindowInDays?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyMaterialBase64(keyMaterialBase64?.applyValue({ args0 -> args0 }))
            .multiRegion(multiRegion?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validTo(validTo?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExternalKeyArgs].
 */
@PulumiTagMarker
public class ExternalKeyArgsBuilder internal constructor() {
    private var bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null

    private var deletionWindowInDays: Output<Int>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var keyMaterialBase64: Output<String>? = null

    private var multiRegion: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validTo: Output<String>? = null

    /**
     * @param value Specifies whether to disable the policy lockout check performed when creating or updating the key's policy. Setting this value to `true` increases the risk that the key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the AWS Key Management Service Developer Guide. Defaults to `false`.
     */
    @JvmName("vvduidaumoscawrb")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Output<Boolean>) {
        this.bypassPolicyLockoutSafetyCheck = value
    }

    /**
     * @param value Duration in days after which the key is deleted after destruction of the resource. Must be between `7` and `30` days. Defaults to `30`.
     */
    @JvmName("hptysakeivlscatw")
    public suspend fun deletionWindowInDays(`value`: Output<Int>) {
        this.deletionWindowInDays = value
    }

    /**
     * @param value Description of the key.
     */
    @JvmName("bapvgbgcraqtjmte")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the key is enabled. Keys pending import can only be `false`. Imported keys default to `true` unless expired.
     */
    @JvmName("lddtexkyonmjvrng")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Base64 encoded 256-bit symmetric encryption key material to import. The CMK is permanently associated with this key material. The same key material can be reimported, but you cannot import different key material.
     */
    @JvmName("tbpbbcunrnkfmgou")
    public suspend fun keyMaterialBase64(`value`: Output<String>) {
        this.keyMaterialBase64 = value
    }

    /**
     * @param value Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
     */
    @JvmName("ifqkodctepjhrfyk")
    public suspend fun multiRegion(`value`: Output<Boolean>) {
        this.multiRegion = value
    }

    /**
     * @param value A key policy JSON document. If you do not provide a key policy, AWS KMS attaches a default key policy to the CMK.
     */
    @JvmName("ckeahknuhixgqyhp")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value A key-value map of tags to assign to the key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fwbcnjeeaqighmax")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. If not specified, key material does not expire. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("ggggkfrqbbimecvd")
    public suspend fun validTo(`value`: Output<String>) {
        this.validTo = value
    }

    /**
     * @param value Specifies whether to disable the policy lockout check performed when creating or updating the key's policy. Setting this value to `true` increases the risk that the key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the AWS Key Management Service Developer Guide. Defaults to `false`.
     */
    @JvmName("fkgnaednjcosmldk")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPolicyLockoutSafetyCheck = mapped
    }

    /**
     * @param value Duration in days after which the key is deleted after destruction of the resource. Must be between `7` and `30` days. Defaults to `30`.
     */
    @JvmName("mfqjvcqdrvansitk")
    public suspend fun deletionWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionWindowInDays = mapped
    }

    /**
     * @param value Description of the key.
     */
    @JvmName("obpbcnifxmauneai")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the key is enabled. Keys pending import can only be `false`. Imported keys default to `true` unless expired.
     */
    @JvmName("fvcpmpomsyrllqet")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Base64 encoded 256-bit symmetric encryption key material to import. The CMK is permanently associated with this key material. The same key material can be reimported, but you cannot import different key material.
     */
    @JvmName("bjsnrrbtqofdwsdg")
    public suspend fun keyMaterialBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyMaterialBase64 = mapped
    }

    /**
     * @param value Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
     */
    @JvmName("pxrrshtbwfvwqlhy")
    public suspend fun multiRegion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiRegion = mapped
    }

    /**
     * @param value A key policy JSON document. If you do not provide a key policy, AWS KMS attaches a default key policy to the CMK.
     */
    @JvmName("rbegvuhmxkiblqku")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value A key-value map of tags to assign to the key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fdiqigulbsvobpqx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A key-value map of tags to assign to the key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hbenxcmruvxtpqun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. If not specified, key material does not expire. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("gqptftvpwvfrhxsl")
    public suspend fun validTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validTo = mapped
    }

    internal fun build(): ExternalKeyArgs = ExternalKeyArgs(
        bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck,
        deletionWindowInDays = deletionWindowInDays,
        description = description,
        enabled = enabled,
        keyMaterialBase64 = keyMaterialBase64,
        multiRegion = multiRegion,
        policy = policy,
        tags = tags,
        validTo = validTo,
    )
}
