@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.kotlin.outputs.GrantConstraint
import com.pulumi.aws.kms.kotlin.outputs.GrantConstraint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Grant].
 */
@PulumiTagMarker
public class GrantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GrantArgs = GrantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GrantArgsBuilder.() -> Unit) {
        val builder = GrantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Grant {
        val builtJavaResource = com.pulumi.aws.kms.Grant(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Grant(builtJavaResource)
    }
}

/**
 * Provides a resource-based access control mechanism for a KMS customer master key.
 * ## Import
 * Using `pulumi import`, import KMS Grants using the Key ID and Grant ID separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:kms/grant:Grant test 1234abcd-12ab-34cd-56ef-1234567890ab:abcde1237f76e4ba7987489ac329fbfba6ad343d6f7075dbd1ef191f0120514
 * ```
 *
 */
public class Grant internal constructor(
    override val javaResource: com.pulumi.aws.kms.Grant,
) : KotlinCustomResource(javaResource, GrantMapper) {
    /**
     * A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    public val constraints: Output<List<GrantConstraint>>?
        get() = javaResource.constraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
     */
    public val grantCreationTokens: Output<List<String>>?
        get() = javaResource.grantCreationTokens().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The unique identifier for the grant.
     */
    public val grantId: Output<String>
        get() = javaResource.grantId().applyValue({ args0 -> args0 })

    /**
     * The grant token for the created grant. For more information, see [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
     */
    public val grantToken: Output<String>
        get() = javaResource.grantToken().applyValue({ args0 -> args0 })

    /**
     * The principal that is given permission to perform the operations that the grant permits in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    public val granteePrincipal: Output<String>
        get() = javaResource.granteePrincipal().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * A friendly name for identifying the grant.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
     */
    public val operations: Output<List<String>>
        get() = javaResource.operations().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * If set to false (the default) the grants will be revoked upon deletion, and if set to true the grants will try to be retired upon deletion. Note that retiring grants requires special permissions, hence why we default to revoking grants.
     * See [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) for more information.
     */
    public val retireOnDelete: Output<Boolean>?
        get() = javaResource.retireOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The principal that is given permission to retire the grant by using RetireGrant operation in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    public val retiringPrincipal: Output<String>?
        get() = javaResource.retiringPrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GrantMapper : ResourceMapper<Grant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.Grant::class == javaResource::class

    override fun map(javaResource: Resource): Grant = Grant(javaResource as com.pulumi.aws.kms.Grant)
}

/**
 * @see [Grant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Grant].
 */
public suspend fun grant(name: String, block: suspend GrantResourceBuilder.() -> Unit): Grant {
    val builder = GrantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Grant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun grant(name: String): Grant {
    val builder = GrantResourceBuilder()
    builder.name(name)
    return builder.build()
}
