@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.KeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a single-Region or multi-Region primary KMS key.
 * > **NOTE on KMS Key Policy:** KMS Key Policy can be configured in either the standalone resource `aws.kms.KeyPolicy`
 * or with the parameter `policy` in this resource.
 * Configuring with both will cause inconsistencies and may overwrite configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .deletionWindowInDays(10)
 *             .description("KMS key 1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS Keys using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/key:Key a 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property bypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety check.
 * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
 * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
 * The default value is `false`.
 * @property customKeyStoreId ID of the KMS [Custom Key Store](https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html) where the key will be stored instead of KMS (eg CloudHSM).
 * @property customerMasterKeySpec Specifies whether the key contains a symmetric key or an asymmetric key pair and the encryption algorithms or signing algorithms that the key supports.
 * Valid values: `SYMMETRIC_DEFAULT`,  `RSA_2048`, `RSA_3072`, `RSA_4096`, `HMAC_256`, `ECC_NIST_P256`, `ECC_NIST_P384`, `ECC_NIST_P521`, or `ECC_SECG_P256K1`. Defaults to `SYMMETRIC_DEFAULT`. For help with choosing a key spec, see the [AWS KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html).
 * @property deletionWindowInDays The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
 * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
 * If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
 * @property description The description of the key as viewed in AWS console.
 * @property enableKeyRotation Specifies whether [key rotation](http://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) is enabled. Defaults to `false`.
 * @property isEnabled Specifies whether the key is enabled. Defaults to `true`.
 * @property keyUsage Specifies the intended use of the key. Valid values: `ENCRYPT_DECRYPT`, `SIGN_VERIFY`, or `GENERATE_VERIFY_MAC`.
 * Defaults to `ENCRYPT_DECRYPT`.
 * @property multiRegion Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
 * @property policy A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used.
 * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
 * @property tags A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class KeyArgs(
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null,
    public val customKeyStoreId: Output<String>? = null,
    public val customerMasterKeySpec: Output<String>? = null,
    public val deletionWindowInDays: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val enableKeyRotation: Output<Boolean>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val keyUsage: Output<String>? = null,
    public val multiRegion: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.KeyArgs> {
    override fun toJava(): com.pulumi.aws.kms.KeyArgs = com.pulumi.aws.kms.KeyArgs.builder()
        .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck?.applyValue({ args0 -> args0 }))
        .customKeyStoreId(customKeyStoreId?.applyValue({ args0 -> args0 }))
        .customerMasterKeySpec(customerMasterKeySpec?.applyValue({ args0 -> args0 }))
        .deletionWindowInDays(deletionWindowInDays?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .enableKeyRotation(enableKeyRotation?.applyValue({ args0 -> args0 }))
        .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
        .keyUsage(keyUsage?.applyValue({ args0 -> args0 }))
        .multiRegion(multiRegion?.applyValue({ args0 -> args0 }))
        .policy(policy?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [KeyArgs].
 */
@PulumiTagMarker
public class KeyArgsBuilder internal constructor() {
    private var bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null

    private var customKeyStoreId: Output<String>? = null

    private var customerMasterKeySpec: Output<String>? = null

    private var deletionWindowInDays: Output<Int>? = null

    private var description: Output<String>? = null

    private var enableKeyRotation: Output<Boolean>? = null

    private var isEnabled: Output<Boolean>? = null

    private var keyUsage: Output<String>? = null

    private var multiRegion: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    @JvmName("jtabmgpxcjqhqsvm")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Output<Boolean>) {
        this.bypassPolicyLockoutSafetyCheck = value
    }

    /**
     * @param value ID of the KMS [Custom Key Store](https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html) where the key will be stored instead of KMS (eg CloudHSM).
     */
    @JvmName("lqprdrjmbxtagfqj")
    public suspend fun customKeyStoreId(`value`: Output<String>) {
        this.customKeyStoreId = value
    }

    /**
     * @param value Specifies whether the key contains a symmetric key or an asymmetric key pair and the encryption algorithms or signing algorithms that the key supports.
     * Valid values: `SYMMETRIC_DEFAULT`,  `RSA_2048`, `RSA_3072`, `RSA_4096`, `HMAC_256`, `ECC_NIST_P256`, `ECC_NIST_P384`, `ECC_NIST_P521`, or `ECC_SECG_P256K1`. Defaults to `SYMMETRIC_DEFAULT`. For help with choosing a key spec, see the [AWS KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html).
     */
    @JvmName("hjsjeteecyxdhkgy")
    public suspend fun customerMasterKeySpec(`value`: Output<String>) {
        this.customerMasterKeySpec = value
    }

    /**
     * @param value The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     * If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
     */
    @JvmName("iuhplbfjecuvyiil")
    public suspend fun deletionWindowInDays(`value`: Output<Int>) {
        this.deletionWindowInDays = value
    }

    /**
     * @param value The description of the key as viewed in AWS console.
     */
    @JvmName("nnmrwolumvwasqyd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether [key rotation](http://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) is enabled. Defaults to `false`.
     */
    @JvmName("ptiwusqyfonfupml")
    public suspend fun enableKeyRotation(`value`: Output<Boolean>) {
        this.enableKeyRotation = value
    }

    /**
     * @param value Specifies whether the key is enabled. Defaults to `true`.
     */
    @JvmName("ioehbgfxsolvrbas")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Specifies the intended use of the key. Valid values: `ENCRYPT_DECRYPT`, `SIGN_VERIFY`, or `GENERATE_VERIFY_MAC`.
     * Defaults to `ENCRYPT_DECRYPT`.
     */
    @JvmName("kjtaeossrlqgyxxs")
    public suspend fun keyUsage(`value`: Output<String>) {
        this.keyUsage = value
    }

    /**
     * @param value Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
     */
    @JvmName("qqeqkdantougjrkp")
    public suspend fun multiRegion(`value`: Output<Boolean>) {
        this.multiRegion = value
    }

    /**
     * @param value A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used.
     * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
     */
    @JvmName("ipehugnmejjvitns")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rtrjpdrdmkcltfws")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    @JvmName("pfqujddjsogdnwrg")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPolicyLockoutSafetyCheck = mapped
    }

    /**
     * @param value ID of the KMS [Custom Key Store](https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html) where the key will be stored instead of KMS (eg CloudHSM).
     */
    @JvmName("sqnmnjygqedispol")
    public suspend fun customKeyStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeyStoreId = mapped
    }

    /**
     * @param value Specifies whether the key contains a symmetric key or an asymmetric key pair and the encryption algorithms or signing algorithms that the key supports.
     * Valid values: `SYMMETRIC_DEFAULT`,  `RSA_2048`, `RSA_3072`, `RSA_4096`, `HMAC_256`, `ECC_NIST_P256`, `ECC_NIST_P384`, `ECC_NIST_P521`, or `ECC_SECG_P256K1`. Defaults to `SYMMETRIC_DEFAULT`. For help with choosing a key spec, see the [AWS KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html).
     */
    @JvmName("kqwccttoopaklriy")
    public suspend fun customerMasterKeySpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerMasterKeySpec = mapped
    }

    /**
     * @param value The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     * If the KMS key is a multi-Region primary key with replicas, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
     */
    @JvmName("kjsetkmfncwyeije")
    public suspend fun deletionWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionWindowInDays = mapped
    }

    /**
     * @param value The description of the key as viewed in AWS console.
     */
    @JvmName("uoqkyqruosvecrvp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether [key rotation](http://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) is enabled. Defaults to `false`.
     */
    @JvmName("mfvweesthasomxpc")
    public suspend fun enableKeyRotation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableKeyRotation = mapped
    }

    /**
     * @param value Specifies whether the key is enabled. Defaults to `true`.
     */
    @JvmName("mwiiudturucmoamj")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Specifies the intended use of the key. Valid values: `ENCRYPT_DECRYPT`, `SIGN_VERIFY`, or `GENERATE_VERIFY_MAC`.
     * Defaults to `ENCRYPT_DECRYPT`.
     */
    @JvmName("ijscedeoryvsvwsu")
    public suspend fun keyUsage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUsage = mapped
    }

    /**
     * @param value Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
     */
    @JvmName("nanmnqveeeusoden")
    public suspend fun multiRegion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiRegion = mapped
    }

    /**
     * @param value A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used.
     * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
     */
    @JvmName("ujiesgahxdvkrbsu")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xclwcjoqaecedexp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hbopyoigywagyohk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KeyArgs = KeyArgs(
        bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck,
        customKeyStoreId = customKeyStoreId,
        customerMasterKeySpec = customerMasterKeySpec,
        deletionWindowInDays = deletionWindowInDays,
        description = description,
        enableKeyRotation = enableKeyRotation,
        isEnabled = isEnabled,
        keyUsage = keyUsage,
        multiRegion = multiRegion,
        policy = policy,
        tags = tags,
    )
}
