@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyPolicy].
 */
@PulumiTagMarker
public class KeyPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPolicyArgs = KeyPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPolicyArgsBuilder.() -> Unit) {
        val builder = KeyPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyPolicy {
        val builtJavaResource = com.pulumi.aws.kms.KeyPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPolicy(builtJavaResource)
    }
}

/**
 * Attaches a policy to a KMS Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.KeyPolicy;
 * import com.pulumi.aws.kms.KeyPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleKeyPolicy = new KeyPolicy("exampleKeyPolicy", KeyPolicyArgs.builder()
 *             .keyId(exampleKey.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Id", "example"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "kms:*"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Sid", "Enable IAM User Permissions")
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS Key Policies using the `key_id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/keyPolicy:KeyPolicy a 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 *
 */
public class KeyPolicy internal constructor(
    override val javaResource: com.pulumi.aws.kms.KeyPolicy,
) : KotlinCustomResource(javaResource, KeyPolicyMapper) {
    /**
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately. If this value is set, and the resource is destroyed, a warning will be shown, and the resource will be removed from state.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     */
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>?
        get() = javaResource.bypassPolicyLockoutSafetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS Key to attach the policy.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used. For more information about building policy documents, see the AWS IAM Policy Document Guide.
     * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, or this resource is destroyed, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object KeyPolicyMapper : ResourceMapper<KeyPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.KeyPolicy::class == javaResource::class

    override fun map(javaResource: Resource): KeyPolicy = KeyPolicy(
        javaResource as
            com.pulumi.aws.kms.KeyPolicy,
    )
}

/**
 * @see [KeyPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPolicy].
 */
public suspend fun keyPolicy(name: String, block: suspend KeyPolicyResourceBuilder.() -> Unit):
    KeyPolicy {
    val builder = KeyPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPolicy(name: String): KeyPolicy {
    val builder = KeyPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
