@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.KeyPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a policy to a KMS Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.KeyPolicy;
 * import com.pulumi.aws.kms.KeyPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleKeyPolicy = new KeyPolicy("exampleKeyPolicy", KeyPolicyArgs.builder()
 *             .keyId(exampleKey.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Id", "example"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "kms:*"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Sid", "Enable IAM User Permissions")
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS Key Policies using the `key_id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/keyPolicy:KeyPolicy a 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property bypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety check.
 * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately. If this value is set, and the resource is destroyed, a warning will be shown, and the resource will be removed from state.
 * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
 * @property keyId The ID of the KMS Key to attach the policy.
 * @property policy A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used. For more information about building policy documents, see the AWS IAM Policy Document Guide.
 * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, or this resource is destroyed, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
 */
public data class KeyPolicyArgs(
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null,
    public val keyId: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.KeyPolicyArgs> {
    override fun toJava(): com.pulumi.aws.kms.KeyPolicyArgs =
        com.pulumi.aws.kms.KeyPolicyArgs.builder()
            .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck?.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPolicyArgs].
 */
@PulumiTagMarker
public class KeyPolicyArgsBuilder internal constructor() {
    private var bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null

    private var keyId: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately. If this value is set, and the resource is destroyed, a warning will be shown, and the resource will be removed from state.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     */
    @JvmName("ptjmjsfixhlifdja")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Output<Boolean>) {
        this.bypassPolicyLockoutSafetyCheck = value
    }

    /**
     * @param value The ID of the KMS Key to attach the policy.
     */
    @JvmName("vlmkmsybvbovcbyj")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used. For more information about building policy documents, see the AWS IAM Policy Document Guide.
     * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, or this resource is destroyed, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
     */
    @JvmName("tdgasveminlptyfu")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately. If this value is set, and the resource is destroyed, a warning will be shown, and the resource will be removed from state.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     */
    @JvmName("funksewociihuxjp")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPolicyLockoutSafetyCheck = mapped
    }

    /**
     * @param value The ID of the KMS Key to attach the policy.
     */
    @JvmName("laklrvriiyisvmph")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value A valid policy JSON document. Although this is a key policy, not an IAM policy, an `aws.iam.getPolicyDocument`, in the form that designates a principal, can be used. For more information about building policy documents, see the AWS IAM Policy Document Guide.
     * > **NOTE:** Note: All KMS keys must have a key policy. If a key policy is not specified, or this resource is destroyed, AWS gives the KMS key a [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) that gives all principals in the owning account unlimited access to all KMS operations for the key. This default key policy effectively delegates all access control to IAM policies and KMS grants.
     */
    @JvmName("kvtyfrobqyfmeaie")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): KeyPolicyArgs = KeyPolicyArgs(
        bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck,
        keyId = keyId,
        policy = policy,
    )
}
