@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.KmsFunctions.getAliasPlain
import com.pulumi.aws.kms.KmsFunctions.getCipherTextPlain
import com.pulumi.aws.kms.KmsFunctions.getCustomKeyStorePlain
import com.pulumi.aws.kms.KmsFunctions.getKeyPlain
import com.pulumi.aws.kms.KmsFunctions.getPublicKeyPlain
import com.pulumi.aws.kms.KmsFunctions.getSecretPlain
import com.pulumi.aws.kms.KmsFunctions.getSecretsPlain
import com.pulumi.aws.kms.kotlin.inputs.GetAliasPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetAliasPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetCipherTextPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetCipherTextPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetCustomKeyStorePlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetCustomKeyStorePlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetKeyPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetKeyPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetPublicKeyPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetPublicKeyPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetSecretSecret
import com.pulumi.aws.kms.kotlin.inputs.GetSecretsPlainArgs
import com.pulumi.aws.kms.kotlin.inputs.GetSecretsPlainArgsBuilder
import com.pulumi.aws.kms.kotlin.inputs.GetSecretsSecret
import com.pulumi.aws.kms.kotlin.outputs.GetAliasResult
import com.pulumi.aws.kms.kotlin.outputs.GetCipherTextResult
import com.pulumi.aws.kms.kotlin.outputs.GetCustomKeyStoreResult
import com.pulumi.aws.kms.kotlin.outputs.GetKeyResult
import com.pulumi.aws.kms.kotlin.outputs.GetPublicKeyResult
import com.pulumi.aws.kms.kotlin.outputs.GetSecretResult
import com.pulumi.aws.kms.kotlin.outputs.GetSecretsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.kms.kotlin.outputs.GetAliasResult.Companion.toKotlin as getAliasResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetCipherTextResult.Companion.toKotlin as getCipherTextResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetCustomKeyStoreResult.Companion.toKotlin as getCustomKeyStoreResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetKeyResult.Companion.toKotlin as getKeyResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetPublicKeyResult.Companion.toKotlin as getPublicKeyResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.aws.kms.kotlin.outputs.GetSecretsResult.Companion.toKotlin as getSecretsResultToKotlin

public object KmsFunctions {
    /**
     * Use this data source to get the ARN of a KMS key alias.
     * By using this data source, you can reference key alias
     * without having to hard code the ARN as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kms.KmsFunctions;
     * import com.pulumi.aws.kms.inputs.GetAliasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = KmsFunctions.getAlias(GetAliasArgs.builder()
     *             .name("alias/aws/s3")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAlias.
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: GetAliasPlainArgs): GetAliasResult =
        getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())

    /**
     * @see [getAlias].
     * @param name Display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(name: String): GetAliasResult {
        val argument = GetAliasPlainArgs(
            name = name,
        )
        return getAliasResultToKotlin(getAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlias].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetAliasPlainArgs].
     * @return A collection of values returned by getAlias.
     */
    public suspend fun getAlias(argument: suspend GetAliasPlainArgsBuilder.() -> Unit):
        GetAliasResult {
        val builder = GetAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAliasResultToKotlin(getAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * The KMS ciphertext data source allows you to encrypt plaintext into ciphertext
     * by using an AWS KMS customer master key. The value returned by this data source
     * changes every apply. For a stable ciphertext value, see the `aws.kms.Ciphertext`
     * resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kms.Key;
     * import com.pulumi.aws.kms.KeyArgs;
     * import com.pulumi.aws.kms.KmsFunctions;
     * import com.pulumi.aws.kms.inputs.GetCipherTextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var oauthConfig = new Key("oauthConfig", KeyArgs.builder()
     *             .description("oauth config")
     *             .isEnabled(true)
     *             .build());
     *         final var oauth = KmsFunctions.getCipherText(GetCipherTextArgs.builder()
     *             .keyId(oauthConfig.keyId())
     *             .plaintext("""
     * {
     *   "client_id": "e587dbae22222f55da22",
     *   "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
     * }
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCipherText.
     * @return A collection of values returned by getCipherText.
     */
    public suspend fun getCipherText(argument: GetCipherTextPlainArgs): GetCipherTextResult =
        getCipherTextResultToKotlin(getCipherTextPlain(argument.toJava()).await())

    /**
     * @see [getCipherText].
     * @param context An optional mapping that makes up the encryption context.
     * @param keyId Globally unique key ID for the customer master key.
     * @param plaintext Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
     * @return A collection of values returned by getCipherText.
     */
    public suspend fun getCipherText(
        context: Map<String, String>? = null,
        keyId: String,
        plaintext: String,
    ): GetCipherTextResult {
        val argument = GetCipherTextPlainArgs(
            context = context,
            keyId = keyId,
            plaintext = plaintext,
        )
        return getCipherTextResultToKotlin(getCipherTextPlain(argument.toJava()).await())
    }

    /**
     * @see [getCipherText].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetCipherTextPlainArgs].
     * @return A collection of values returned by getCipherText.
     */
    public suspend fun getCipherText(argument: suspend GetCipherTextPlainArgsBuilder.() -> Unit):
        GetCipherTextResult {
        val builder = GetCipherTextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCipherTextResultToKotlin(getCipherTextPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the metadata KMS custom key store.
     * By using this data source, you can reference KMS custom key store
     * without having to hard code the ID as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kms.KmsFunctions;
     * import com.pulumi.aws.kms.inputs.GetCustomKeyStoreArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var keystore = KmsFunctions.getCustomKeyStore(GetCustomKeyStoreArgs.builder()
     *             .customKeyStoreName("my_cloudhsm")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCustomKeyStore.
     * @return A collection of values returned by getCustomKeyStore.
     */
    public suspend fun getCustomKeyStore(argument: GetCustomKeyStorePlainArgs):
        GetCustomKeyStoreResult =
        getCustomKeyStoreResultToKotlin(getCustomKeyStorePlain(argument.toJava()).await())

    /**
     * @see [getCustomKeyStore].
     * @param customKeyStoreId The ID for the custom key store.
     * @param customKeyStoreName The user-specified friendly name for the custom key store.
     * @return A collection of values returned by getCustomKeyStore.
     */
    public suspend fun getCustomKeyStore(
        customKeyStoreId: String? = null,
        customKeyStoreName: String? =
            null,
    ): GetCustomKeyStoreResult {
        val argument = GetCustomKeyStorePlainArgs(
            customKeyStoreId = customKeyStoreId,
            customKeyStoreName = customKeyStoreName,
        )
        return getCustomKeyStoreResultToKotlin(getCustomKeyStorePlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomKeyStore].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetCustomKeyStorePlainArgs].
     * @return A collection of values returned by getCustomKeyStore.
     */
    public suspend
    fun getCustomKeyStore(argument: suspend GetCustomKeyStorePlainArgsBuilder.() -> Unit):
        GetCustomKeyStoreResult {
        val builder = GetCustomKeyStorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomKeyStoreResultToKotlin(getCustomKeyStorePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get detailed information about
     * the specified KMS Key with flexible key id input.
     * This can be useful to reference key alias
     * without having to hard code the ARN as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kms.KmsFunctions;
     * import com.pulumi.aws.kms.inputs.GetKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byAlias = KmsFunctions.getKey(GetKeyArgs.builder()
     *             .keyId("alias/my-key")
     *             .build());
     *         final var byId = KmsFunctions.getKey(GetKeyArgs.builder()
     *             .keyId("1234abcd-12ab-34cd-56ef-1234567890ab")
     *             .build());
     *         final var byAliasArn = KmsFunctions.getKey(GetKeyArgs.builder()
     *             .keyId("arn:aws:kms:us-east-1:111122223333:alias/my-key")
     *             .build());
     *         final var byKeyArn = KmsFunctions.getKey(GetKeyArgs.builder()
     *             .keyId("arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getKey.
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(argument: GetKeyPlainArgs): GetKeyResult =
        getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())

    /**
     * @see [getKey].
     * @param grantTokens List of grant tokens
     * @param keyId Key identifier which can be one of the following format:
     * * Key ID. E.g: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Key ARN. E.g.: `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Alias name. E.g.: `alias/my-key`
     * * Alias ARN: E.g.: `arn:aws:kms:us-east-1:111122223333:alias/my-key`
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(grantTokens: List<String>? = null, keyId: String): GetKeyResult {
        val argument = GetKeyPlainArgs(
            grantTokens = grantTokens,
            keyId = keyId,
        )
        return getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetKeyPlainArgs].
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(argument: suspend GetKeyPlainArgsBuilder.() -> Unit): GetKeyResult {
        val builder = GetKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyResultToKotlin(getKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the public key about the specified KMS Key with flexible key id input. This can be useful to reference key alias without having to hard code the ARN as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kms.KmsFunctions;
     * import com.pulumi.aws.kms.inputs.GetPublicKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byAlias = KmsFunctions.getPublicKey(GetPublicKeyArgs.builder()
     *             .keyId("alias/my-key")
     *             .build());
     *         final var byId = KmsFunctions.getPublicKey(GetPublicKeyArgs.builder()
     *             .keyId("1234abcd-12ab-34cd-56ef-1234567890ab")
     *             .build());
     *         final var byAliasArn = KmsFunctions.getPublicKey(GetPublicKeyArgs.builder()
     *             .keyId("arn:aws:kms:us-east-1:111122223333:alias/my-key")
     *             .build());
     *         final var byKeyArn = KmsFunctions.getPublicKey(GetPublicKeyArgs.builder()
     *             .keyId("arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPublicKey.
     * @return A collection of values returned by getPublicKey.
     */
    public suspend fun getPublicKey(argument: GetPublicKeyPlainArgs): GetPublicKeyResult =
        getPublicKeyResultToKotlin(getPublicKeyPlain(argument.toJava()).await())

    /**
     * @see [getPublicKey].
     * @param grantTokens List of grant tokens
     * @param keyId Key identifier which can be one of the following format:
     * * Key ID. E.g - `1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Key ARN. E.g. - `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Alias name. E.g. - `alias/my-key`
     * * Alias ARN - E.g. - `arn:aws:kms:us-east-1:111122223333:alias/my-key`
     * @return A collection of values returned by getPublicKey.
     */
    public suspend fun getPublicKey(grantTokens: List<String>? = null, keyId: String):
        GetPublicKeyResult {
        val argument = GetPublicKeyPlainArgs(
            grantTokens = grantTokens,
            keyId = keyId,
        )
        return getPublicKeyResultToKotlin(getPublicKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetPublicKeyPlainArgs].
     * @return A collection of values returned by getPublicKey.
     */
    public suspend fun getPublicKey(argument: suspend GetPublicKeyPlainArgsBuilder.() -> Unit):
        GetPublicKeyResult {
        val builder = GetPublicKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicKeyResultToKotlin(getPublicKeyPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getSecret.
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param secrets
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(secrets: List<GetSecretSecret>): GetSecretResult {
        val argument = GetSecretPlainArgs(
            secrets = secrets,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit):
        GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Decrypt multiple secrets from data encrypted with the AWS KMS service.
     * @param argument A collection of arguments for invoking getSecrets.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: GetSecretsPlainArgs): GetSecretsResult =
        getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())

    /**
     * @see [getSecrets].
     * @param secrets One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(secrets: List<GetSecretsSecret>): GetSecretsResult {
        val argument = GetSecretsPlainArgs(
            secrets = secrets,
        )
        return getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kms&#46;kotlin&#46;inputs&#46;GetSecretsPlainArgs].
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: suspend GetSecretsPlainArgsBuilder.() -> Unit):
        GetSecretsResult {
        val builder = GetSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretsResultToKotlin(getSecretsPlain(builtArgument.toJava()).await())
    }
}
