@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReplicaExternalKey].
 */
@PulumiTagMarker
public class ReplicaExternalKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicaExternalKeyArgs = ReplicaExternalKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicaExternalKeyArgsBuilder.() -> Unit) {
        val builder = ReplicaExternalKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicaExternalKey {
        val builtJavaResource = com.pulumi.aws.kms.ReplicaExternalKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicaExternalKey(builtJavaResource)
    }
}

/**
 * Manages a KMS multi-Region replica key that uses external key material.
 * See the [AWS KMS Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-import.html) for more information on importing key material into multi-Region keys.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.kms.ExternalKey;
 * import com.pulumi.aws.kms.ExternalKeyArgs;
 * import com.pulumi.aws.kms.ReplicaExternalKey;
 * import com.pulumi.aws.kms.ReplicaExternalKeyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Provider("primary", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var primaryExternalKey = new ExternalKey("primaryExternalKey", ExternalKeyArgs.builder()
 *             .description("Multi-Region primary key")
 *             .deletionWindowInDays(30)
 *             .multiRegion(true)
 *             .enabled(true)
 *             .keyMaterialBase64("...")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.primary())
 *                 .build());
 *         var replica = new ReplicaExternalKey("replica", ReplicaExternalKeyArgs.builder()
 *             .description("Multi-Region replica key")
 *             .deletionWindowInDays(7)
 *             .primaryKeyArn(aws_kms_external.primary().arn())
 *             .keyMaterialBase64("...")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import KMS multi-Region replica keys using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:kms/replicaExternalKey:ReplicaExternalKey example 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 *
 */
public class ReplicaExternalKey internal constructor(
    override val javaResource: com.pulumi.aws.kms.ReplicaExternalKey,
) : KotlinCustomResource(javaResource, ReplicaExternalKeyMapper) {
    /**
     * The Amazon Resource Name (ARN) of the replica key. The key ARNs of related multi-Region keys differ only in the Region value.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>?
        get() = javaResource.bypassPolicyLockoutSafetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     */
    public val deletionWindowInDays: Output<Int>?
        get() = javaResource.deletionWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the KMS key.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations. Keys pending import can only be `false`. Imported keys default to `true` unless expired.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Whether the key material expires. Empty when pending key material import, otherwise `KEY_MATERIAL_EXPIRES` or `KEY_MATERIAL_DOES_NOT_EXPIRE`.
     */
    public val expirationModel: Output<String>
        get() = javaResource.expirationModel().applyValue({ args0 -> args0 })

    /**
     * The key ID of the replica key. Related multi-Region keys have the same key ID.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * Base64 encoded 256-bit symmetric encryption key material to import. The KMS key is permanently associated with this key material. The same key material can be [reimported](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material), but you cannot import different key material.
     */
    public val keyMaterialBase64: Output<String>?
        get() = javaResource.keyMaterialBase64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the replica key.
     */
    public val keyState: Output<String>
        get() = javaResource.keyState().applyValue({ args0 -> args0 })

    /**
     * The [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. This is a shared property of multi-Region keys.
     */
    public val keyUsage: Output<String>
        get() = javaResource.keyUsage().applyValue({ args0 -> args0 })

    /**
     * The key policy to attach to the KMS key. If you do not specify a key policy, AWS KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The ARN of the multi-Region primary key to replicate. The primary key must be in a different AWS Region of the same AWS Partition. You can create only one replica of a given primary key in each AWS Region.
     */
    public val primaryKeyArn: Output<String>
        get() = javaResource.primaryKeyArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the key becomes unusable. If not specified, key material does not expire. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val validTo: Output<String>?
        get() = javaResource.validTo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ReplicaExternalKeyMapper : ResourceMapper<ReplicaExternalKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.ReplicaExternalKey::class == javaResource::class

    override fun map(javaResource: Resource): ReplicaExternalKey = ReplicaExternalKey(
        javaResource as
            com.pulumi.aws.kms.ReplicaExternalKey,
    )
}

/**
 * @see [ReplicaExternalKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicaExternalKey].
 */
public suspend fun replicaExternalKey(
    name: String,
    block: suspend ReplicaExternalKeyResourceBuilder.() -> Unit,
): ReplicaExternalKey {
    val builder = ReplicaExternalKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicaExternalKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicaExternalKey(name: String): ReplicaExternalKey {
    val builder = ReplicaExternalKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
