@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetCipherTextPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCipherText.
 * @property context An optional mapping that makes up the encryption context.
 * @property keyId Globally unique key ID for the customer master key.
 * @property plaintext Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
 */
public data class GetCipherTextPlainArgs(
    public val context: Map<String, String>? = null,
    public val keyId: String,
    public val plaintext: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetCipherTextPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetCipherTextPlainArgs =
        com.pulumi.aws.kms.inputs.GetCipherTextPlainArgs.builder()
            .context(context?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .keyId(keyId.let({ args0 -> args0 }))
            .plaintext(plaintext.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCipherTextPlainArgs].
 */
@PulumiTagMarker
public class GetCipherTextPlainArgsBuilder internal constructor() {
    private var context: Map<String, String>? = null

    private var keyId: String? = null

    private var plaintext: String? = null

    /**
     * @param value An optional mapping that makes up the encryption context.
     */
    @JvmName("jbldkiktnsnayjhy")
    public suspend fun context(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param values An optional mapping that makes up the encryption context.
     */
    @JvmName("ghqfqeygfjlvfvti")
    public fun context(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param value Globally unique key ID for the customer master key.
     */
    @JvmName("enjkgnkbcoxertit")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyId = mapped
    }

    /**
     * @param value Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
     */
    @JvmName("xikcheuugadqcgqh")
    public suspend fun plaintext(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.plaintext = mapped
    }

    internal fun build(): GetCipherTextPlainArgs = GetCipherTextPlainArgs(
        context = context,
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        plaintext = plaintext ?: throw PulumiNullFieldException("plaintext"),
    )
}
