@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetCustomKeyStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomKeyStore.
 * @property customKeyStoreId The ID for the custom key store.
 * @property customKeyStoreName The user-specified friendly name for the custom key store.
 */
public data class GetCustomKeyStorePlainArgs(
    public val customKeyStoreId: String? = null,
    public val customKeyStoreName: String? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetCustomKeyStorePlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetCustomKeyStorePlainArgs =
        com.pulumi.aws.kms.inputs.GetCustomKeyStorePlainArgs.builder()
            .customKeyStoreId(customKeyStoreId?.let({ args0 -> args0 }))
            .customKeyStoreName(customKeyStoreName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomKeyStorePlainArgs].
 */
@PulumiTagMarker
public class GetCustomKeyStorePlainArgsBuilder internal constructor() {
    private var customKeyStoreId: String? = null

    private var customKeyStoreName: String? = null

    /**
     * @param value The ID for the custom key store.
     */
    @JvmName("bfirsreaxfpchfsy")
    public suspend fun customKeyStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customKeyStoreId = mapped
    }

    /**
     * @param value The user-specified friendly name for the custom key store.
     */
    @JvmName("rgodgojdbicqpcuo")
    public suspend fun customKeyStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customKeyStoreName = mapped
    }

    internal fun build(): GetCustomKeyStorePlainArgs = GetCustomKeyStorePlainArgs(
        customKeyStoreId = customKeyStoreId,
        customKeyStoreName = customKeyStoreName,
    )
}
