@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetPublicKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPublicKey.
 * @property grantTokens List of grant tokens
 * @property keyId Key identifier which can be one of the following format:
 * * Key ID. E.g - `1234abcd-12ab-34cd-56ef-1234567890ab`
 * * Key ARN. E.g. - `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
 * * Alias name. E.g. - `alias/my-key`
 * * Alias ARN - E.g. - `arn:aws:kms:us-east-1:111122223333:alias/my-key`
 */
public data class GetPublicKeyPlainArgs(
    public val grantTokens: List<String>? = null,
    public val keyId: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetPublicKeyPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetPublicKeyPlainArgs =
        com.pulumi.aws.kms.inputs.GetPublicKeyPlainArgs.builder()
            .grantTokens(grantTokens?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyId(keyId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublicKeyPlainArgs].
 */
@PulumiTagMarker
public class GetPublicKeyPlainArgsBuilder internal constructor() {
    private var grantTokens: List<String>? = null

    private var keyId: String? = null

    /**
     * @param value List of grant tokens
     */
    @JvmName("aqyanplmhlohphwu")
    public suspend fun grantTokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param values List of grant tokens
     */
    @JvmName("fohauvucesrgcabu")
    public suspend fun grantTokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param value Key identifier which can be one of the following format:
     * * Key ID. E.g - `1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Key ARN. E.g. - `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Alias name. E.g. - `alias/my-key`
     * * Alias ARN - E.g. - `arn:aws:kms:us-east-1:111122223333:alias/my-key`
     */
    @JvmName("lxtdanvxwfgbylmf")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyId = mapped
    }

    internal fun build(): GetPublicKeyPlainArgs = GetPublicKeyPlainArgs(
        grantTokens = grantTokens,
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
    )
}
