@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetSecretPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecret.
 * @property secrets
 */
public data class GetSecretPlainArgs(
    public val secrets: List<GetSecretSecret>,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetSecretPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetSecretPlainArgs =
        com.pulumi.aws.kms.inputs.GetSecretPlainArgs.builder()
            .secrets(
                secrets.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSecretPlainArgs].
 */
@PulumiTagMarker
public class GetSecretPlainArgsBuilder internal constructor() {
    private var secrets: List<GetSecretSecret>? = null

    /**
     * @param value
     */
    @JvmName("xabjrjmqjuakoijr")
    public suspend fun secrets(`value`: List<GetSecretSecret>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secrets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("muvsvprhyjjqbwyw")
    public suspend fun secrets(argument: List<suspend GetSecretSecretBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetSecretSecretBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xpvgjahiwjtuyqbe")
    public suspend fun secrets(vararg argument: suspend GetSecretSecretBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetSecretSecretBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hhrxmyfkulajktnx")
    public suspend fun secrets(argument: suspend GetSecretSecretBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecretSecretBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param values
     */
    @JvmName("eeovinyhhftkvkyi")
    public suspend fun secrets(vararg values: GetSecretSecret) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secrets = mapped
    }

    internal fun build(): GetSecretPlainArgs = GetSecretPlainArgs(
        secrets = secrets ?: throw PulumiNullFieldException("secrets"),
    )
}
