@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecrets.
 * @property secrets One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
 */
public data class GetSecretsPlainArgs(
    public val secrets: List<GetSecretsSecret>,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetSecretsPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetSecretsPlainArgs =
        com.pulumi.aws.kms.inputs.GetSecretsPlainArgs.builder()
            .secrets(
                secrets.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSecretsPlainArgs].
 */
@PulumiTagMarker
public class GetSecretsPlainArgsBuilder internal constructor() {
    private var secrets: List<GetSecretsSecret>? = null

    /**
     * @param value One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     */
    @JvmName("jmupgomwdwbaoxes")
    public suspend fun secrets(`value`: List<GetSecretsSecret>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secrets = mapped
    }

    /**
     * @param argument One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     */
    @JvmName("kcvglxothlkekdxp")
    public suspend fun secrets(argument: List<suspend GetSecretsSecretBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecretsSecretBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param argument One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     */
    @JvmName("dqlmsxdlenbuyhvf")
    public suspend fun secrets(vararg argument: suspend GetSecretsSecretBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecretsSecretBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param argument One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     */
    @JvmName("pfciqdwwrgicmoph")
    public suspend fun secrets(argument: suspend GetSecretsSecretBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecretsSecretBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.secrets = mapped
    }

    /**
     * @param values One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
     */
    @JvmName("vhcartvigmpqgyuy")
    public suspend fun secrets(vararg values: GetSecretsSecret) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secrets = mapped
    }

    internal fun build(): GetSecretsPlainArgs = GetSecretsPlainArgs(
        secrets = secrets ?: throw PulumiNullFieldException("secrets"),
    )
}
