@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetSecretsSecret.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property context An optional mapping that makes up the Encryption Context for the secret.
 * @property encryptionAlgorithm The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
 * @property grantTokens An optional list of Grant Tokens for the secret.
 * @property keyId Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
 * For more information on `context` and `grant_tokens` see the [KMS
 * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
 * @property name Name to export this secret under in the attributes.
 * @property payload Base64 encoded payload, as returned from a KMS encrypt operation.
 */
public data class GetSecretsSecret(
    public val context: Map<String, String>? = null,
    public val encryptionAlgorithm: String? = null,
    public val grantTokens: List<String>? = null,
    public val keyId: String? = null,
    public val name: String,
    public val payload: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetSecretsSecret> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetSecretsSecret =
        com.pulumi.aws.kms.inputs.GetSecretsSecret.builder()
            .context(context?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .encryptionAlgorithm(encryptionAlgorithm?.let({ args0 -> args0 }))
            .grantTokens(grantTokens?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyId(keyId?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .payload(payload.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretsSecret].
 */
@PulumiTagMarker
public class GetSecretsSecretBuilder internal constructor() {
    private var context: Map<String, String>? = null

    private var encryptionAlgorithm: String? = null

    private var grantTokens: List<String>? = null

    private var keyId: String? = null

    private var name: String? = null

    private var payload: String? = null

    /**
     * @param value An optional mapping that makes up the Encryption Context for the secret.
     */
    @JvmName("grcqoufnjfqqqwtg")
    public suspend fun context(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param values An optional mapping that makes up the Encryption Context for the secret.
     */
    @JvmName("sufkrcpsrnictssv")
    public fun context(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param value The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
     */
    @JvmName("rmotnkfkgtnkdhml")
    public suspend fun encryptionAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value An optional list of Grant Tokens for the secret.
     */
    @JvmName("eumkngfdjjpqwnub")
    public suspend fun grantTokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param values An optional list of Grant Tokens for the secret.
     */
    @JvmName("usgftfmyglphhtqi")
    public suspend fun grantTokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param value Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     * For more information on `context` and `grant_tokens` see the [KMS
   * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
     */
    @JvmName("jwialsjainkehsqo")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyId = mapped
    }

    /**
     * @param value Name to export this secret under in the attributes.
     */
    @JvmName("bvfjgufdddbuyuam")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Base64 encoded payload, as returned from a KMS encrypt operation.
     */
    @JvmName("qobggogdmxgeuvnm")
    public suspend fun payload(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.payload = mapped
    }

    internal fun build(): GetSecretsSecret = GetSecretsSecret(
        context = context,
        encryptionAlgorithm = encryptionAlgorithm,
        grantTokens = grantTokens,
        keyId = keyId,
        name = name ?: throw PulumiNullFieldException("name"),
        payload = payload ?: throw PulumiNullFieldException("payload"),
    )
}
