@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getCipherText.
 * @property ciphertextBlob Base64 encoded ciphertext
 * @property context
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyId
 * @property plaintext
 */
public data class GetCipherTextResult(
    public val ciphertextBlob: String,
    public val context: Map<String, String>? = null,
    public val id: String,
    public val keyId: String,
    public val plaintext: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetCipherTextResult):
            GetCipherTextResult = GetCipherTextResult(
            ciphertextBlob = javaType.ciphertextBlob(),
            context = javaType.context().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            keyId = javaType.keyId(),
            plaintext = javaType.plaintext(),
        )
    }
}
