@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCustomKeyStore.
 * @property cloudHsmClusterId
 * @property connectionState Indicates whether the custom key store is connected to its CloudHSM cluster.
 * @property creationDate The date and time when the custom key store was created.
 * @property customKeyStoreId
 * @property customKeyStoreName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property trustAnchorCertificate The trust anchor certificate of the associated CloudHSM cluster.
 */
public data class GetCustomKeyStoreResult(
    public val cloudHsmClusterId: String,
    public val connectionState: String,
    public val creationDate: String,
    public val customKeyStoreId: String,
    public val customKeyStoreName: String,
    public val id: String,
    public val trustAnchorCertificate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetCustomKeyStoreResult):
            GetCustomKeyStoreResult = GetCustomKeyStoreResult(
            cloudHsmClusterId = javaType.cloudHsmClusterId(),
            connectionState = javaType.connectionState(),
            creationDate = javaType.creationDate(),
            customKeyStoreId = javaType.customKeyStoreId(),
            customKeyStoreName = javaType.customKeyStoreName(),
            id = javaType.id(),
            trustAnchorCertificate = javaType.trustAnchorCertificate(),
        )
    }
}
