@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property multiRegionKeyType Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
 * @property primaryKeys The key ARN and Region of the primary key. This is the current KMS key if it is the primary key.
 * @property replicaKeys The key ARNs and Regions of all replica keys. Includes the current KMS key if it is a replica key.
 */
public data class GetKeyMultiRegionConfiguration(
    public val multiRegionKeyType: String,
    public val primaryKeys: List<GetKeyMultiRegionConfigurationPrimaryKey>,
    public val replicaKeys: List<GetKeyMultiRegionConfigurationReplicaKey>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetKeyMultiRegionConfiguration):
            GetKeyMultiRegionConfiguration = GetKeyMultiRegionConfiguration(
            multiRegionKeyType = javaType.multiRegionKeyType(),
            primaryKeys = javaType.primaryKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kms.kotlin.outputs.GetKeyMultiRegionConfigurationPrimaryKey.Companion.toKotlin(args0)
                })
            }),
            replicaKeys = javaType.replicaKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kms.kotlin.outputs.GetKeyMultiRegionConfigurationReplicaKey.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
