@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The key ARN of a primary or replica key of a multi-Region key.
 * @property region The AWS Region of a primary or replica key in a multi-Region key.
 */
public data class GetKeyMultiRegionConfigurationReplicaKey(
    public val arn: String,
    public val region: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetKeyMultiRegionConfigurationReplicaKey):
            GetKeyMultiRegionConfigurationReplicaKey = GetKeyMultiRegionConfigurationReplicaKey(
            arn = javaType.arn(),
            region = javaType.region(),
        )
    }
}
