@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKey.
 * @property arn The key ARN of a primary or replica key of a multi-Region key.
 * @property awsAccountId The twelve-digit account ID of the AWS account that owns the key
 * @property cloudHsmClusterId The cluster ID of the AWS CloudHSM cluster that contains the key material for the KMS key.
 * @property creationDate The date and time when the key was created
 * @property customKeyStoreId A unique identifier for the custom key store that contains the KMS key.
 * @property customerMasterKeySpec Specifies whether the key contains a symmetric key or an asymmetric key pair and the encryption algorithms or signing algorithms that the key supports
 * @property deletionDate The date and time after which AWS KMS deletes the key. This value is present only when `key_state` is `PendingDeletion`, otherwise this value is 0
 * @property description The description of the key.
 * @property enabled Specifies whether the key is enabled. When `key_state` is `Enabled` this value is true, otherwise it is false
 * @property expirationModel Specifies whether the Key's key material expires. This value is present only when `origin` is `EXTERNAL`, otherwise this value is empty
 * @property grantTokens
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyId
 * @property keyManager The key's manager
 * @property keySpec Describes the type of key material in the KMS key.
 * @property keyState The state of the key
 * @property keyUsage Specifies the intended use of the key
 * @property multiRegion Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key.
 * @property multiRegionConfigurations Lists the primary and replica keys in same multi-Region key. Present only when the value of `multi_region` is `true`.
 * @property origin When this value is `AWS_KMS`, AWS KMS created the key material. When this value is `EXTERNAL`, the key material was imported from your existing key management infrastructure or the CMK lacks key material
 * @property pendingDeletionWindowInDays The waiting period before the primary key in a multi-Region key is deleted.
 * @property validTo The time at which the imported key material expires. This value is present only when `origin` is `EXTERNAL` and whose `expiration_model` is `KEY_MATERIAL_EXPIRES`, otherwise this value is 0
 * @property xksKeyConfigurations Information about the external key that is associated with a KMS key in an external key store.
 */
public data class GetKeyResult(
    public val arn: String,
    public val awsAccountId: String,
    public val cloudHsmClusterId: String,
    public val creationDate: String,
    public val customKeyStoreId: String,
    public val customerMasterKeySpec: String,
    public val deletionDate: String,
    public val description: String,
    public val enabled: Boolean,
    public val expirationModel: String,
    public val grantTokens: List<String>? = null,
    public val id: String,
    public val keyId: String,
    public val keyManager: String,
    public val keySpec: String,
    public val keyState: String,
    public val keyUsage: String,
    public val multiRegion: Boolean,
    public val multiRegionConfigurations: List<GetKeyMultiRegionConfiguration>,
    public val origin: String,
    public val pendingDeletionWindowInDays: Int,
    public val validTo: String,
    public val xksKeyConfigurations: List<GetKeyXksKeyConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetKeyResult): GetKeyResult =
            GetKeyResult(
                arn = javaType.arn(),
                awsAccountId = javaType.awsAccountId(),
                cloudHsmClusterId = javaType.cloudHsmClusterId(),
                creationDate = javaType.creationDate(),
                customKeyStoreId = javaType.customKeyStoreId(),
                customerMasterKeySpec = javaType.customerMasterKeySpec(),
                deletionDate = javaType.deletionDate(),
                description = javaType.description(),
                enabled = javaType.enabled(),
                expirationModel = javaType.expirationModel(),
                grantTokens = javaType.grantTokens().map({ args0 -> args0 }),
                id = javaType.id(),
                keyId = javaType.keyId(),
                keyManager = javaType.keyManager(),
                keySpec = javaType.keySpec(),
                keyState = javaType.keyState(),
                keyUsage = javaType.keyUsage(),
                multiRegion = javaType.multiRegion(),
                multiRegionConfigurations = javaType.multiRegionConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kms.kotlin.outputs.GetKeyMultiRegionConfiguration.Companion.toKotlin(args0)
                    })
                }),
                origin = javaType.origin(),
                pendingDeletionWindowInDays = javaType.pendingDeletionWindowInDays(),
                validTo = javaType.validTo(),
                xksKeyConfigurations = javaType.xksKeyConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kms.kotlin.outputs.GetKeyXksKeyConfiguration.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
