@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property context An optional mapping that makes up the Encryption Context for the secret.
 * @property encryptionAlgorithm The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
 * @property grantTokens An optional list of Grant Tokens for the secret.
 * @property keyId Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
 * For more information on `context` and `grant_tokens` see the [KMS
 * Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
 * @property name Name to export this secret under in the attributes.
 * @property payload Base64 encoded payload, as returned from a KMS encrypt operation.
 */
public data class GetSecretsSecret(
    public val context: Map<String, String>? = null,
    public val encryptionAlgorithm: String? = null,
    public val grantTokens: List<String>? = null,
    public val keyId: String? = null,
    public val name: String,
    public val payload: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetSecretsSecret): GetSecretsSecret =
            GetSecretsSecret(
                context = javaType.context().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                encryptionAlgorithm = javaType.encryptionAlgorithm().map({ args0 -> args0 }).orElse(null),
                grantTokens = javaType.grantTokens().map({ args0 -> args0 }),
                keyId = javaType.keyId().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                payload = javaType.payload(),
            )
    }
}
