@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property encryptionContextEquals A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
 * @property encryptionContextSubset A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
 */
public data class GrantConstraint(
    public val encryptionContextEquals: Map<String, String>? = null,
    public val encryptionContextSubset: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GrantConstraint): GrantConstraint =
            GrantConstraint(
                encryptionContextEquals = javaType.encryptionContextEquals().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                encryptionContextSubset = javaType.encryptionContextSubset().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
            )
    }
}
