@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin

import com.pulumi.aws.AwsFunctions.getArnPlain
import com.pulumi.aws.AwsFunctions.getAvailabilityZonePlain
import com.pulumi.aws.AwsFunctions.getAvailabilityZonesPlain
import com.pulumi.aws.AwsFunctions.getBillingServiceAccountPlain
import com.pulumi.aws.AwsFunctions.getCallerIdentityPlain
import com.pulumi.aws.AwsFunctions.getDefaultTagsPlain
import com.pulumi.aws.AwsFunctions.getIpRangesPlain
import com.pulumi.aws.AwsFunctions.getPartitionPlain
import com.pulumi.aws.AwsFunctions.getRegionPlain
import com.pulumi.aws.AwsFunctions.getRegionsPlain
import com.pulumi.aws.AwsFunctions.getServicePlain
import com.pulumi.aws.kotlin.inputs.GetArnPlainArgs
import com.pulumi.aws.kotlin.inputs.GetArnPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZoneFilter
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonePlainArgs
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonePlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesFilter
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesPlainArgs
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetBillingServiceAccountPlainArgs
import com.pulumi.aws.kotlin.inputs.GetBillingServiceAccountPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetCallerIdentityPlainArgs
import com.pulumi.aws.kotlin.inputs.GetCallerIdentityPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetDefaultTagsPlainArgs
import com.pulumi.aws.kotlin.inputs.GetDefaultTagsPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetIpRangesPlainArgs
import com.pulumi.aws.kotlin.inputs.GetIpRangesPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetPartitionPlainArgs
import com.pulumi.aws.kotlin.inputs.GetPartitionPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetRegionPlainArgs
import com.pulumi.aws.kotlin.inputs.GetRegionPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetRegionsFilter
import com.pulumi.aws.kotlin.inputs.GetRegionsPlainArgs
import com.pulumi.aws.kotlin.inputs.GetRegionsPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.kotlin.outputs.GetArnResult
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZoneResult
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZonesResult
import com.pulumi.aws.kotlin.outputs.GetBillingServiceAccountResult
import com.pulumi.aws.kotlin.outputs.GetCallerIdentityResult
import com.pulumi.aws.kotlin.outputs.GetDefaultTagsResult
import com.pulumi.aws.kotlin.outputs.GetIpRangesResult
import com.pulumi.aws.kotlin.outputs.GetPartitionResult
import com.pulumi.aws.kotlin.outputs.GetRegionResult
import com.pulumi.aws.kotlin.outputs.GetRegionsResult
import com.pulumi.aws.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.kotlin.outputs.GetArnResult.Companion.toKotlin as getArnResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZoneResult.Companion.toKotlin as getAvailabilityZoneResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZonesResult.Companion.toKotlin as getAvailabilityZonesResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetBillingServiceAccountResult.Companion.toKotlin as getBillingServiceAccountResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetCallerIdentityResult.Companion.toKotlin as getCallerIdentityResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetDefaultTagsResult.Companion.toKotlin as getDefaultTagsResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetIpRangesResult.Companion.toKotlin as getIpRangesResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetPartitionResult.Companion.toKotlin as getPartitionResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetRegionResult.Companion.toKotlin as getRegionResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetRegionsResult.Companion.toKotlin as getRegionsResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object AwsFunctions {
    /**
     * Parses an ARN into its constituent parts.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn("arn:aws:rds:eu-west-1:123456789012:db:mysql-db")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getArn.
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(argument: GetArnPlainArgs): GetArnResult =
        getArnResultToKotlin(getArnPlain(argument.toJava()).await())

    /**
     * @see [getArn].
     * @param arn ARN to parse.
     * @param id
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(arn: String, id: String? = null): GetArnResult {
        val argument = GetArnPlainArgs(
            arn = arn,
            id = id,
        )
        return getArnResultToKotlin(getArnPlain(argument.toJava()).await())
    }

    /**
     * @see [getArn].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetArnPlainArgs].
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(argument: suspend GetArnPlainArgsBuilder.() -> Unit): GetArnResult {
        val builder = GetArnPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArnResultToKotlin(getArnPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * @param argument A collection of arguments for invoking getAvailabilityZone.
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend fun getAvailabilityZone(argument: GetAvailabilityZonePlainArgs):
        GetAvailabilityZoneResult =
        getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(argument.toJava()).await())

    /**
     * @see [getAvailabilityZone].
     * @param allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param name Full name of the availability zone to select.
     * @param state Specific availability zone state to require. May be any of `"available"`, `"information"` or `"impaired"`.
     * @param zoneId Zone ID of the availability zone to select.
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend fun getAvailabilityZone(
        allAvailabilityZones: Boolean? = null,
        filters: List<GetAvailabilityZoneFilter>? = null,
        name: String? = null,
        state: String? = null,
        zoneId: String? = null,
    ): GetAvailabilityZoneResult {
        val argument = GetAvailabilityZonePlainArgs(
            allAvailabilityZones = allAvailabilityZones,
            filters = filters,
            name = name,
            state = state,
            zoneId = zoneId,
        )
        return getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilityZone].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetAvailabilityZonePlainArgs].
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend
    fun getAvailabilityZone(argument: suspend GetAvailabilityZonePlainArgsBuilder.() -> Unit):
        GetAvailabilityZoneResult {
        val builder = GetAvailabilityZonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(builtArgument.toJava()).await())
    }

    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * > When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * ## Example Usage
     * ### By State
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state("available")
     *             .build());
     *         var primary = new Subnet("primary", SubnetArgs.builder()
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
     *             .build());
     *         var secondary = new Subnet("secondary", SubnetArgs.builder()
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
     *             .build());
     *     }
     * }
     * ```
     * ### By Filter
     * All Local Zones (regardless of opt-in status):
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name("opt-in-status")
     *                 .values(
     *                     "not-opted-in",
     *                     "opted-in")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAvailabilityZones.
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend fun getAvailabilityZones(argument: GetAvailabilityZonesPlainArgs):
        GetAvailabilityZonesResult =
        getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(argument.toJava()).await())

    /**
     * @see [getAvailabilityZones].
     * @param allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     * @param excludeNames List of Availability Zone names to exclude.
     * @param excludeZoneIds List of Availability Zone IDs to exclude.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param state Allows to filter list of Availability Zones based on their
     * current state. Can be either `"available"`, `"information"`, `"impaired"` or
     * `"unavailable"`. By default the list includes a complete set of Availability Zones
     * to which the underlying AWS account has access, regardless of their state.
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend fun getAvailabilityZones(
        allAvailabilityZones: Boolean? = null,
        excludeNames: List<String>? = null,
        excludeZoneIds: List<String>? = null,
        filters: List<GetAvailabilityZonesFilter>? = null,
        state: String? = null,
    ): GetAvailabilityZonesResult {
        val argument = GetAvailabilityZonesPlainArgs(
            allAvailabilityZones = allAvailabilityZones,
            excludeNames = excludeNames,
            excludeZoneIds = excludeZoneIds,
            filters = filters,
            state = state,
        )
        return getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilityZones].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetAvailabilityZonesPlainArgs].
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend
    fun getAvailabilityZones(argument: suspend GetAvailabilityZonesPlainArgsBuilder.() -> Unit):
        GetAvailabilityZonesResult {
        val builder = GetAvailabilityZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     *         var billingLogs = new BucketV2("billingLogs");
     *         var billingLogsAcl = new BucketAclV2("billingLogsAcl", BucketAclV2Args.builder()
     *             .bucket(billingLogs.id())
     *             .acl("private")
     *             .build());
     *         final var allowBillingLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -> getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(
     *                         "s3:GetBucketAcl",
     *                         "s3:GetBucketPolicy")
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -> getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:PutObject")
     *                     .resources(billingLogs.arn().applyValue(arn -> String.format("%s/*", arn)))
     *                     .build())
     *             .build());
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy("allowBillingLoggingBucketPolicy", BucketPolicyArgs.builder()
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowBillingLoggingPolicyDocument -> allowBillingLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBillingServiceAccount.
     * @return A collection of values returned by getBillingServiceAccount.
     * */
     */
    public suspend fun getBillingServiceAccount(argument: GetBillingServiceAccountPlainArgs):
        GetBillingServiceAccountResult =
        getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getBillingServiceAccount].
     * @param id ID of the AWS billing service account.
     * @return A collection of values returned by getBillingServiceAccount.
     */
    public suspend fun getBillingServiceAccount(id: String? = null): GetBillingServiceAccountResult {
        val argument = GetBillingServiceAccountPlainArgs(
            id = id,
        )
        return getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetBillingServiceAccountPlainArgs].
     * @return A collection of values returned by getBillingServiceAccount.
     */
    public suspend
    fun getBillingServiceAccount(argument: suspend GetBillingServiceAccountPlainArgsBuilder.() -> Unit):
        GetBillingServiceAccountResult {
        val builder = GetBillingServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         ctx.export("accountId", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()));
     *         ctx.export("callerArn", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()));
     *         ctx.export("callerUser", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCallerIdentity.
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(argument: GetCallerIdentityPlainArgs):
        GetCallerIdentityResult =
        getCallerIdentityResultToKotlin(getCallerIdentityPlain(argument.toJava()).await())

    /**
     * @see [getCallerIdentity].
     * @param id Account ID number of the account that owns or contains the calling entity.
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(id: String? = null): GetCallerIdentityResult {
        val argument = GetCallerIdentityPlainArgs(
            id = id,
        )
        return getCallerIdentityResultToKotlin(getCallerIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getCallerIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetCallerIdentityPlainArgs].
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend
    fun getCallerIdentity(argument: suspend GetCallerIdentityPlainArgsBuilder.() -> Unit):
        GetCallerIdentityResult {
        val builder = GetCallerIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCallerIdentityResultToKotlin(getCallerIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the default tags configured on the provider.
     * With this data source, you can apply default tags to resources not _directly_ managed by a resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     *     }
     * }
     * ```
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import com.pulumi.aws.autoscaling.Group;
     * import com.pulumi.aws.autoscaling.GroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleDefaultTags = AwsFunctions.getDefaultTags();
     *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
     *             .dynamic(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDefaultTags.
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(argument: GetDefaultTagsPlainArgs): GetDefaultTagsResult =
        getDefaultTagsResultToKotlin(getDefaultTagsPlain(argument.toJava()).await())

    /**
     * @see [getDefaultTags].
     * @param id
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(id: String? = null): GetDefaultTagsResult {
        val argument = GetDefaultTagsPlainArgs(
            id = id,
        )
        return getDefaultTagsResultToKotlin(getDefaultTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDefaultTags].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetDefaultTagsPlainArgs].
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(argument: suspend GetDefaultTagsPlainArgsBuilder.() -> Unit):
        GetDefaultTagsResult {
        val builder = GetDefaultTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDefaultTagsResultToKotlin(getDefaultTagsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(
     *                 "eu-west-1",
     *                 "eu-central-1")
     *             .services("ec2")
     *             .build());
     *         var fromEurope = new SecurityGroup("fromEurope", SecurityGroupArgs.builder()
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort("443")
     *                 .toPort("443")
     *                 .protocol("tcp")
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry("CreateDate", europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.createDate())),
     *                 Map.entry("SyncToken", europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getIpRanges.
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(argument: GetIpRangesPlainArgs): GetIpRangesResult =
        getIpRangesResultToKotlin(getIpRangesPlain(argument.toJava()).await())

    /**
     * @see [getIpRanges].
     * @param id
     * @param regions Filter IP ranges by regions (or include all regions, if
     * omitted). Valid items are `global` (for `cloudfront`) as well as all AWS regions
     * (e.g., `eu-central-1`)
     * @param services Filter IP ranges by services. Valid items are `amazon`
     * (for amazon.com), `amazon_connect`, `api_gateway`, `cloud9`, `cloudfront`,
     * `codebuild`, `dynamodb`, `ec2`, `ec2_instance_connect`, `globalaccelerator`,
     * `route53`, `route53_healthchecks`, `s3` and `workspaces_gateways`. See the
     * [`service` attribute][2] documentation for other possible values.
     * > **NOTE:** If the specified combination of regions and services does not yield any
     * CIDR blocks, this call will fail.
     * @param url Custom URL for source JSON file. Syntax must match [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html). Defaults to `https://ip-ranges.amazonaws.com/ip-ranges.json`.
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(
        id: String? = null,
        regions: List<String>? = null,
        services: List<String>,
        url: String? = null,
    ): GetIpRangesResult {
        val argument = GetIpRangesPlainArgs(
            id = id,
            regions = regions,
            services = services,
            url = url,
        )
        return getIpRangesResultToKotlin(getIpRangesPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpRanges].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetIpRangesPlainArgs].
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(argument: suspend GetIpRangesPlainArgsBuilder.() -> Unit):
        GetIpRangesResult {
        val builder = GetIpRangesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpRangesResultToKotlin(getIpRangesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions("s3:ListBucket")
     *                 .resources(String.format("arn:%s:s3:::my-bucket", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
     *                 .sid("1")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPartition.
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(argument: GetPartitionPlainArgs): GetPartitionResult =
        getPartitionResultToKotlin(getPartitionPlain(argument.toJava()).await())

    /**
     * @see [getPartition].
     * @param id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(id: String? = null): GetPartitionResult {
        val argument = GetPartitionPlainArgs(
            id = id,
        )
        return getPartitionResultToKotlin(getPartitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetPartitionPlainArgs].
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(argument: suspend GetPartitionPlainArgsBuilder.() -> Unit):
        GetPartitionResult {
        val builder = GetPartitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartitionResultToKotlin(getPartitionPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * ## Example Usage
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRegion.
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(argument: GetRegionPlainArgs): GetRegionResult =
        getRegionResultToKotlin(getRegionPlain(argument.toJava()).await())

    /**
     * @see [getRegion].
     * @param endpoint EC2 endpoint of the region to select.
     * @param id
     * @param name Full name of the region to select.
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(
        endpoint: String? = null,
        id: String? = null,
        name: String? = null,
    ): GetRegionResult {
        val argument = GetRegionPlainArgs(
            endpoint = endpoint,
            id = id,
            name = name,
        )
        return getRegionResultToKotlin(getRegionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetRegionPlainArgs].
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(argument: suspend GetRegionPlainArgsBuilder.() -> Unit):
        GetRegionResult {
        val builder = GetRegionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionResultToKotlin(getRegionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * ## Example Usage
     * Enabled AWS Regions:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRegions.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: GetRegionsPlainArgs): GetRegionsResult =
        getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())

    /**
     * @see [getRegions].
     * @param allRegions If true the source will query all regions regardless of availability.
     * @param filters Configuration block(s) to use as filters. Detailed below.
     * @param id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(
        allRegions: Boolean? = null,
        filters: List<GetRegionsFilter>? = null,
        id: String? = null,
    ): GetRegionsResult {
        val argument = GetRegionsPlainArgs(
            allRegions = allRegions,
            filters = filters,
            id = id,
        )
        return getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetRegionsPlainArgs].
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: suspend GetRegionsPlainArgsBuilder.() -> Unit):
        GetRegionsResult {
        val builder = GetRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionsResultToKotlin(getRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * ## Example Usage
     * ### Get Service DNS Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -> getRegionResult.name()))
     *             .serviceId("ec2")
     *             .build());
     *     }
     * }
     * ```
     * ### Use Service Reverse DNS Name to Get Components
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName("cn.com.amazonaws.cn-north-1.s3")
     *             .build());
     *     }
     * }
     * ```
     * ### Determine Regional Support for a Service
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName("com.amazonaws.us-gov-west-1.waf")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param dnsName DNS name of the service (_e.g.,_ `rds.us-east-1.amazonaws.com`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @param id
     * @param region Region of the service (_e.g.,_ `us-west-2`, `ap-northeast-1`).
     * @param reverseDnsName Reverse DNS name of the service (_e.g.,_ `com.amazonaws.us-west-2.s3`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @param reverseDnsPrefix Prefix of the service (_e.g.,_ `com.amazonaws` in AWS Commercial, `cn.com.amazonaws` in AWS China).
     * @param serviceId Service (_e.g.,_ `s3`, `rds`, `ec2`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        dnsName: String? = null,
        id: String? = null,
        region: String? = null,
        reverseDnsName: String? = null,
        reverseDnsPrefix: String? = null,
        serviceId: String? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            dnsName = dnsName,
            id = id,
            region = region,
            reverseDnsName = reverseDnsName,
            reverseDnsPrefix = reverseDnsPrefix,
            serviceId = serviceId,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
