@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin

import com.pulumi.aws.Provider
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinProviderResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AwsProvider].
 */
@PulumiTagMarker
public class AwsProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderArgs = ProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderArgsBuilder.() -> Unit) {
        val builder = ProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AwsProvider {
        val builtJavaResource = Provider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AwsProvider(builtJavaResource)
    }
}

/**
 * The provider type for the aws package. By default, resources use package-wide configuration
 * settings, however an explicit `Provider` instance may be created and passed during resource
 * construction to achieve fine-grained programmatic control over provider settings. See the
 * [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.
 */
public class AwsProvider internal constructor(
    override val javaResource: Provider,
) : KotlinProviderResource(javaResource, AwsProviderMapper) {
    /**
     * The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    public val accessKey: Output<String>?
        get() = javaResource.accessKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
     * variable. (Setting `ca_bundle` in the shared config file is not supported.)
     */
    public val customCaBundle: Output<String>?
        get() = javaResource.customCaBundle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Address of the EC2 metadata service endpoint to use. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
     */
    public val ec2MetadataServiceEndpoint: Output<String>?
        get() = javaResource.ec2MetadataServiceEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
     */
    public val ec2MetadataServiceEndpointMode: Output<String>?
        get() = javaResource.ec2MetadataServiceEndpointMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or
     * `http_proxy` environment variables.
     */
    public val httpProxy: Output<String>?
        get() = javaResource.httpProxy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or
     * `https_proxy` environment variables.
     */
    public val httpsProxy: Output<String>?
        get() = javaResource.httpsProxy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or
     * `no_proxy` environment variables.
     */
    public val noProxy: Output<String>?
        get() = javaResource.noProxy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The profile for API operations. If not set, the default profile created with `aws configure` will be used.
     */
    public val profile: Output<String>?
        get() = javaResource.profile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
     */
    public val region: Output<String>?
        get() = javaResource.region().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
     * `AWS_RETRY_MODE` environment variable.
     */
    public val retryMode: Output<String>?
        get() = javaResource.retryMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
     * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
     * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
     */
    public val s3UsEast1RegionalEndpoint: Output<String>?
        get() = javaResource.s3UsEast1RegionalEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    public val secretKey: Output<String>?
        get() = javaResource.secretKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
     */
    public val stsRegion: Output<String>?
        get() = javaResource.stsRegion().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * session token. A session token is only required if you are using temporary security credentials.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AwsProviderMapper : ResourceMapper<AwsProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        Provider::class == javaResource::class

    override fun map(javaResource: Resource): AwsProvider = AwsProvider(javaResource as Provider)
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AwsProvider].
 */
public suspend fun awsProvider(name: String, block: suspend AwsProviderResourceBuilder.() -> Unit):
    AwsProvider {
    val builder = AwsProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun awsProvider(name: String): AwsProvider {
    val builder = AwsProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
