@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin

import com.pulumi.aws.ProviderArgs.builder
import com.pulumi.aws.kotlin.inputs.ProviderAssumeRoleArgs
import com.pulumi.aws.kotlin.inputs.ProviderAssumeRoleArgsBuilder
import com.pulumi.aws.kotlin.inputs.ProviderAssumeRoleWithWebIdentityArgs
import com.pulumi.aws.kotlin.inputs.ProviderAssumeRoleWithWebIdentityArgsBuilder
import com.pulumi.aws.kotlin.inputs.ProviderDefaultTagsArgs
import com.pulumi.aws.kotlin.inputs.ProviderDefaultTagsArgsBuilder
import com.pulumi.aws.kotlin.inputs.ProviderEndpointArgs
import com.pulumi.aws.kotlin.inputs.ProviderEndpointArgsBuilder
import com.pulumi.aws.kotlin.inputs.ProviderIgnoreTagsArgs
import com.pulumi.aws.kotlin.inputs.ProviderIgnoreTagsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The provider type for the aws package. By default, resources use package-wide configuration
 * settings, however an explicit `Provider` instance may be created and passed during resource
 * construction to achieve fine-grained programmatic control over provider settings. See the
 * [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.
 * @property accessKey The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
 * @property allowedAccountIds
 * @property assumeRole
 * @property assumeRoleWithWebIdentity
 * @property customCaBundle File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
 * variable. (Setting `ca_bundle` in the shared config file is not supported.)
 * @property defaultTags Configuration block with settings to default resource tags across all resources.
 * @property ec2MetadataServiceEndpoint Address of the EC2 metadata service endpoint to use. Can also be configured using the
 * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
 * @property ec2MetadataServiceEndpointMode Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
 * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
 * @property endpoints
 * @property forbiddenAccountIds
 * @property httpProxy URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or
 * `http_proxy` environment variables.
 * @property httpsProxy URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or
 * `https_proxy` environment variables.
 * @property ignoreTags Configuration block with settings to ignore resource tags across all resources.
 * @property insecure Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
 * @property maxRetries The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
 * @property noProxy Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or
 * `no_proxy` environment variables.
 * @property profile The profile for API operations. If not set, the default profile created with `aws configure` will be used.
 * @property region The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
 * @property retryMode Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
 * `AWS_RETRY_MODE` environment variable.
 * @property s3UsEast1RegionalEndpoint Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
 * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
 * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
 * @property s3UsePathStyle Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
 * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
 * Specific to the Amazon S3 service.
 * @property secretKey The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
 * @property sharedConfigFiles List of paths to shared config files. If not set, defaults to [~/&#46;aws/config].
 * @property sharedCredentialsFiles List of paths to shared credentials files. If not set, defaults to [~/&#46;aws/credentials].
 * @property skipCredentialsValidation Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
 * available/implemented.
 * @property skipMetadataApiCheck Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
 * @property skipRegionValidation Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
 * not public (yet).
 * @property skipRequestingAccountId Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
 * @property stsRegion The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
 * @property token session token. A session token is only required if you are using temporary security credentials.
 * @property useDualstackEndpoint Resolve an endpoint with DualStack capability
 * @property useFipsEndpoint Resolve an endpoint with FIPS capability
 */
public data class ProviderArgs(
    public val accessKey: Output<String>? = null,
    public val allowedAccountIds: Output<List<String>>? = null,
    public val assumeRole: Output<ProviderAssumeRoleArgs>? = null,
    public val assumeRoleWithWebIdentity: Output<ProviderAssumeRoleWithWebIdentityArgs>? = null,
    public val customCaBundle: Output<String>? = null,
    public val defaultTags: Output<ProviderDefaultTagsArgs>? = null,
    public val ec2MetadataServiceEndpoint: Output<String>? = null,
    public val ec2MetadataServiceEndpointMode: Output<String>? = null,
    public val endpoints: Output<List<ProviderEndpointArgs>>? = null,
    public val forbiddenAccountIds: Output<List<String>>? = null,
    public val httpProxy: Output<String>? = null,
    public val httpsProxy: Output<String>? = null,
    public val ignoreTags: Output<ProviderIgnoreTagsArgs>? = null,
    public val insecure: Output<Boolean>? = null,
    public val maxRetries: Output<Int>? = null,
    public val noProxy: Output<String>? = null,
    public val profile: Output<String>? = null,
    public val region: Output<String>? = null,
    public val retryMode: Output<String>? = null,
    public val s3UsEast1RegionalEndpoint: Output<String>? = null,
    public val s3UsePathStyle: Output<Boolean>? = null,
    public val secretKey: Output<String>? = null,
    public val sharedConfigFiles: Output<List<String>>? = null,
    public val sharedCredentialsFiles: Output<List<String>>? = null,
    public val skipCredentialsValidation: Output<Boolean>? = null,
    public val skipMetadataApiCheck: Output<Boolean>? = null,
    public val skipRegionValidation: Output<Boolean>? = null,
    public val skipRequestingAccountId: Output<Boolean>? = null,
    public val stsRegion: Output<String>? = null,
    public val token: Output<String>? = null,
    public val useDualstackEndpoint: Output<Boolean>? = null,
    public val useFipsEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ProviderArgs> {
    override fun toJava(): com.pulumi.aws.ProviderArgs = com.pulumi.aws.ProviderArgs.builder()
        .accessKey(accessKey?.applyValue({ args0 -> args0 }))
        .allowedAccountIds(allowedAccountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .assumeRole(assumeRole?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .assumeRoleWithWebIdentity(
            assumeRoleWithWebIdentity?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .customCaBundle(customCaBundle?.applyValue({ args0 -> args0 }))
        .defaultTags(defaultTags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .ec2MetadataServiceEndpoint(ec2MetadataServiceEndpoint?.applyValue({ args0 -> args0 }))
        .ec2MetadataServiceEndpointMode(ec2MetadataServiceEndpointMode?.applyValue({ args0 -> args0 }))
        .endpoints(
            endpoints?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .forbiddenAccountIds(forbiddenAccountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .httpProxy(httpProxy?.applyValue({ args0 -> args0 }))
        .httpsProxy(httpsProxy?.applyValue({ args0 -> args0 }))
        .ignoreTags(ignoreTags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .insecure(insecure?.applyValue({ args0 -> args0 }))
        .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
        .noProxy(noProxy?.applyValue({ args0 -> args0 }))
        .profile(profile?.applyValue({ args0 -> args0 }))
        .region(region?.applyValue({ args0 -> args0 }))
        .retryMode(retryMode?.applyValue({ args0 -> args0 }))
        .s3UsEast1RegionalEndpoint(s3UsEast1RegionalEndpoint?.applyValue({ args0 -> args0 }))
        .s3UsePathStyle(s3UsePathStyle?.applyValue({ args0 -> args0 }))
        .secretKey(secretKey?.applyValue({ args0 -> args0 }))
        .sharedConfigFiles(sharedConfigFiles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .sharedCredentialsFiles(
            sharedCredentialsFiles?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .skipCredentialsValidation(skipCredentialsValidation?.applyValue({ args0 -> args0 }))
        .skipMetadataApiCheck(skipMetadataApiCheck?.applyValue({ args0 -> args0 }))
        .skipRegionValidation(skipRegionValidation?.applyValue({ args0 -> args0 }))
        .skipRequestingAccountId(skipRequestingAccountId?.applyValue({ args0 -> args0 }))
        .stsRegion(stsRegion?.applyValue({ args0 -> args0 }))
        .token(token?.applyValue({ args0 -> args0 }))
        .useDualstackEndpoint(useDualstackEndpoint?.applyValue({ args0 -> args0 }))
        .useFipsEndpoint(useFipsEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderArgs].
 */
@PulumiTagMarker
public class ProviderArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var allowedAccountIds: Output<List<String>>? = null

    private var assumeRole: Output<ProviderAssumeRoleArgs>? = null

    private var assumeRoleWithWebIdentity: Output<ProviderAssumeRoleWithWebIdentityArgs>? = null

    private var customCaBundle: Output<String>? = null

    private var defaultTags: Output<ProviderDefaultTagsArgs>? = null

    private var ec2MetadataServiceEndpoint: Output<String>? = null

    private var ec2MetadataServiceEndpointMode: Output<String>? = null

    private var endpoints: Output<List<ProviderEndpointArgs>>? = null

    private var forbiddenAccountIds: Output<List<String>>? = null

    private var httpProxy: Output<String>? = null

    private var httpsProxy: Output<String>? = null

    private var ignoreTags: Output<ProviderIgnoreTagsArgs>? = null

    private var insecure: Output<Boolean>? = null

    private var maxRetries: Output<Int>? = null

    private var noProxy: Output<String>? = null

    private var profile: Output<String>? = null

    private var region: Output<String>? = null

    private var retryMode: Output<String>? = null

    private var s3UsEast1RegionalEndpoint: Output<String>? = null

    private var s3UsePathStyle: Output<Boolean>? = null

    private var secretKey: Output<String>? = null

    private var sharedConfigFiles: Output<List<String>>? = null

    private var sharedCredentialsFiles: Output<List<String>>? = null

    private var skipCredentialsValidation: Output<Boolean>? = null

    private var skipMetadataApiCheck: Output<Boolean>? = null

    private var skipRegionValidation: Output<Boolean>? = null

    private var skipRequestingAccountId: Output<Boolean>? = null

    private var stsRegion: Output<String>? = null

    private var token: Output<String>? = null

    private var useDualstackEndpoint: Output<Boolean>? = null

    private var useFipsEndpoint: Output<Boolean>? = null

    /**
     * @param value The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    @JvmName("nhxwbhsowxevjsam")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value
     */
    @JvmName("bqibeenmxxguwnmj")
    public suspend fun allowedAccountIds(`value`: Output<List<String>>) {
        this.allowedAccountIds = value
    }

    @JvmName("vpjjoyoqglqcekhc")
    public suspend fun allowedAccountIds(vararg values: Output<String>) {
        this.allowedAccountIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cknjfynnvhrfyxxs")
    public suspend fun allowedAccountIds(values: List<Output<String>>) {
        this.allowedAccountIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mathlhfvjknglket")
    public suspend fun assumeRole(`value`: Output<ProviderAssumeRoleArgs>) {
        this.assumeRole = value
    }

    /**
     * @param value
     */
    @JvmName("slulnvcbedobidrs")
    public suspend
    fun assumeRoleWithWebIdentity(`value`: Output<ProviderAssumeRoleWithWebIdentityArgs>) {
        this.assumeRoleWithWebIdentity = value
    }

    /**
     * @param value File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
     * variable. (Setting `ca_bundle` in the shared config file is not supported.)
     */
    @JvmName("xepaokyfruyjomdh")
    public suspend fun customCaBundle(`value`: Output<String>) {
        this.customCaBundle = value
    }

    /**
     * @param value Configuration block with settings to default resource tags across all resources.
     */
    @JvmName("gfmybievxprkgvyx")
    public suspend fun defaultTags(`value`: Output<ProviderDefaultTagsArgs>) {
        this.defaultTags = value
    }

    /**
     * @param value Address of the EC2 metadata service endpoint to use. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
     */
    @JvmName("velrqigrnkowidha")
    public suspend fun ec2MetadataServiceEndpoint(`value`: Output<String>) {
        this.ec2MetadataServiceEndpoint = value
    }

    /**
     * @param value Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
     */
    @JvmName("vvhxhgcaymonlihb")
    public suspend fun ec2MetadataServiceEndpointMode(`value`: Output<String>) {
        this.ec2MetadataServiceEndpointMode = value
    }

    /**
     * @param value
     */
    @JvmName("wfncfjyllygiosyw")
    public suspend fun endpoints(`value`: Output<List<ProviderEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("uhcrevxbceenqult")
    public suspend fun endpoints(vararg values: Output<ProviderEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rcxhqsxwomlultci")
    public suspend fun endpoints(values: List<Output<ProviderEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("snybjyrykjeeevsj")
    public suspend fun forbiddenAccountIds(`value`: Output<List<String>>) {
        this.forbiddenAccountIds = value
    }

    @JvmName("athjyswjgfafcswp")
    public suspend fun forbiddenAccountIds(vararg values: Output<String>) {
        this.forbiddenAccountIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ywdsdfsxfubnanap")
    public suspend fun forbiddenAccountIds(values: List<Output<String>>) {
        this.forbiddenAccountIds = Output.all(values)
    }

    /**
     * @param value URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or
     * `http_proxy` environment variables.
     */
    @JvmName("wdgacjggkbwctord")
    public suspend fun httpProxy(`value`: Output<String>) {
        this.httpProxy = value
    }

    /**
     * @param value URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or
     * `https_proxy` environment variables.
     */
    @JvmName("kekyvnpmcixsxwwd")
    public suspend fun httpsProxy(`value`: Output<String>) {
        this.httpsProxy = value
    }

    /**
     * @param value Configuration block with settings to ignore resource tags across all resources.
     */
    @JvmName("pbobuwfvpsoanocq")
    public suspend fun ignoreTags(`value`: Output<ProviderIgnoreTagsArgs>) {
        this.ignoreTags = value
    }

    /**
     * @param value Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
     */
    @JvmName("vqijgccetqvsojsp")
    public suspend fun insecure(`value`: Output<Boolean>) {
        this.insecure = value
    }

    /**
     * @param value The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
     */
    @JvmName("wcmwkuirovaviqsh")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or
     * `no_proxy` environment variables.
     */
    @JvmName("mownvbaqosmddlpk")
    public suspend fun noProxy(`value`: Output<String>) {
        this.noProxy = value
    }

    /**
     * @param value The profile for API operations. If not set, the default profile created with `aws configure` will be used.
     */
    @JvmName("lwilnrpuvawcfgda")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
     */
    @JvmName("vuesmvnovyhfjieb")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
     * `AWS_RETRY_MODE` environment variable.
     */
    @JvmName("ragjpivdfonrfhvj")
    public suspend fun retryMode(`value`: Output<String>) {
        this.retryMode = value
    }

    /**
     * @param value Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
     * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
     * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
     */
    @JvmName("yttcrychatximjlv")
    public suspend fun s3UsEast1RegionalEndpoint(`value`: Output<String>) {
        this.s3UsEast1RegionalEndpoint = value
    }

    /**
     * @param value Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
     * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
     * Specific to the Amazon S3 service.
     */
    @JvmName("umxwkvlshklwtdyt")
    public suspend fun s3UsePathStyle(`value`: Output<Boolean>) {
        this.s3UsePathStyle = value
    }

    /**
     * @param value The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    @JvmName("yscyfoswwybgmhqq")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value List of paths to shared config files. If not set, defaults to [~/&#46;aws/config].
     */
    @JvmName("tfnkdjvwoaljxxbp")
    public suspend fun sharedConfigFiles(`value`: Output<List<String>>) {
        this.sharedConfigFiles = value
    }

    @JvmName("ngwacmpcelodfwhp")
    public suspend fun sharedConfigFiles(vararg values: Output<String>) {
        this.sharedConfigFiles = Output.all(values.asList())
    }

    /**
     * @param values List of paths to shared config files. If not set, defaults to [~/&#46;aws/config].
     */
    @JvmName("ikulotbqaguptxvi")
    public suspend fun sharedConfigFiles(values: List<Output<String>>) {
        this.sharedConfigFiles = Output.all(values)
    }

    /**
     * @param value List of paths to shared credentials files. If not set, defaults to [~/&#46;aws/credentials].
     */
    @JvmName("wqfoafvgpnxfdedf")
    public suspend fun sharedCredentialsFiles(`value`: Output<List<String>>) {
        this.sharedCredentialsFiles = value
    }

    @JvmName("ouwrilvdubbrqbrx")
    public suspend fun sharedCredentialsFiles(vararg values: Output<String>) {
        this.sharedCredentialsFiles = Output.all(values.asList())
    }

    /**
     * @param values List of paths to shared credentials files. If not set, defaults to [~/&#46;aws/credentials].
     */
    @JvmName("tsuxlhavohpcmtav")
    public suspend fun sharedCredentialsFiles(values: List<Output<String>>) {
        this.sharedCredentialsFiles = Output.all(values)
    }

    /**
     * @param value Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
     * available/implemented.
     */
    @JvmName("haqasynpuktybojy")
    public suspend fun skipCredentialsValidation(`value`: Output<Boolean>) {
        this.skipCredentialsValidation = value
    }

    /**
     * @param value Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
     */
    @JvmName("ulcdivfhpwyulird")
    public suspend fun skipMetadataApiCheck(`value`: Output<Boolean>) {
        this.skipMetadataApiCheck = value
    }

    /**
     * @param value Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
     * not public (yet).
     */
    @JvmName("xvhejaahoaxihvos")
    public suspend fun skipRegionValidation(`value`: Output<Boolean>) {
        this.skipRegionValidation = value
    }

    /**
     * @param value Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
     */
    @JvmName("rmlnmhmyfjjpdjnj")
    public suspend fun skipRequestingAccountId(`value`: Output<Boolean>) {
        this.skipRequestingAccountId = value
    }

    /**
     * @param value The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
     */
    @JvmName("mgfaenuyxtgxjhfo")
    public suspend fun stsRegion(`value`: Output<String>) {
        this.stsRegion = value
    }

    /**
     * @param value session token. A session token is only required if you are using temporary security credentials.
     */
    @JvmName("jxojooudnleekopk")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Resolve an endpoint with DualStack capability
     */
    @JvmName("fcefcghoobjxlrbd")
    public suspend fun useDualstackEndpoint(`value`: Output<Boolean>) {
        this.useDualstackEndpoint = value
    }

    /**
     * @param value Resolve an endpoint with FIPS capability
     */
    @JvmName("sjqvvpdlcdxyjdwc")
    public suspend fun useFipsEndpoint(`value`: Output<Boolean>) {
        this.useFipsEndpoint = value
    }

    /**
     * @param value The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    @JvmName("qquxtkmkoouksrhh")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("yajwlmjcbcrtuhyb")
    public suspend fun allowedAccountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAccountIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("smbnilypupegmwdx")
    public suspend fun allowedAccountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAccountIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("ovhwscrdexukxdsm")
    public suspend fun assumeRole(`value`: ProviderAssumeRoleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRole = mapped
    }

    /**
     * @param argument
     */
    @JvmName("skkjphjkgovkaujm")
    public suspend fun assumeRole(argument: suspend ProviderAssumeRoleArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderAssumeRoleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assumeRole = mapped
    }

    /**
     * @param value
     */
    @JvmName("spjcyfgummfjobcf")
    public suspend fun assumeRoleWithWebIdentity(`value`: ProviderAssumeRoleWithWebIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRoleWithWebIdentity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("umswqjllkqhkeoob")
    public suspend
    fun assumeRoleWithWebIdentity(argument: suspend ProviderAssumeRoleWithWebIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderAssumeRoleWithWebIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.assumeRoleWithWebIdentity = mapped
    }

    /**
     * @param value File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment
     * variable. (Setting `ca_bundle` in the shared config file is not supported.)
     */
    @JvmName("edoieplvfdegktbi")
    public suspend fun customCaBundle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCaBundle = mapped
    }

    /**
     * @param value Configuration block with settings to default resource tags across all resources.
     */
    @JvmName("glstphqdhomiuxgd")
    public suspend fun defaultTags(`value`: ProviderDefaultTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTags = mapped
    }

    /**
     * @param argument Configuration block with settings to default resource tags across all resources.
     */
    @JvmName("dlgfmngbaiitqqpa")
    public suspend fun defaultTags(argument: suspend ProviderDefaultTagsArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderDefaultTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultTags = mapped
    }

    /**
     * @param value Address of the EC2 metadata service endpoint to use. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
     */
    @JvmName("mxvdmjjyrpilnluh")
    public suspend fun ec2MetadataServiceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2MetadataServiceEndpoint = mapped
    }

    /**
     * @param value Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the
     * `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
     */
    @JvmName("arntljkucnnbdlim")
    public suspend fun ec2MetadataServiceEndpointMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2MetadataServiceEndpointMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("bsdpbpyxqmmrnily")
    public suspend fun endpoints(`value`: List<ProviderEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ramyptajgninmvmw")
    public suspend fun endpoints(argument: List<suspend ProviderEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProviderEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aobegxqcjbmnwoas")
    public suspend fun endpoints(vararg argument: suspend ProviderEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProviderEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qijtuyojnpqlwmcg")
    public suspend fun endpoints(argument: suspend ProviderEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProviderEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values
     */
    @JvmName("ovqcpflmsmulvnmd")
    public suspend fun endpoints(vararg values: ProviderEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value
     */
    @JvmName("ereegfjmstitykex")
    public suspend fun forbiddenAccountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forbiddenAccountIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("wvkrnykvheyhyqyk")
    public suspend fun forbiddenAccountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forbiddenAccountIds = mapped
    }

    /**
     * @param value URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or
     * `http_proxy` environment variables.
     */
    @JvmName("yiytbimxnhvdgulm")
    public suspend fun httpProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxy = mapped
    }

    /**
     * @param value URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or
     * `https_proxy` environment variables.
     */
    @JvmName("ujmaxqqodmdbxwly")
    public suspend fun httpsProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsProxy = mapped
    }

    /**
     * @param value Configuration block with settings to ignore resource tags across all resources.
     */
    @JvmName("kelkjkkebtpqbdlb")
    public suspend fun ignoreTags(`value`: ProviderIgnoreTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreTags = mapped
    }

    /**
     * @param argument Configuration block with settings to ignore resource tags across all resources.
     */
    @JvmName("xatciofraarsjmss")
    public suspend fun ignoreTags(argument: suspend ProviderIgnoreTagsArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderIgnoreTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ignoreTags = mapped
    }

    /**
     * @param value Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
     */
    @JvmName("wgcjeelvkuifxxtn")
    public suspend fun insecure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecure = mapped
    }

    /**
     * @param value The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
     */
    @JvmName("vseejjdthoybjvst")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or
     * `no_proxy` environment variables.
     */
    @JvmName("abaljtnfgryyhbaf")
    public suspend fun noProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noProxy = mapped
    }

    /**
     * @param value The profile for API operations. If not set, the default profile created with `aws configure` will be used.
     */
    @JvmName("fbkrslikjmrdsbgu")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
     */
    @JvmName("hhqswtdtgxavghcu")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the
     * `AWS_RETRY_MODE` environment variable.
     */
    @JvmName("cleqnpffquukkonk")
    public suspend fun retryMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryMode = mapped
    }

    /**
     * @param value Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid
     * values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment
     * variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
     */
    @JvmName("evqysuluftglvsqi")
    public suspend fun s3UsEast1RegionalEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3UsEast1RegionalEndpoint = mapped
    }

    /**
     * @param value Set this to true to enable the request to use path-style addressing, i.e., https://s3.amazonaws.com/BUCKET/KEY. By
     * default, the S3 client will use virtual hosted bucket addressing when possible (https://BUCKET.s3.amazonaws.com/KEY).
     * Specific to the Amazon S3 service.
     */
    @JvmName("drqgbfgpnegdhkvl")
    public suspend fun s3UsePathStyle(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3UsePathStyle = mapped
    }

    /**
     * @param value The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
     */
    @JvmName("whlbcbsruxdugiis")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value List of paths to shared config files. If not set, defaults to [~/&#46;aws/config].
     */
    @JvmName("mmxtvfjlarkwpolq")
    public suspend fun sharedConfigFiles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedConfigFiles = mapped
    }

    /**
     * @param values List of paths to shared config files. If not set, defaults to [~/&#46;aws/config].
     */
    @JvmName("usbllqiqytnggeil")
    public suspend fun sharedConfigFiles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedConfigFiles = mapped
    }

    /**
     * @param value List of paths to shared credentials files. If not set, defaults to [~/&#46;aws/credentials].
     */
    @JvmName("ttsfwctiesdkbosr")
    public suspend fun sharedCredentialsFiles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedCredentialsFiles = mapped
    }

    /**
     * @param values List of paths to shared credentials files. If not set, defaults to [~/&#46;aws/credentials].
     */
    @JvmName("qhbnurmhxxqviurl")
    public suspend fun sharedCredentialsFiles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedCredentialsFiles = mapped
    }

    /**
     * @param value Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS
     * available/implemented.
     */
    @JvmName("ivtdjeblepqgcdtq")
    public suspend fun skipCredentialsValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipCredentialsValidation = mapped
    }

    /**
     * @param value Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
     */
    @JvmName("slrdctcwrfvobfkr")
    public suspend fun skipMetadataApiCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipMetadataApiCheck = mapped
    }

    /**
     * @param value Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are
     * not public (yet).
     */
    @JvmName("olccbexpvidllogo")
    public suspend fun skipRegionValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipRegionValidation = mapped
    }

    /**
     * @param value Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
     */
    @JvmName("jalpbhbpgpgwvhpp")
    public suspend fun skipRequestingAccountId(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipRequestingAccountId = mapped
    }

    /**
     * @param value The region where AWS STS operations will take place. Examples are us-east-1 and us-west-2.
     */
    @JvmName("lhhgwpmmwchuqdtt")
    public suspend fun stsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stsRegion = mapped
    }

    /**
     * @param value session token. A session token is only required if you are using temporary security credentials.
     */
    @JvmName("mimitbiciqrygtip")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value Resolve an endpoint with DualStack capability
     */
    @JvmName("qtmepbfvhusrbpxk")
    public suspend fun useDualstackEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDualstackEndpoint = mapped
    }

    /**
     * @param value Resolve an endpoint with FIPS capability
     */
    @JvmName("bnmngehjslheqolf")
    public suspend fun useFipsEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useFipsEndpoint = mapped
    }

    internal fun build(): ProviderArgs = ProviderArgs(
        accessKey = accessKey,
        allowedAccountIds = allowedAccountIds,
        assumeRole = assumeRole,
        assumeRoleWithWebIdentity = assumeRoleWithWebIdentity,
        customCaBundle = customCaBundle,
        defaultTags = defaultTags,
        ec2MetadataServiceEndpoint = ec2MetadataServiceEndpoint,
        ec2MetadataServiceEndpointMode = ec2MetadataServiceEndpointMode,
        endpoints = endpoints,
        forbiddenAccountIds = forbiddenAccountIds,
        httpProxy = httpProxy,
        httpsProxy = httpsProxy,
        ignoreTags = ignoreTags,
        insecure = insecure,
        maxRetries = maxRetries,
        noProxy = noProxy,
        profile = profile,
        region = region,
        retryMode = retryMode,
        s3UsEast1RegionalEndpoint = s3UsEast1RegionalEndpoint,
        s3UsePathStyle = s3UsePathStyle,
        secretKey = secretKey,
        sharedConfigFiles = sharedConfigFiles,
        sharedCredentialsFiles = sharedCredentialsFiles,
        skipCredentialsValidation = skipCredentialsValidation,
        skipMetadataApiCheck = skipMetadataApiCheck,
        skipRegionValidation = skipRegionValidation,
        skipRequestingAccountId = skipRequestingAccountId,
        stsRegion = stsRegion,
        token = token,
        useDualstackEndpoint = useDualstackEndpoint,
        useFipsEndpoint = useFipsEndpoint,
    )
}
