@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A Region represents any valid Amazon region that may be targeted with deployments.
 */
public enum class Region(
    public val javaValue: com.pulumi.aws.enums.Region,
) : ConvertibleToJava<com.pulumi.aws.enums.Region> {
    AFSouth1(com.pulumi.aws.enums.Region.AFSouth1),
    APEast1(com.pulumi.aws.enums.Region.APEast1),
    APNortheast1(com.pulumi.aws.enums.Region.APNortheast1),
    APNortheast2(com.pulumi.aws.enums.Region.APNortheast2),
    APNortheast3(com.pulumi.aws.enums.Region.APNortheast3),
    APSouth1(com.pulumi.aws.enums.Region.APSouth1),
    APSouth2(com.pulumi.aws.enums.Region.APSouth2),
    APSoutheast1(com.pulumi.aws.enums.Region.APSoutheast1),
    APSoutheast2(com.pulumi.aws.enums.Region.APSoutheast2),
    APSoutheast3(com.pulumi.aws.enums.Region.APSoutheast3),
    APSoutheast4(com.pulumi.aws.enums.Region.APSoutheast4),
    CACentral(com.pulumi.aws.enums.Region.CACentral),
    CNNorth1(com.pulumi.aws.enums.Region.CNNorth1),
    CNNorthwest1(com.pulumi.aws.enums.Region.CNNorthwest1),
    EUCentral1(com.pulumi.aws.enums.Region.EUCentral1),
    EUCentral2(com.pulumi.aws.enums.Region.EUCentral2),
    EUNorth1(com.pulumi.aws.enums.Region.EUNorth1),
    EUSouth1(com.pulumi.aws.enums.Region.EUSouth1),
    EUSouth2(com.pulumi.aws.enums.Region.EUSouth2),
    EUWest1(com.pulumi.aws.enums.Region.EUWest1),
    EUWest2(com.pulumi.aws.enums.Region.EUWest2),
    EUWest3(com.pulumi.aws.enums.Region.EUWest3),
    MECentral1(com.pulumi.aws.enums.Region.MECentral1),
    MESouth1(com.pulumi.aws.enums.Region.MESouth1),
    SAEast1(com.pulumi.aws.enums.Region.SAEast1),
    USGovEast1(com.pulumi.aws.enums.Region.USGovEast1),
    USGovWest1(com.pulumi.aws.enums.Region.USGovWest1),
    USEast1(com.pulumi.aws.enums.Region.USEast1),
    USEast2(com.pulumi.aws.enums.Region.USEast2),
    USWest1(com.pulumi.aws.enums.Region.USWest1),
    USWest2(com.pulumi.aws.enums.Region.USWest2),
    ;

    override fun toJava(): com.pulumi.aws.enums.Region = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.enums.Region): Region =
            Region.values().first { it.javaValue == javaType }
    }
}
