@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetArnPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getArn.
 * @property arn ARN to parse.
 * @property id
 */
public data class GetArnPlainArgs(
    public val arn: String,
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetArnPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetArnPlainArgs =
        com.pulumi.aws.inputs.GetArnPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArnPlainArgs].
 */
@PulumiTagMarker
public class GetArnPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var id: String? = null

    /**
     * @param value ARN to parse.
     */
    @JvmName("awmhdnglrjbmnpqd")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value
     */
    @JvmName("spxfyyuclhgmemig")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetArnPlainArgs = GetArnPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        id = id,
    )
}
