@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetAvailabilityZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAvailabilityZones.
 * @property allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
 * @property excludeNames List of Availability Zone names to exclude.
 * @property excludeZoneIds List of Availability Zone IDs to exclude.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property state Allows to filter list of Availability Zones based on their
 * current state. Can be either `"available"`, `"information"`, `"impaired"` or
 * `"unavailable"`. By default the list includes a complete set of Availability Zones
 * to which the underlying AWS account has access, regardless of their state.
 */
public data class GetAvailabilityZonesPlainArgs(
    public val allAvailabilityZones: Boolean? = null,
    public val excludeNames: List<String>? = null,
    public val excludeZoneIds: List<String>? = null,
    public val filters: List<GetAvailabilityZonesFilter>? = null,
    public val state: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetAvailabilityZonesPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetAvailabilityZonesPlainArgs =
        com.pulumi.aws.inputs.GetAvailabilityZonesPlainArgs.builder()
            .allAvailabilityZones(allAvailabilityZones?.let({ args0 -> args0 }))
            .excludeNames(excludeNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludeZoneIds(excludeZoneIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .state(state?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAvailabilityZonesPlainArgs].
 */
@PulumiTagMarker
public class GetAvailabilityZonesPlainArgsBuilder internal constructor() {
    private var allAvailabilityZones: Boolean? = null

    private var excludeNames: List<String>? = null

    private var excludeZoneIds: List<String>? = null

    private var filters: List<GetAvailabilityZonesFilter>? = null

    private var state: String? = null

    /**
     * @param value Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     */
    @JvmName("jvepdhbegaywdagk")
    public suspend fun allAvailabilityZones(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allAvailabilityZones = mapped
    }

    /**
     * @param value List of Availability Zone names to exclude.
     */
    @JvmName("gaxojosdkjgqdgwy")
    public suspend fun excludeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeNames = mapped
    }

    /**
     * @param values List of Availability Zone names to exclude.
     */
    @JvmName("wxoksmqmghcffvei")
    public suspend fun excludeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.excludeNames = mapped
    }

    /**
     * @param value List of Availability Zone IDs to exclude.
     */
    @JvmName("lvhjvxjcglvgoyfu")
    public suspend fun excludeZoneIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeZoneIds = mapped
    }

    /**
     * @param values List of Availability Zone IDs to exclude.
     */
    @JvmName("wfqtqrxlmrvnhlih")
    public suspend fun excludeZoneIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.excludeZoneIds = mapped
    }

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gibdnfvpqhjigjwa")
    public suspend fun filters(`value`: List<GetAvailabilityZonesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ublawauiyeuppdbx")
    public suspend fun filters(argument: List<suspend GetAvailabilityZonesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetAvailabilityZonesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wkcthsfbntimwper")
    public suspend fun filters(
        vararg
        argument: suspend GetAvailabilityZonesFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetAvailabilityZonesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wkhhriqeccmiugxg")
    public suspend fun filters(argument: suspend GetAvailabilityZonesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAvailabilityZonesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("svpixklrylarwdnk")
    public suspend fun filters(vararg values: GetAvailabilityZonesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Allows to filter list of Availability Zones based on their
     * current state. Can be either `"available"`, `"information"`, `"impaired"` or
     * `"unavailable"`. By default the list includes a complete set of Availability Zones
     * to which the underlying AWS account has access, regardless of their state.
     */
    @JvmName("hbxugkpnyiqefqhl")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    internal fun build(): GetAvailabilityZonesPlainArgs = GetAvailabilityZonesPlainArgs(
        allAvailabilityZones = allAvailabilityZones,
        excludeNames = excludeNames,
        excludeZoneIds = excludeZoneIds,
        filters = filters,
        state = state,
    )
}
