@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetBillingServiceAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBillingServiceAccount.
 * @property id ID of the AWS billing service account.
 */
public data class GetBillingServiceAccountPlainArgs(
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetBillingServiceAccountPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetBillingServiceAccountPlainArgs =
        com.pulumi.aws.inputs.GetBillingServiceAccountPlainArgs.builder()
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingServiceAccountPlainArgs].
 */
@PulumiTagMarker
public class GetBillingServiceAccountPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value ID of the AWS billing service account.
     */
    @JvmName("ppigntynbfimokus")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetBillingServiceAccountPlainArgs = GetBillingServiceAccountPlainArgs(
        id = id,
    )
}
