@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetCallerIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCallerIdentity.
 * @property id Account ID number of the account that owns or contains the calling entity.
 */
public data class GetCallerIdentityPlainArgs(
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetCallerIdentityPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetCallerIdentityPlainArgs =
        com.pulumi.aws.inputs.GetCallerIdentityPlainArgs.builder()
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCallerIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetCallerIdentityPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Account ID number of the account that owns or contains the calling entity.
     */
    @JvmName("fkmdnbfksqwsqqld")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetCallerIdentityPlainArgs = GetCallerIdentityPlainArgs(
        id = id,
    )
}
