@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetPartitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPartition.
 * @property id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
 */
public data class GetPartitionPlainArgs(
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetPartitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetPartitionPlainArgs =
        com.pulumi.aws.inputs.GetPartitionPlainArgs.builder()
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartitionPlainArgs].
 */
@PulumiTagMarker
public class GetPartitionPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     */
    @JvmName("jivypefbpqynifkx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetPartitionPlainArgs = GetPartitionPlainArgs(
        id = id,
    )
}
