@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetRegionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegion.
 * @property endpoint EC2 endpoint of the region to select.
 * @property id
 * @property name Full name of the region to select.
 */
public data class GetRegionPlainArgs(
    public val endpoint: String? = null,
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetRegionPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetRegionPlainArgs =
        com.pulumi.aws.inputs.GetRegionPlainArgs.builder()
            .endpoint(endpoint?.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionPlainArgs].
 */
@PulumiTagMarker
public class GetRegionPlainArgsBuilder internal constructor() {
    private var endpoint: String? = null

    private var id: String? = null

    private var name: String? = null

    /**
     * @param value EC2 endpoint of the region to select.
     */
    @JvmName("rsxmogmryhkftaal")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("psgpwcajibakiyfv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Full name of the region to select.
     */
    @JvmName("ohhalfcdedevoglt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetRegionPlainArgs = GetRegionPlainArgs(
        endpoint = endpoint,
        id = id,
        name = name,
    )
}
