@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegions.
 * @property allRegions If true the source will query all regions regardless of availability.
 * @property filters Configuration block(s) to use as filters. Detailed below.
 * @property id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
 */
public data class GetRegionsPlainArgs(
    public val allRegions: Boolean? = null,
    public val filters: List<GetRegionsFilter>? = null,
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetRegionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetRegionsPlainArgs =
        com.pulumi.aws.inputs.GetRegionsPlainArgs.builder()
            .allRegions(allRegions?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetRegionsPlainArgsBuilder internal constructor() {
    private var allRegions: Boolean? = null

    private var filters: List<GetRegionsFilter>? = null

    private var id: String? = null

    /**
     * @param value If true the source will query all regions regardless of availability.
     */
    @JvmName("nyampjpkibgnapyc")
    public suspend fun allRegions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allRegions = mapped
    }

    /**
     * @param value Configuration block(s) to use as filters. Detailed below.
     */
    @JvmName("gctlxfmuwkmwkbus")
    public suspend fun filters(`value`: List<GetRegionsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) to use as filters. Detailed below.
     */
    @JvmName("mcjdfccfimpvmfrs")
    public suspend fun filters(argument: List<suspend GetRegionsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRegionsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) to use as filters. Detailed below.
     */
    @JvmName("qnxtpcslwqyyxwop")
    public suspend fun filters(vararg argument: suspend GetRegionsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRegionsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) to use as filters. Detailed below.
     */
    @JvmName("cwgbhbkqhixsqmuq")
    public suspend fun filters(argument: suspend GetRegionsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRegionsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) to use as filters. Detailed below.
     */
    @JvmName("qapekcsdabcvcpnf")
    public suspend fun filters(vararg values: GetRegionsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     */
    @JvmName("skogmrlwbudikpth")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetRegionsPlainArgs = GetRegionsPlainArgs(
        allRegions = allRegions,
        filters = filters,
        id = id,
    )
}
