@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderAssumeRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property duration
 * @property externalId
 * @property policy
 * @property policyArns
 * @property roleArn
 * @property sessionName
 * @property sourceIdentity
 * @property tags
 * @property transitiveTagKeys
 */
public data class ProviderAssumeRoleArgs(
    public val duration: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val policyArns: Output<List<String>>? = null,
    public val roleArn: Output<String>? = null,
    public val sessionName: Output<String>? = null,
    public val sourceIdentity: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitiveTagKeys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderAssumeRoleArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderAssumeRoleArgs =
        com.pulumi.aws.inputs.ProviderAssumeRoleArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .policyArns(policyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 }))
            .sourceIdentity(sourceIdentity?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitiveTagKeys(transitiveTagKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProviderAssumeRoleArgs].
 */
@PulumiTagMarker
public class ProviderAssumeRoleArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var externalId: Output<String>? = null

    private var policy: Output<String>? = null

    private var policyArns: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    private var sessionName: Output<String>? = null

    private var sourceIdentity: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitiveTagKeys: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("tjcrfrfiiukuhkkw")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value
     */
    @JvmName("sthvakswksejmmow")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value
     */
    @JvmName("tfcuxuaajcttmihl")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("wsbapphwmurwlmxf")
    public suspend fun policyArns(`value`: Output<List<String>>) {
        this.policyArns = value
    }

    @JvmName("dwracqyurjnlmigu")
    public suspend fun policyArns(vararg values: Output<String>) {
        this.policyArns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ywclfutrgmeadnts")
    public suspend fun policyArns(values: List<Output<String>>) {
        this.policyArns = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("useqbsuvdrokfdke")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("liibalrttwaqdgfd")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value
     */
    @JvmName("wermeftfxomhqqyl")
    public suspend fun sourceIdentity(`value`: Output<String>) {
        this.sourceIdentity = value
    }

    /**
     * @param value
     */
    @JvmName("kcnsumttwfopqjwv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vuvtrealaxholsqj")
    public suspend fun transitiveTagKeys(`value`: Output<List<String>>) {
        this.transitiveTagKeys = value
    }

    @JvmName("emcqfpkisxmrulcx")
    public suspend fun transitiveTagKeys(vararg values: Output<String>) {
        this.transitiveTagKeys = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("swotwbyorwtyxuum")
    public suspend fun transitiveTagKeys(values: List<Output<String>>) {
        this.transitiveTagKeys = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hhikalejlyqpnsja")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value
     */
    @JvmName("reqrexirstxrbmyo")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value
     */
    @JvmName("bfwttfvyoddrrbrd")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwgucfyalnbdtkqu")
    public suspend fun policyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param values
     */
    @JvmName("twtxcnndtvwgihea")
    public suspend fun policyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param value
     */
    @JvmName("ftpkybvrowyvudsd")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("tyvchyrmkhjvbkda")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("yxiytqhscmvapltf")
    public suspend fun sourceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIdentity = mapped
    }

    /**
     * @param value
     */
    @JvmName("flcrtqxwabhenhhl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hoagxelbqgoiaaqe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("axrnpxvbjakwmtbt")
    public suspend fun transitiveTagKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitiveTagKeys = mapped
    }

    /**
     * @param values
     */
    @JvmName("xbeuohywclotaalr")
    public suspend fun transitiveTagKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitiveTagKeys = mapped
    }

    internal fun build(): ProviderAssumeRoleArgs = ProviderAssumeRoleArgs(
        duration = duration,
        externalId = externalId,
        policy = policy,
        policyArns = policyArns,
        roleArn = roleArn,
        sessionName = sessionName,
        sourceIdentity = sourceIdentity,
        tags = tags,
        transitiveTagKeys = transitiveTagKeys,
    )
}
