@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderAssumeRoleWithWebIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property duration
 * @property policy
 * @property policyArns
 * @property roleArn
 * @property sessionName
 * @property webIdentityToken
 * @property webIdentityTokenFile
 */
public data class ProviderAssumeRoleWithWebIdentityArgs(
    public val duration: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val policyArns: Output<List<String>>? = null,
    public val roleArn: Output<String>? = null,
    public val sessionName: Output<String>? = null,
    public val webIdentityToken: Output<String>? = null,
    public val webIdentityTokenFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderAssumeRoleWithWebIdentityArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderAssumeRoleWithWebIdentityArgs =
        com.pulumi.aws.inputs.ProviderAssumeRoleWithWebIdentityArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .policyArns(policyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 }))
            .webIdentityToken(webIdentityToken?.applyValue({ args0 -> args0 }))
            .webIdentityTokenFile(webIdentityTokenFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderAssumeRoleWithWebIdentityArgs].
 */
@PulumiTagMarker
public class ProviderAssumeRoleWithWebIdentityArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var policy: Output<String>? = null

    private var policyArns: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    private var sessionName: Output<String>? = null

    private var webIdentityToken: Output<String>? = null

    private var webIdentityTokenFile: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("bgovosyypyygifsb")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value
     */
    @JvmName("dogbqwtfprvpayyb")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("mwbjsaydaowwxsag")
    public suspend fun policyArns(`value`: Output<List<String>>) {
        this.policyArns = value
    }

    @JvmName("kouoqgdswgkxcwsh")
    public suspend fun policyArns(vararg values: Output<String>) {
        this.policyArns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mtnqogtyikcfyuxa")
    public suspend fun policyArns(values: List<Output<String>>) {
        this.policyArns = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fdbqnedxvadmkhrp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("nhxwsxhvyombiuge")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value
     */
    @JvmName("unkmxwlgkkcdpojy")
    public suspend fun webIdentityToken(`value`: Output<String>) {
        this.webIdentityToken = value
    }

    /**
     * @param value
     */
    @JvmName("mrdxmnxpigavansp")
    public suspend fun webIdentityTokenFile(`value`: Output<String>) {
        this.webIdentityTokenFile = value
    }

    /**
     * @param value
     */
    @JvmName("bniaghgruplcxivg")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value
     */
    @JvmName("cbhdlmbyfqnnfuji")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("spjxaqqetlpiipxw")
    public suspend fun policyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param values
     */
    @JvmName("wubcyqcsuvnykffy")
    public suspend fun policyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param value
     */
    @JvmName("buteuxgfvffrlrlx")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmtoepcowkebguqy")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijxdpqhbiuavpweo")
    public suspend fun webIdentityToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webIdentityToken = mapped
    }

    /**
     * @param value
     */
    @JvmName("ipsdprkdfsytcgir")
    public suspend fun webIdentityTokenFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webIdentityTokenFile = mapped
    }

    internal fun build(): ProviderAssumeRoleWithWebIdentityArgs =
        ProviderAssumeRoleWithWebIdentityArgs(
            duration = duration,
            policy = policy,
            policyArns = policyArns,
            roleArn = roleArn,
            sessionName = sessionName,
            webIdentityToken = webIdentityToken,
            webIdentityTokenFile = webIdentityTokenFile,
        )
}
