@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessanalyzer
 * @property account
 * @property acm
 * @property acmpca
 * @property amg
 * @property amp
 * @property amplify
 * @property apigateway
 * @property apigatewayv2
 * @property appautoscaling
 * @property appconfig
 * @property appfabric
 * @property appflow
 * @property appintegrations
 * @property appintegrationsservice
 * @property applicationautoscaling
 * @property applicationinsights
 * @property appmesh
 * @property apprunner
 * @property appstream
 * @property appsync
 * @property athena
 * @property auditmanager
 * @property autoscaling
 * @property autoscalingplans
 * @property backup
 * @property batch
 * @property beanstalk
 * @property bedrock
 * @property budgets
 * @property ce
 * @property chime
 * @property chimesdkmediapipelines
 * @property chimesdkvoice
 * @property cleanrooms
 * @property cloud9
 * @property cloudcontrol
 * @property cloudcontrolapi
 * @property cloudformation
 * @property cloudfront
 * @property cloudhsm
 * @property cloudhsmv2
 * @property cloudsearch
 * @property cloudtrail
 * @property cloudwatch
 * @property cloudwatchevents
 * @property cloudwatchevidently
 * @property cloudwatchlog
 * @property cloudwatchlogs
 * @property cloudwatchobservabilityaccessmanager
 * @property cloudwatchrum
 * @property codeartifact
 * @property codebuild
 * @property codecatalyst
 * @property codecommit
 * @property codedeploy
 * @property codeguruprofiler
 * @property codegurureviewer
 * @property codepipeline
 * @property codestarconnections
 * @property codestarnotifications
 * @property cognitoidentity
 * @property cognitoidentityprovider
 * @property cognitoidp
 * @property comprehend
 * @property computeoptimizer
 * @property config
 * @property configservice
 * @property connect
 * @property connectcases
 * @property controltower
 * @property costandusagereportservice
 * @property costexplorer
 * @property cur
 * @property customerprofiles
 * @property databasemigration
 * @property databasemigrationservice
 * @property dataexchange
 * @property datapipeline
 * @property datasync
 * @property dax
 * @property deploy
 * @property detective
 * @property devicefarm
 * @property directconnect
 * @property directoryservice
 * @property dlm
 * @property dms
 * @property docdb
 * @property docdbelastic
 * @property ds
 * @property dynamodb
 * @property ec2
 * @property ecr
 * @property ecrpublic
 * @property ecs
 * @property efs
 * @property eks
 * @property elasticache
 * @property elasticbeanstalk
 * @property elasticloadbalancing
 * @property elasticloadbalancingv2
 * @property elasticsearch
 * @property elasticsearchservice
 * @property elastictranscoder
 * @property elb
 * @property elbv2
 * @property emr
 * @property emrcontainers
 * @property emrserverless
 * @property es
 * @property eventbridge
 * @property events
 * @property evidently
 * @property finspace
 * @property firehose
 * @property fis
 * @property fms
 * @property fsx
 * @property gamelift
 * @property glacier
 * @property globalaccelerator
 * @property glue
 * @property grafana
 * @property greengrass
 * @property guardduty
 * @property healthlake
 * @property iam
 * @property identitystore
 * @property imagebuilder
 * @property inspector
 * @property inspector2
 * @property inspectorv2
 * @property internetmonitor
 * @property iot
 * @property iotanalytics
 * @property iotevents
 * @property ivs
 * @property ivschat
 * @property kafka
 * @property kafkaconnect
 * @property kendra
 * @property keyspaces
 * @property kinesis
 * @property kinesisanalytics
 * @property kinesisanalyticsv2
 * @property kinesisvideo
 * @property kms
 * @property lakeformation
 * @property lambda
 * @property lex
 * @property lexmodelbuilding
 * @property lexmodelbuildingservice
 * @property lexmodels
 * @property lexmodelsv2
 * @property lexv2models
 * @property licensemanager
 * @property lightsail
 * @property location
 * @property locationservice
 * @property logs
 * @property macie2
 * @property managedgrafana
 * @property mediaconnect
 * @property mediaconvert
 * @property medialive
 * @property mediapackage
 * @property mediapackagev2
 * @property mediastore
 * @property memorydb
 * @property mq
 * @property msk
 * @property mwaa
 * @property neptune
 * @property networkfirewall
 * @property networkmanager
 * @property oam
 * @property opensearch
 * @property opensearchingestion
 * @property opensearchserverless
 * @property opensearchservice
 * @property opsworks
 * @property organizations
 * @property osis
 * @property outposts
 * @property pinpoint
 * @property pipes
 * @property pricing
 * @property prometheus
 * @property prometheusservice
 * @property qldb
 * @property quicksight
 * @property ram
 * @property rbin
 * @property rds
 * @property recyclebin
 * @property redshift
 * @property redshiftdata
 * @property redshiftdataapiservice
 * @property redshiftserverless
 * @property resourceexplorer2
 * @property resourcegroups
 * @property resourcegroupstagging
 * @property resourcegroupstaggingapi
 * @property rolesanywhere
 * @property route53
 * @property route53domains
 * @property route53recoverycontrolconfig
 * @property route53recoveryreadiness
 * @property route53resolver
 * @property rum
 * @property s3
 * @property s3api
 * @property s3control
 * @property s3outposts
 * @property sagemaker
 * @property scheduler
 * @property schemas
 * @property sdb
 * @property secretsmanager
 * @property securityhub
 * @property securitylake
 * @property serverlessapplicationrepository
 * @property serverlessapprepo
 * @property serverlessrepo
 * @property servicecatalog
 * @property servicediscovery
 * @property servicequotas
 * @property ses
 * @property sesv2
 * @property sfn
 * @property shield
 * @property signer
 * @property simpledb
 * @property sns
 * @property sqs
 * @property ssm
 * @property ssmcontacts
 * @property ssmincidents
 * @property sso
 * @property ssoadmin
 * @property stepfunctions
 * @property storagegateway
 * @property sts
 * @property swf
 * @property synthetics
 * @property timestreamwrite
 * @property transcribe
 * @property transcribeservice
 * @property transfer
 * @property verifiedpermissions
 * @property vpclattice
 * @property waf
 * @property wafregional
 * @property wafv2
 * @property worklink
 * @property workspaces
 * @property xray
 */
public data class ProviderEndpointArgs(
    public val accessanalyzer: Output<String>? = null,
    public val account: Output<String>? = null,
    public val acm: Output<String>? = null,
    public val acmpca: Output<String>? = null,
    public val amg: Output<String>? = null,
    public val amp: Output<String>? = null,
    public val amplify: Output<String>? = null,
    public val apigateway: Output<String>? = null,
    public val apigatewayv2: Output<String>? = null,
    public val appautoscaling: Output<String>? = null,
    public val appconfig: Output<String>? = null,
    public val appfabric: Output<String>? = null,
    public val appflow: Output<String>? = null,
    public val appintegrations: Output<String>? = null,
    public val appintegrationsservice: Output<String>? = null,
    public val applicationautoscaling: Output<String>? = null,
    public val applicationinsights: Output<String>? = null,
    public val appmesh: Output<String>? = null,
    public val apprunner: Output<String>? = null,
    public val appstream: Output<String>? = null,
    public val appsync: Output<String>? = null,
    public val athena: Output<String>? = null,
    public val auditmanager: Output<String>? = null,
    public val autoscaling: Output<String>? = null,
    public val autoscalingplans: Output<String>? = null,
    public val backup: Output<String>? = null,
    public val batch: Output<String>? = null,
    public val beanstalk: Output<String>? = null,
    public val bedrock: Output<String>? = null,
    public val budgets: Output<String>? = null,
    public val ce: Output<String>? = null,
    public val chime: Output<String>? = null,
    public val chimesdkmediapipelines: Output<String>? = null,
    public val chimesdkvoice: Output<String>? = null,
    public val cleanrooms: Output<String>? = null,
    public val cloud9: Output<String>? = null,
    public val cloudcontrol: Output<String>? = null,
    public val cloudcontrolapi: Output<String>? = null,
    public val cloudformation: Output<String>? = null,
    public val cloudfront: Output<String>? = null,
    public val cloudhsm: Output<String>? = null,
    public val cloudhsmv2: Output<String>? = null,
    public val cloudsearch: Output<String>? = null,
    public val cloudtrail: Output<String>? = null,
    public val cloudwatch: Output<String>? = null,
    public val cloudwatchevents: Output<String>? = null,
    public val cloudwatchevidently: Output<String>? = null,
    public val cloudwatchlog: Output<String>? = null,
    public val cloudwatchlogs: Output<String>? = null,
    public val cloudwatchobservabilityaccessmanager: Output<String>? = null,
    public val cloudwatchrum: Output<String>? = null,
    public val codeartifact: Output<String>? = null,
    public val codebuild: Output<String>? = null,
    public val codecatalyst: Output<String>? = null,
    public val codecommit: Output<String>? = null,
    public val codedeploy: Output<String>? = null,
    public val codeguruprofiler: Output<String>? = null,
    public val codegurureviewer: Output<String>? = null,
    public val codepipeline: Output<String>? = null,
    public val codestarconnections: Output<String>? = null,
    public val codestarnotifications: Output<String>? = null,
    public val cognitoidentity: Output<String>? = null,
    public val cognitoidentityprovider: Output<String>? = null,
    public val cognitoidp: Output<String>? = null,
    public val comprehend: Output<String>? = null,
    public val computeoptimizer: Output<String>? = null,
    public val config: Output<String>? = null,
    public val configservice: Output<String>? = null,
    public val connect: Output<String>? = null,
    public val connectcases: Output<String>? = null,
    public val controltower: Output<String>? = null,
    public val costandusagereportservice: Output<String>? = null,
    public val costexplorer: Output<String>? = null,
    public val cur: Output<String>? = null,
    public val customerprofiles: Output<String>? = null,
    public val databasemigration: Output<String>? = null,
    public val databasemigrationservice: Output<String>? = null,
    public val dataexchange: Output<String>? = null,
    public val datapipeline: Output<String>? = null,
    public val datasync: Output<String>? = null,
    public val dax: Output<String>? = null,
    public val deploy: Output<String>? = null,
    public val detective: Output<String>? = null,
    public val devicefarm: Output<String>? = null,
    public val directconnect: Output<String>? = null,
    public val directoryservice: Output<String>? = null,
    public val dlm: Output<String>? = null,
    public val dms: Output<String>? = null,
    public val docdb: Output<String>? = null,
    public val docdbelastic: Output<String>? = null,
    public val ds: Output<String>? = null,
    public val dynamodb: Output<String>? = null,
    public val ec2: Output<String>? = null,
    public val ecr: Output<String>? = null,
    public val ecrpublic: Output<String>? = null,
    public val ecs: Output<String>? = null,
    public val efs: Output<String>? = null,
    public val eks: Output<String>? = null,
    public val elasticache: Output<String>? = null,
    public val elasticbeanstalk: Output<String>? = null,
    public val elasticloadbalancing: Output<String>? = null,
    public val elasticloadbalancingv2: Output<String>? = null,
    public val elasticsearch: Output<String>? = null,
    public val elasticsearchservice: Output<String>? = null,
    public val elastictranscoder: Output<String>? = null,
    public val elb: Output<String>? = null,
    public val elbv2: Output<String>? = null,
    public val emr: Output<String>? = null,
    public val emrcontainers: Output<String>? = null,
    public val emrserverless: Output<String>? = null,
    public val es: Output<String>? = null,
    public val eventbridge: Output<String>? = null,
    public val events: Output<String>? = null,
    public val evidently: Output<String>? = null,
    public val finspace: Output<String>? = null,
    public val firehose: Output<String>? = null,
    public val fis: Output<String>? = null,
    public val fms: Output<String>? = null,
    public val fsx: Output<String>? = null,
    public val gamelift: Output<String>? = null,
    public val glacier: Output<String>? = null,
    public val globalaccelerator: Output<String>? = null,
    public val glue: Output<String>? = null,
    public val grafana: Output<String>? = null,
    public val greengrass: Output<String>? = null,
    public val guardduty: Output<String>? = null,
    public val healthlake: Output<String>? = null,
    public val iam: Output<String>? = null,
    public val identitystore: Output<String>? = null,
    public val imagebuilder: Output<String>? = null,
    public val inspector: Output<String>? = null,
    public val inspector2: Output<String>? = null,
    public val inspectorv2: Output<String>? = null,
    public val internetmonitor: Output<String>? = null,
    public val iot: Output<String>? = null,
    public val iotanalytics: Output<String>? = null,
    public val iotevents: Output<String>? = null,
    public val ivs: Output<String>? = null,
    public val ivschat: Output<String>? = null,
    public val kafka: Output<String>? = null,
    public val kafkaconnect: Output<String>? = null,
    public val kendra: Output<String>? = null,
    public val keyspaces: Output<String>? = null,
    public val kinesis: Output<String>? = null,
    public val kinesisanalytics: Output<String>? = null,
    public val kinesisanalyticsv2: Output<String>? = null,
    public val kinesisvideo: Output<String>? = null,
    public val kms: Output<String>? = null,
    public val lakeformation: Output<String>? = null,
    public val lambda: Output<String>? = null,
    public val lex: Output<String>? = null,
    public val lexmodelbuilding: Output<String>? = null,
    public val lexmodelbuildingservice: Output<String>? = null,
    public val lexmodels: Output<String>? = null,
    public val lexmodelsv2: Output<String>? = null,
    public val lexv2models: Output<String>? = null,
    public val licensemanager: Output<String>? = null,
    public val lightsail: Output<String>? = null,
    public val location: Output<String>? = null,
    public val locationservice: Output<String>? = null,
    public val logs: Output<String>? = null,
    public val macie2: Output<String>? = null,
    public val managedgrafana: Output<String>? = null,
    public val mediaconnect: Output<String>? = null,
    public val mediaconvert: Output<String>? = null,
    public val medialive: Output<String>? = null,
    public val mediapackage: Output<String>? = null,
    public val mediapackagev2: Output<String>? = null,
    public val mediastore: Output<String>? = null,
    public val memorydb: Output<String>? = null,
    public val mq: Output<String>? = null,
    public val msk: Output<String>? = null,
    public val mwaa: Output<String>? = null,
    public val neptune: Output<String>? = null,
    public val networkfirewall: Output<String>? = null,
    public val networkmanager: Output<String>? = null,
    public val oam: Output<String>? = null,
    public val opensearch: Output<String>? = null,
    public val opensearchingestion: Output<String>? = null,
    public val opensearchserverless: Output<String>? = null,
    public val opensearchservice: Output<String>? = null,
    public val opsworks: Output<String>? = null,
    public val organizations: Output<String>? = null,
    public val osis: Output<String>? = null,
    public val outposts: Output<String>? = null,
    public val pinpoint: Output<String>? = null,
    public val pipes: Output<String>? = null,
    public val pricing: Output<String>? = null,
    public val prometheus: Output<String>? = null,
    public val prometheusservice: Output<String>? = null,
    public val qldb: Output<String>? = null,
    public val quicksight: Output<String>? = null,
    public val ram: Output<String>? = null,
    public val rbin: Output<String>? = null,
    public val rds: Output<String>? = null,
    public val recyclebin: Output<String>? = null,
    public val redshift: Output<String>? = null,
    public val redshiftdata: Output<String>? = null,
    public val redshiftdataapiservice: Output<String>? = null,
    public val redshiftserverless: Output<String>? = null,
    public val resourceexplorer2: Output<String>? = null,
    public val resourcegroups: Output<String>? = null,
    public val resourcegroupstagging: Output<String>? = null,
    public val resourcegroupstaggingapi: Output<String>? = null,
    public val rolesanywhere: Output<String>? = null,
    public val route53: Output<String>? = null,
    public val route53domains: Output<String>? = null,
    public val route53recoverycontrolconfig: Output<String>? = null,
    public val route53recoveryreadiness: Output<String>? = null,
    public val route53resolver: Output<String>? = null,
    public val rum: Output<String>? = null,
    public val s3: Output<String>? = null,
    public val s3api: Output<String>? = null,
    public val s3control: Output<String>? = null,
    public val s3outposts: Output<String>? = null,
    public val sagemaker: Output<String>? = null,
    public val scheduler: Output<String>? = null,
    public val schemas: Output<String>? = null,
    public val sdb: Output<String>? = null,
    public val secretsmanager: Output<String>? = null,
    public val securityhub: Output<String>? = null,
    public val securitylake: Output<String>? = null,
    public val serverlessapplicationrepository: Output<String>? = null,
    public val serverlessapprepo: Output<String>? = null,
    public val serverlessrepo: Output<String>? = null,
    public val servicecatalog: Output<String>? = null,
    public val servicediscovery: Output<String>? = null,
    public val servicequotas: Output<String>? = null,
    public val ses: Output<String>? = null,
    public val sesv2: Output<String>? = null,
    public val sfn: Output<String>? = null,
    public val shield: Output<String>? = null,
    public val signer: Output<String>? = null,
    public val simpledb: Output<String>? = null,
    public val sns: Output<String>? = null,
    public val sqs: Output<String>? = null,
    public val ssm: Output<String>? = null,
    public val ssmcontacts: Output<String>? = null,
    public val ssmincidents: Output<String>? = null,
    public val sso: Output<String>? = null,
    public val ssoadmin: Output<String>? = null,
    public val stepfunctions: Output<String>? = null,
    public val storagegateway: Output<String>? = null,
    public val sts: Output<String>? = null,
    public val swf: Output<String>? = null,
    public val synthetics: Output<String>? = null,
    public val timestreamwrite: Output<String>? = null,
    public val transcribe: Output<String>? = null,
    public val transcribeservice: Output<String>? = null,
    public val transfer: Output<String>? = null,
    public val verifiedpermissions: Output<String>? = null,
    public val vpclattice: Output<String>? = null,
    public val waf: Output<String>? = null,
    public val wafregional: Output<String>? = null,
    public val wafv2: Output<String>? = null,
    public val worklink: Output<String>? = null,
    public val workspaces: Output<String>? = null,
    public val xray: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderEndpointArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderEndpointArgs =
        com.pulumi.aws.inputs.ProviderEndpointArgs.builder()
            .accessanalyzer(accessanalyzer?.applyValue({ args0 -> args0 }))
            .account(account?.applyValue({ args0 -> args0 }))
            .acm(acm?.applyValue({ args0 -> args0 }))
            .acmpca(acmpca?.applyValue({ args0 -> args0 }))
            .amg(amg?.applyValue({ args0 -> args0 }))
            .amp(amp?.applyValue({ args0 -> args0 }))
            .amplify(amplify?.applyValue({ args0 -> args0 }))
            .apigateway(apigateway?.applyValue({ args0 -> args0 }))
            .apigatewayv2(apigatewayv2?.applyValue({ args0 -> args0 }))
            .appautoscaling(appautoscaling?.applyValue({ args0 -> args0 }))
            .appconfig(appconfig?.applyValue({ args0 -> args0 }))
            .appfabric(appfabric?.applyValue({ args0 -> args0 }))
            .appflow(appflow?.applyValue({ args0 -> args0 }))
            .appintegrations(appintegrations?.applyValue({ args0 -> args0 }))
            .appintegrationsservice(appintegrationsservice?.applyValue({ args0 -> args0 }))
            .applicationautoscaling(applicationautoscaling?.applyValue({ args0 -> args0 }))
            .applicationinsights(applicationinsights?.applyValue({ args0 -> args0 }))
            .appmesh(appmesh?.applyValue({ args0 -> args0 }))
            .apprunner(apprunner?.applyValue({ args0 -> args0 }))
            .appstream(appstream?.applyValue({ args0 -> args0 }))
            .appsync(appsync?.applyValue({ args0 -> args0 }))
            .athena(athena?.applyValue({ args0 -> args0 }))
            .auditmanager(auditmanager?.applyValue({ args0 -> args0 }))
            .autoscaling(autoscaling?.applyValue({ args0 -> args0 }))
            .autoscalingplans(autoscalingplans?.applyValue({ args0 -> args0 }))
            .backup(backup?.applyValue({ args0 -> args0 }))
            .batch(batch?.applyValue({ args0 -> args0 }))
            .beanstalk(beanstalk?.applyValue({ args0 -> args0 }))
            .bedrock(bedrock?.applyValue({ args0 -> args0 }))
            .budgets(budgets?.applyValue({ args0 -> args0 }))
            .ce(ce?.applyValue({ args0 -> args0 }))
            .chime(chime?.applyValue({ args0 -> args0 }))
            .chimesdkmediapipelines(chimesdkmediapipelines?.applyValue({ args0 -> args0 }))
            .chimesdkvoice(chimesdkvoice?.applyValue({ args0 -> args0 }))
            .cleanrooms(cleanrooms?.applyValue({ args0 -> args0 }))
            .cloud9(cloud9?.applyValue({ args0 -> args0 }))
            .cloudcontrol(cloudcontrol?.applyValue({ args0 -> args0 }))
            .cloudcontrolapi(cloudcontrolapi?.applyValue({ args0 -> args0 }))
            .cloudformation(cloudformation?.applyValue({ args0 -> args0 }))
            .cloudfront(cloudfront?.applyValue({ args0 -> args0 }))
            .cloudhsm(cloudhsm?.applyValue({ args0 -> args0 }))
            .cloudhsmv2(cloudhsmv2?.applyValue({ args0 -> args0 }))
            .cloudsearch(cloudsearch?.applyValue({ args0 -> args0 }))
            .cloudtrail(cloudtrail?.applyValue({ args0 -> args0 }))
            .cloudwatch(cloudwatch?.applyValue({ args0 -> args0 }))
            .cloudwatchevents(cloudwatchevents?.applyValue({ args0 -> args0 }))
            .cloudwatchevidently(cloudwatchevidently?.applyValue({ args0 -> args0 }))
            .cloudwatchlog(cloudwatchlog?.applyValue({ args0 -> args0 }))
            .cloudwatchlogs(cloudwatchlogs?.applyValue({ args0 -> args0 }))
            .cloudwatchobservabilityaccessmanager(
                cloudwatchobservabilityaccessmanager?.applyValue({ args0 ->
                    args0
                }),
            )
            .cloudwatchrum(cloudwatchrum?.applyValue({ args0 -> args0 }))
            .codeartifact(codeartifact?.applyValue({ args0 -> args0 }))
            .codebuild(codebuild?.applyValue({ args0 -> args0 }))
            .codecatalyst(codecatalyst?.applyValue({ args0 -> args0 }))
            .codecommit(codecommit?.applyValue({ args0 -> args0 }))
            .codedeploy(codedeploy?.applyValue({ args0 -> args0 }))
            .codeguruprofiler(codeguruprofiler?.applyValue({ args0 -> args0 }))
            .codegurureviewer(codegurureviewer?.applyValue({ args0 -> args0 }))
            .codepipeline(codepipeline?.applyValue({ args0 -> args0 }))
            .codestarconnections(codestarconnections?.applyValue({ args0 -> args0 }))
            .codestarnotifications(codestarnotifications?.applyValue({ args0 -> args0 }))
            .cognitoidentity(cognitoidentity?.applyValue({ args0 -> args0 }))
            .cognitoidentityprovider(cognitoidentityprovider?.applyValue({ args0 -> args0 }))
            .cognitoidp(cognitoidp?.applyValue({ args0 -> args0 }))
            .comprehend(comprehend?.applyValue({ args0 -> args0 }))
            .computeoptimizer(computeoptimizer?.applyValue({ args0 -> args0 }))
            .config(config?.applyValue({ args0 -> args0 }))
            .configservice(configservice?.applyValue({ args0 -> args0 }))
            .connect(connect?.applyValue({ args0 -> args0 }))
            .connectcases(connectcases?.applyValue({ args0 -> args0 }))
            .controltower(controltower?.applyValue({ args0 -> args0 }))
            .costandusagereportservice(costandusagereportservice?.applyValue({ args0 -> args0 }))
            .costexplorer(costexplorer?.applyValue({ args0 -> args0 }))
            .cur(cur?.applyValue({ args0 -> args0 }))
            .customerprofiles(customerprofiles?.applyValue({ args0 -> args0 }))
            .databasemigration(databasemigration?.applyValue({ args0 -> args0 }))
            .databasemigrationservice(databasemigrationservice?.applyValue({ args0 -> args0 }))
            .dataexchange(dataexchange?.applyValue({ args0 -> args0 }))
            .datapipeline(datapipeline?.applyValue({ args0 -> args0 }))
            .datasync(datasync?.applyValue({ args0 -> args0 }))
            .dax(dax?.applyValue({ args0 -> args0 }))
            .deploy(deploy?.applyValue({ args0 -> args0 }))
            .detective(detective?.applyValue({ args0 -> args0 }))
            .devicefarm(devicefarm?.applyValue({ args0 -> args0 }))
            .directconnect(directconnect?.applyValue({ args0 -> args0 }))
            .directoryservice(directoryservice?.applyValue({ args0 -> args0 }))
            .dlm(dlm?.applyValue({ args0 -> args0 }))
            .dms(dms?.applyValue({ args0 -> args0 }))
            .docdb(docdb?.applyValue({ args0 -> args0 }))
            .docdbelastic(docdbelastic?.applyValue({ args0 -> args0 }))
            .ds(ds?.applyValue({ args0 -> args0 }))
            .dynamodb(dynamodb?.applyValue({ args0 -> args0 }))
            .ec2(ec2?.applyValue({ args0 -> args0 }))
            .ecr(ecr?.applyValue({ args0 -> args0 }))
            .ecrpublic(ecrpublic?.applyValue({ args0 -> args0 }))
            .ecs(ecs?.applyValue({ args0 -> args0 }))
            .efs(efs?.applyValue({ args0 -> args0 }))
            .eks(eks?.applyValue({ args0 -> args0 }))
            .elasticache(elasticache?.applyValue({ args0 -> args0 }))
            .elasticbeanstalk(elasticbeanstalk?.applyValue({ args0 -> args0 }))
            .elasticloadbalancing(elasticloadbalancing?.applyValue({ args0 -> args0 }))
            .elasticloadbalancingv2(elasticloadbalancingv2?.applyValue({ args0 -> args0 }))
            .elasticsearch(elasticsearch?.applyValue({ args0 -> args0 }))
            .elasticsearchservice(elasticsearchservice?.applyValue({ args0 -> args0 }))
            .elastictranscoder(elastictranscoder?.applyValue({ args0 -> args0 }))
            .elb(elb?.applyValue({ args0 -> args0 }))
            .elbv2(elbv2?.applyValue({ args0 -> args0 }))
            .emr(emr?.applyValue({ args0 -> args0 }))
            .emrcontainers(emrcontainers?.applyValue({ args0 -> args0 }))
            .emrserverless(emrserverless?.applyValue({ args0 -> args0 }))
            .es(es?.applyValue({ args0 -> args0 }))
            .eventbridge(eventbridge?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0 }))
            .evidently(evidently?.applyValue({ args0 -> args0 }))
            .finspace(finspace?.applyValue({ args0 -> args0 }))
            .firehose(firehose?.applyValue({ args0 -> args0 }))
            .fis(fis?.applyValue({ args0 -> args0 }))
            .fms(fms?.applyValue({ args0 -> args0 }))
            .fsx(fsx?.applyValue({ args0 -> args0 }))
            .gamelift(gamelift?.applyValue({ args0 -> args0 }))
            .glacier(glacier?.applyValue({ args0 -> args0 }))
            .globalaccelerator(globalaccelerator?.applyValue({ args0 -> args0 }))
            .glue(glue?.applyValue({ args0 -> args0 }))
            .grafana(grafana?.applyValue({ args0 -> args0 }))
            .greengrass(greengrass?.applyValue({ args0 -> args0 }))
            .guardduty(guardduty?.applyValue({ args0 -> args0 }))
            .healthlake(healthlake?.applyValue({ args0 -> args0 }))
            .iam(iam?.applyValue({ args0 -> args0 }))
            .identitystore(identitystore?.applyValue({ args0 -> args0 }))
            .imagebuilder(imagebuilder?.applyValue({ args0 -> args0 }))
            .inspector(inspector?.applyValue({ args0 -> args0 }))
            .inspector2(inspector2?.applyValue({ args0 -> args0 }))
            .inspectorv2(inspectorv2?.applyValue({ args0 -> args0 }))
            .internetmonitor(internetmonitor?.applyValue({ args0 -> args0 }))
            .iot(iot?.applyValue({ args0 -> args0 }))
            .iotanalytics(iotanalytics?.applyValue({ args0 -> args0 }))
            .iotevents(iotevents?.applyValue({ args0 -> args0 }))
            .ivs(ivs?.applyValue({ args0 -> args0 }))
            .ivschat(ivschat?.applyValue({ args0 -> args0 }))
            .kafka(kafka?.applyValue({ args0 -> args0 }))
            .kafkaconnect(kafkaconnect?.applyValue({ args0 -> args0 }))
            .kendra(kendra?.applyValue({ args0 -> args0 }))
            .keyspaces(keyspaces?.applyValue({ args0 -> args0 }))
            .kinesis(kinesis?.applyValue({ args0 -> args0 }))
            .kinesisanalytics(kinesisanalytics?.applyValue({ args0 -> args0 }))
            .kinesisanalyticsv2(kinesisanalyticsv2?.applyValue({ args0 -> args0 }))
            .kinesisvideo(kinesisvideo?.applyValue({ args0 -> args0 }))
            .kms(kms?.applyValue({ args0 -> args0 }))
            .lakeformation(lakeformation?.applyValue({ args0 -> args0 }))
            .lambda(lambda?.applyValue({ args0 -> args0 }))
            .lex(lex?.applyValue({ args0 -> args0 }))
            .lexmodelbuilding(lexmodelbuilding?.applyValue({ args0 -> args0 }))
            .lexmodelbuildingservice(lexmodelbuildingservice?.applyValue({ args0 -> args0 }))
            .lexmodels(lexmodels?.applyValue({ args0 -> args0 }))
            .lexmodelsv2(lexmodelsv2?.applyValue({ args0 -> args0 }))
            .lexv2models(lexv2models?.applyValue({ args0 -> args0 }))
            .licensemanager(licensemanager?.applyValue({ args0 -> args0 }))
            .lightsail(lightsail?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .locationservice(locationservice?.applyValue({ args0 -> args0 }))
            .logs(logs?.applyValue({ args0 -> args0 }))
            .macie2(macie2?.applyValue({ args0 -> args0 }))
            .managedgrafana(managedgrafana?.applyValue({ args0 -> args0 }))
            .mediaconnect(mediaconnect?.applyValue({ args0 -> args0 }))
            .mediaconvert(mediaconvert?.applyValue({ args0 -> args0 }))
            .medialive(medialive?.applyValue({ args0 -> args0 }))
            .mediapackage(mediapackage?.applyValue({ args0 -> args0 }))
            .mediapackagev2(mediapackagev2?.applyValue({ args0 -> args0 }))
            .mediastore(mediastore?.applyValue({ args0 -> args0 }))
            .memorydb(memorydb?.applyValue({ args0 -> args0 }))
            .mq(mq?.applyValue({ args0 -> args0 }))
            .msk(msk?.applyValue({ args0 -> args0 }))
            .mwaa(mwaa?.applyValue({ args0 -> args0 }))
            .neptune(neptune?.applyValue({ args0 -> args0 }))
            .networkfirewall(networkfirewall?.applyValue({ args0 -> args0 }))
            .networkmanager(networkmanager?.applyValue({ args0 -> args0 }))
            .oam(oam?.applyValue({ args0 -> args0 }))
            .opensearch(opensearch?.applyValue({ args0 -> args0 }))
            .opensearchingestion(opensearchingestion?.applyValue({ args0 -> args0 }))
            .opensearchserverless(opensearchserverless?.applyValue({ args0 -> args0 }))
            .opensearchservice(opensearchservice?.applyValue({ args0 -> args0 }))
            .opsworks(opsworks?.applyValue({ args0 -> args0 }))
            .organizations(organizations?.applyValue({ args0 -> args0 }))
            .osis(osis?.applyValue({ args0 -> args0 }))
            .outposts(outposts?.applyValue({ args0 -> args0 }))
            .pinpoint(pinpoint?.applyValue({ args0 -> args0 }))
            .pipes(pipes?.applyValue({ args0 -> args0 }))
            .pricing(pricing?.applyValue({ args0 -> args0 }))
            .prometheus(prometheus?.applyValue({ args0 -> args0 }))
            .prometheusservice(prometheusservice?.applyValue({ args0 -> args0 }))
            .qldb(qldb?.applyValue({ args0 -> args0 }))
            .quicksight(quicksight?.applyValue({ args0 -> args0 }))
            .ram(ram?.applyValue({ args0 -> args0 }))
            .rbin(rbin?.applyValue({ args0 -> args0 }))
            .rds(rds?.applyValue({ args0 -> args0 }))
            .recyclebin(recyclebin?.applyValue({ args0 -> args0 }))
            .redshift(redshift?.applyValue({ args0 -> args0 }))
            .redshiftdata(redshiftdata?.applyValue({ args0 -> args0 }))
            .redshiftdataapiservice(redshiftdataapiservice?.applyValue({ args0 -> args0 }))
            .redshiftserverless(redshiftserverless?.applyValue({ args0 -> args0 }))
            .resourceexplorer2(resourceexplorer2?.applyValue({ args0 -> args0 }))
            .resourcegroups(resourcegroups?.applyValue({ args0 -> args0 }))
            .resourcegroupstagging(resourcegroupstagging?.applyValue({ args0 -> args0 }))
            .resourcegroupstaggingapi(resourcegroupstaggingapi?.applyValue({ args0 -> args0 }))
            .rolesanywhere(rolesanywhere?.applyValue({ args0 -> args0 }))
            .route53(route53?.applyValue({ args0 -> args0 }))
            .route53domains(route53domains?.applyValue({ args0 -> args0 }))
            .route53recoverycontrolconfig(route53recoverycontrolconfig?.applyValue({ args0 -> args0 }))
            .route53recoveryreadiness(route53recoveryreadiness?.applyValue({ args0 -> args0 }))
            .route53resolver(route53resolver?.applyValue({ args0 -> args0 }))
            .rum(rum?.applyValue({ args0 -> args0 }))
            .s3(s3?.applyValue({ args0 -> args0 }))
            .s3api(s3api?.applyValue({ args0 -> args0 }))
            .s3control(s3control?.applyValue({ args0 -> args0 }))
            .s3outposts(s3outposts?.applyValue({ args0 -> args0 }))
            .sagemaker(sagemaker?.applyValue({ args0 -> args0 }))
            .scheduler(scheduler?.applyValue({ args0 -> args0 }))
            .schemas(schemas?.applyValue({ args0 -> args0 }))
            .sdb(sdb?.applyValue({ args0 -> args0 }))
            .secretsmanager(secretsmanager?.applyValue({ args0 -> args0 }))
            .securityhub(securityhub?.applyValue({ args0 -> args0 }))
            .securitylake(securitylake?.applyValue({ args0 -> args0 }))
            .serverlessapplicationrepository(serverlessapplicationrepository?.applyValue({ args0 -> args0 }))
            .serverlessapprepo(serverlessapprepo?.applyValue({ args0 -> args0 }))
            .serverlessrepo(serverlessrepo?.applyValue({ args0 -> args0 }))
            .servicecatalog(servicecatalog?.applyValue({ args0 -> args0 }))
            .servicediscovery(servicediscovery?.applyValue({ args0 -> args0 }))
            .servicequotas(servicequotas?.applyValue({ args0 -> args0 }))
            .ses(ses?.applyValue({ args0 -> args0 }))
            .sesv2(sesv2?.applyValue({ args0 -> args0 }))
            .sfn(sfn?.applyValue({ args0 -> args0 }))
            .shield(shield?.applyValue({ args0 -> args0 }))
            .signer(signer?.applyValue({ args0 -> args0 }))
            .simpledb(simpledb?.applyValue({ args0 -> args0 }))
            .sns(sns?.applyValue({ args0 -> args0 }))
            .sqs(sqs?.applyValue({ args0 -> args0 }))
            .ssm(ssm?.applyValue({ args0 -> args0 }))
            .ssmcontacts(ssmcontacts?.applyValue({ args0 -> args0 }))
            .ssmincidents(ssmincidents?.applyValue({ args0 -> args0 }))
            .sso(sso?.applyValue({ args0 -> args0 }))
            .ssoadmin(ssoadmin?.applyValue({ args0 -> args0 }))
            .stepfunctions(stepfunctions?.applyValue({ args0 -> args0 }))
            .storagegateway(storagegateway?.applyValue({ args0 -> args0 }))
            .sts(sts?.applyValue({ args0 -> args0 }))
            .swf(swf?.applyValue({ args0 -> args0 }))
            .synthetics(synthetics?.applyValue({ args0 -> args0 }))
            .timestreamwrite(timestreamwrite?.applyValue({ args0 -> args0 }))
            .transcribe(transcribe?.applyValue({ args0 -> args0 }))
            .transcribeservice(transcribeservice?.applyValue({ args0 -> args0 }))
            .transfer(transfer?.applyValue({ args0 -> args0 }))
            .verifiedpermissions(verifiedpermissions?.applyValue({ args0 -> args0 }))
            .vpclattice(vpclattice?.applyValue({ args0 -> args0 }))
            .waf(waf?.applyValue({ args0 -> args0 }))
            .wafregional(wafregional?.applyValue({ args0 -> args0 }))
            .wafv2(wafv2?.applyValue({ args0 -> args0 }))
            .worklink(worklink?.applyValue({ args0 -> args0 }))
            .workspaces(workspaces?.applyValue({ args0 -> args0 }))
            .xray(xray?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderEndpointArgs].
 */
@PulumiTagMarker
public class ProviderEndpointArgsBuilder internal constructor() {
    private var accessanalyzer: Output<String>? = null

    private var account: Output<String>? = null

    private var acm: Output<String>? = null

    private var acmpca: Output<String>? = null

    private var amg: Output<String>? = null

    private var amp: Output<String>? = null

    private var amplify: Output<String>? = null

    private var apigateway: Output<String>? = null

    private var apigatewayv2: Output<String>? = null

    private var appautoscaling: Output<String>? = null

    private var appconfig: Output<String>? = null

    private var appfabric: Output<String>? = null

    private var appflow: Output<String>? = null

    private var appintegrations: Output<String>? = null

    private var appintegrationsservice: Output<String>? = null

    private var applicationautoscaling: Output<String>? = null

    private var applicationinsights: Output<String>? = null

    private var appmesh: Output<String>? = null

    private var apprunner: Output<String>? = null

    private var appstream: Output<String>? = null

    private var appsync: Output<String>? = null

    private var athena: Output<String>? = null

    private var auditmanager: Output<String>? = null

    private var autoscaling: Output<String>? = null

    private var autoscalingplans: Output<String>? = null

    private var backup: Output<String>? = null

    private var batch: Output<String>? = null

    private var beanstalk: Output<String>? = null

    private var bedrock: Output<String>? = null

    private var budgets: Output<String>? = null

    private var ce: Output<String>? = null

    private var chime: Output<String>? = null

    private var chimesdkmediapipelines: Output<String>? = null

    private var chimesdkvoice: Output<String>? = null

    private var cleanrooms: Output<String>? = null

    private var cloud9: Output<String>? = null

    private var cloudcontrol: Output<String>? = null

    private var cloudcontrolapi: Output<String>? = null

    private var cloudformation: Output<String>? = null

    private var cloudfront: Output<String>? = null

    private var cloudhsm: Output<String>? = null

    private var cloudhsmv2: Output<String>? = null

    private var cloudsearch: Output<String>? = null

    private var cloudtrail: Output<String>? = null

    private var cloudwatch: Output<String>? = null

    private var cloudwatchevents: Output<String>? = null

    private var cloudwatchevidently: Output<String>? = null

    private var cloudwatchlog: Output<String>? = null

    private var cloudwatchlogs: Output<String>? = null

    private var cloudwatchobservabilityaccessmanager: Output<String>? = null

    private var cloudwatchrum: Output<String>? = null

    private var codeartifact: Output<String>? = null

    private var codebuild: Output<String>? = null

    private var codecatalyst: Output<String>? = null

    private var codecommit: Output<String>? = null

    private var codedeploy: Output<String>? = null

    private var codeguruprofiler: Output<String>? = null

    private var codegurureviewer: Output<String>? = null

    private var codepipeline: Output<String>? = null

    private var codestarconnections: Output<String>? = null

    private var codestarnotifications: Output<String>? = null

    private var cognitoidentity: Output<String>? = null

    private var cognitoidentityprovider: Output<String>? = null

    private var cognitoidp: Output<String>? = null

    private var comprehend: Output<String>? = null

    private var computeoptimizer: Output<String>? = null

    private var config: Output<String>? = null

    private var configservice: Output<String>? = null

    private var connect: Output<String>? = null

    private var connectcases: Output<String>? = null

    private var controltower: Output<String>? = null

    private var costandusagereportservice: Output<String>? = null

    private var costexplorer: Output<String>? = null

    private var cur: Output<String>? = null

    private var customerprofiles: Output<String>? = null

    private var databasemigration: Output<String>? = null

    private var databasemigrationservice: Output<String>? = null

    private var dataexchange: Output<String>? = null

    private var datapipeline: Output<String>? = null

    private var datasync: Output<String>? = null

    private var dax: Output<String>? = null

    private var deploy: Output<String>? = null

    private var detective: Output<String>? = null

    private var devicefarm: Output<String>? = null

    private var directconnect: Output<String>? = null

    private var directoryservice: Output<String>? = null

    private var dlm: Output<String>? = null

    private var dms: Output<String>? = null

    private var docdb: Output<String>? = null

    private var docdbelastic: Output<String>? = null

    private var ds: Output<String>? = null

    private var dynamodb: Output<String>? = null

    private var ec2: Output<String>? = null

    private var ecr: Output<String>? = null

    private var ecrpublic: Output<String>? = null

    private var ecs: Output<String>? = null

    private var efs: Output<String>? = null

    private var eks: Output<String>? = null

    private var elasticache: Output<String>? = null

    private var elasticbeanstalk: Output<String>? = null

    private var elasticloadbalancing: Output<String>? = null

    private var elasticloadbalancingv2: Output<String>? = null

    private var elasticsearch: Output<String>? = null

    private var elasticsearchservice: Output<String>? = null

    private var elastictranscoder: Output<String>? = null

    private var elb: Output<String>? = null

    private var elbv2: Output<String>? = null

    private var emr: Output<String>? = null

    private var emrcontainers: Output<String>? = null

    private var emrserverless: Output<String>? = null

    private var es: Output<String>? = null

    private var eventbridge: Output<String>? = null

    private var events: Output<String>? = null

    private var evidently: Output<String>? = null

    private var finspace: Output<String>? = null

    private var firehose: Output<String>? = null

    private var fis: Output<String>? = null

    private var fms: Output<String>? = null

    private var fsx: Output<String>? = null

    private var gamelift: Output<String>? = null

    private var glacier: Output<String>? = null

    private var globalaccelerator: Output<String>? = null

    private var glue: Output<String>? = null

    private var grafana: Output<String>? = null

    private var greengrass: Output<String>? = null

    private var guardduty: Output<String>? = null

    private var healthlake: Output<String>? = null

    private var iam: Output<String>? = null

    private var identitystore: Output<String>? = null

    private var imagebuilder: Output<String>? = null

    private var inspector: Output<String>? = null

    private var inspector2: Output<String>? = null

    private var inspectorv2: Output<String>? = null

    private var internetmonitor: Output<String>? = null

    private var iot: Output<String>? = null

    private var iotanalytics: Output<String>? = null

    private var iotevents: Output<String>? = null

    private var ivs: Output<String>? = null

    private var ivschat: Output<String>? = null

    private var kafka: Output<String>? = null

    private var kafkaconnect: Output<String>? = null

    private var kendra: Output<String>? = null

    private var keyspaces: Output<String>? = null

    private var kinesis: Output<String>? = null

    private var kinesisanalytics: Output<String>? = null

    private var kinesisanalyticsv2: Output<String>? = null

    private var kinesisvideo: Output<String>? = null

    private var kms: Output<String>? = null

    private var lakeformation: Output<String>? = null

    private var lambda: Output<String>? = null

    private var lex: Output<String>? = null

    private var lexmodelbuilding: Output<String>? = null

    private var lexmodelbuildingservice: Output<String>? = null

    private var lexmodels: Output<String>? = null

    private var lexmodelsv2: Output<String>? = null

    private var lexv2models: Output<String>? = null

    private var licensemanager: Output<String>? = null

    private var lightsail: Output<String>? = null

    private var location: Output<String>? = null

    private var locationservice: Output<String>? = null

    private var logs: Output<String>? = null

    private var macie2: Output<String>? = null

    private var managedgrafana: Output<String>? = null

    private var mediaconnect: Output<String>? = null

    private var mediaconvert: Output<String>? = null

    private var medialive: Output<String>? = null

    private var mediapackage: Output<String>? = null

    private var mediapackagev2: Output<String>? = null

    private var mediastore: Output<String>? = null

    private var memorydb: Output<String>? = null

    private var mq: Output<String>? = null

    private var msk: Output<String>? = null

    private var mwaa: Output<String>? = null

    private var neptune: Output<String>? = null

    private var networkfirewall: Output<String>? = null

    private var networkmanager: Output<String>? = null

    private var oam: Output<String>? = null

    private var opensearch: Output<String>? = null

    private var opensearchingestion: Output<String>? = null

    private var opensearchserverless: Output<String>? = null

    private var opensearchservice: Output<String>? = null

    private var opsworks: Output<String>? = null

    private var organizations: Output<String>? = null

    private var osis: Output<String>? = null

    private var outposts: Output<String>? = null

    private var pinpoint: Output<String>? = null

    private var pipes: Output<String>? = null

    private var pricing: Output<String>? = null

    private var prometheus: Output<String>? = null

    private var prometheusservice: Output<String>? = null

    private var qldb: Output<String>? = null

    private var quicksight: Output<String>? = null

    private var ram: Output<String>? = null

    private var rbin: Output<String>? = null

    private var rds: Output<String>? = null

    private var recyclebin: Output<String>? = null

    private var redshift: Output<String>? = null

    private var redshiftdata: Output<String>? = null

    private var redshiftdataapiservice: Output<String>? = null

    private var redshiftserverless: Output<String>? = null

    private var resourceexplorer2: Output<String>? = null

    private var resourcegroups: Output<String>? = null

    private var resourcegroupstagging: Output<String>? = null

    private var resourcegroupstaggingapi: Output<String>? = null

    private var rolesanywhere: Output<String>? = null

    private var route53: Output<String>? = null

    private var route53domains: Output<String>? = null

    private var route53recoverycontrolconfig: Output<String>? = null

    private var route53recoveryreadiness: Output<String>? = null

    private var route53resolver: Output<String>? = null

    private var rum: Output<String>? = null

    private var s3: Output<String>? = null

    private var s3api: Output<String>? = null

    private var s3control: Output<String>? = null

    private var s3outposts: Output<String>? = null

    private var sagemaker: Output<String>? = null

    private var scheduler: Output<String>? = null

    private var schemas: Output<String>? = null

    private var sdb: Output<String>? = null

    private var secretsmanager: Output<String>? = null

    private var securityhub: Output<String>? = null

    private var securitylake: Output<String>? = null

    private var serverlessapplicationrepository: Output<String>? = null

    private var serverlessapprepo: Output<String>? = null

    private var serverlessrepo: Output<String>? = null

    private var servicecatalog: Output<String>? = null

    private var servicediscovery: Output<String>? = null

    private var servicequotas: Output<String>? = null

    private var ses: Output<String>? = null

    private var sesv2: Output<String>? = null

    private var sfn: Output<String>? = null

    private var shield: Output<String>? = null

    private var signer: Output<String>? = null

    private var simpledb: Output<String>? = null

    private var sns: Output<String>? = null

    private var sqs: Output<String>? = null

    private var ssm: Output<String>? = null

    private var ssmcontacts: Output<String>? = null

    private var ssmincidents: Output<String>? = null

    private var sso: Output<String>? = null

    private var ssoadmin: Output<String>? = null

    private var stepfunctions: Output<String>? = null

    private var storagegateway: Output<String>? = null

    private var sts: Output<String>? = null

    private var swf: Output<String>? = null

    private var synthetics: Output<String>? = null

    private var timestreamwrite: Output<String>? = null

    private var transcribe: Output<String>? = null

    private var transcribeservice: Output<String>? = null

    private var transfer: Output<String>? = null

    private var verifiedpermissions: Output<String>? = null

    private var vpclattice: Output<String>? = null

    private var waf: Output<String>? = null

    private var wafregional: Output<String>? = null

    private var wafv2: Output<String>? = null

    private var worklink: Output<String>? = null

    private var workspaces: Output<String>? = null

    private var xray: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("websncsmlfrhuful")
    public suspend fun accessanalyzer(`value`: Output<String>) {
        this.accessanalyzer = value
    }

    /**
     * @param value
     */
    @JvmName("bshobabwtqfhpqmk")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value
     */
    @JvmName("goqacnrwjbxdppku")
    public suspend fun acm(`value`: Output<String>) {
        this.acm = value
    }

    /**
     * @param value
     */
    @JvmName("oeoqdfvruuocowua")
    public suspend fun acmpca(`value`: Output<String>) {
        this.acmpca = value
    }

    /**
     * @param value
     */
    @JvmName("drgiitewuaavlocq")
    public suspend fun amg(`value`: Output<String>) {
        this.amg = value
    }

    /**
     * @param value
     */
    @JvmName("vswciyoqwwsiuhrl")
    public suspend fun amp(`value`: Output<String>) {
        this.amp = value
    }

    /**
     * @param value
     */
    @JvmName("qhufhnmjjbdgteyb")
    public suspend fun amplify(`value`: Output<String>) {
        this.amplify = value
    }

    /**
     * @param value
     */
    @JvmName("boenscwwrjypxvxb")
    public suspend fun apigateway(`value`: Output<String>) {
        this.apigateway = value
    }

    /**
     * @param value
     */
    @JvmName("iupllgsauknhrany")
    public suspend fun apigatewayv2(`value`: Output<String>) {
        this.apigatewayv2 = value
    }

    /**
     * @param value
     */
    @JvmName("jekoagurrtwoivcv")
    public suspend fun appautoscaling(`value`: Output<String>) {
        this.appautoscaling = value
    }

    /**
     * @param value
     */
    @JvmName("shjbbmdnjwsvtqnb")
    public suspend fun appconfig(`value`: Output<String>) {
        this.appconfig = value
    }

    /**
     * @param value
     */
    @JvmName("xrqmimiudoiuxbxi")
    public suspend fun appfabric(`value`: Output<String>) {
        this.appfabric = value
    }

    /**
     * @param value
     */
    @JvmName("baularbltshexxoc")
    public suspend fun appflow(`value`: Output<String>) {
        this.appflow = value
    }

    /**
     * @param value
     */
    @JvmName("sceiahxvodssmlqn")
    public suspend fun appintegrations(`value`: Output<String>) {
        this.appintegrations = value
    }

    /**
     * @param value
     */
    @JvmName("krnperhfbfetnylf")
    public suspend fun appintegrationsservice(`value`: Output<String>) {
        this.appintegrationsservice = value
    }

    /**
     * @param value
     */
    @JvmName("ufolpeeauwbfhdmw")
    public suspend fun applicationautoscaling(`value`: Output<String>) {
        this.applicationautoscaling = value
    }

    /**
     * @param value
     */
    @JvmName("satwclsxiplbgkxv")
    public suspend fun applicationinsights(`value`: Output<String>) {
        this.applicationinsights = value
    }

    /**
     * @param value
     */
    @JvmName("tshxrwtvloyoypby")
    public suspend fun appmesh(`value`: Output<String>) {
        this.appmesh = value
    }

    /**
     * @param value
     */
    @JvmName("bdtivdrxcjmsgrib")
    public suspend fun apprunner(`value`: Output<String>) {
        this.apprunner = value
    }

    /**
     * @param value
     */
    @JvmName("suudfumegomioclm")
    public suspend fun appstream(`value`: Output<String>) {
        this.appstream = value
    }

    /**
     * @param value
     */
    @JvmName("mqcfivmasvsoagog")
    public suspend fun appsync(`value`: Output<String>) {
        this.appsync = value
    }

    /**
     * @param value
     */
    @JvmName("obicuxuxofdaqjeu")
    public suspend fun athena(`value`: Output<String>) {
        this.athena = value
    }

    /**
     * @param value
     */
    @JvmName("vmpnnevlbbbrljop")
    public suspend fun auditmanager(`value`: Output<String>) {
        this.auditmanager = value
    }

    /**
     * @param value
     */
    @JvmName("sobwatysauqfveep")
    public suspend fun autoscaling(`value`: Output<String>) {
        this.autoscaling = value
    }

    /**
     * @param value
     */
    @JvmName("enwvlchynlwjkogp")
    public suspend fun autoscalingplans(`value`: Output<String>) {
        this.autoscalingplans = value
    }

    /**
     * @param value
     */
    @JvmName("clopnfpysgjqfkmx")
    public suspend fun backup(`value`: Output<String>) {
        this.backup = value
    }

    /**
     * @param value
     */
    @JvmName("imkuklpisluejeqf")
    public suspend fun batch(`value`: Output<String>) {
        this.batch = value
    }

    /**
     * @param value
     */
    @JvmName("nfgfhrrvgpnljcda")
    public suspend fun beanstalk(`value`: Output<String>) {
        this.beanstalk = value
    }

    /**
     * @param value
     */
    @JvmName("irdjmvudvmwerxns")
    public suspend fun bedrock(`value`: Output<String>) {
        this.bedrock = value
    }

    /**
     * @param value
     */
    @JvmName("qlttaqjrsyvcswph")
    public suspend fun budgets(`value`: Output<String>) {
        this.budgets = value
    }

    /**
     * @param value
     */
    @JvmName("ddpbkidqkhcvgdvu")
    public suspend fun ce(`value`: Output<String>) {
        this.ce = value
    }

    /**
     * @param value
     */
    @JvmName("frockbhdhkrqivgj")
    public suspend fun chime(`value`: Output<String>) {
        this.chime = value
    }

    /**
     * @param value
     */
    @JvmName("ojijccovtmrjaigg")
    public suspend fun chimesdkmediapipelines(`value`: Output<String>) {
        this.chimesdkmediapipelines = value
    }

    /**
     * @param value
     */
    @JvmName("wxhtwtnacqcwrwsr")
    public suspend fun chimesdkvoice(`value`: Output<String>) {
        this.chimesdkvoice = value
    }

    /**
     * @param value
     */
    @JvmName("nmfmabfkrhtnvnqp")
    public suspend fun cleanrooms(`value`: Output<String>) {
        this.cleanrooms = value
    }

    /**
     * @param value
     */
    @JvmName("xnouprqkvkvvbdkf")
    public suspend fun cloud9(`value`: Output<String>) {
        this.cloud9 = value
    }

    /**
     * @param value
     */
    @JvmName("wmftqlbkjsefefpm")
    public suspend fun cloudcontrol(`value`: Output<String>) {
        this.cloudcontrol = value
    }

    /**
     * @param value
     */
    @JvmName("puyxnyxwrhqwndip")
    public suspend fun cloudcontrolapi(`value`: Output<String>) {
        this.cloudcontrolapi = value
    }

    /**
     * @param value
     */
    @JvmName("vtiwsyhplnktxtoa")
    public suspend fun cloudformation(`value`: Output<String>) {
        this.cloudformation = value
    }

    /**
     * @param value
     */
    @JvmName("cmnimhsycbdxgtpq")
    public suspend fun cloudfront(`value`: Output<String>) {
        this.cloudfront = value
    }

    /**
     * @param value
     */
    @JvmName("vbrkgmscjagapkwk")
    public suspend fun cloudhsm(`value`: Output<String>) {
        this.cloudhsm = value
    }

    /**
     * @param value
     */
    @JvmName("byfupuiiivyqximh")
    public suspend fun cloudhsmv2(`value`: Output<String>) {
        this.cloudhsmv2 = value
    }

    /**
     * @param value
     */
    @JvmName("xlrehxitlbgfdhnr")
    public suspend fun cloudsearch(`value`: Output<String>) {
        this.cloudsearch = value
    }

    /**
     * @param value
     */
    @JvmName("smdmkhffmuqixeot")
    public suspend fun cloudtrail(`value`: Output<String>) {
        this.cloudtrail = value
    }

    /**
     * @param value
     */
    @JvmName("oqyjecokgpdtgcyj")
    public suspend fun cloudwatch(`value`: Output<String>) {
        this.cloudwatch = value
    }

    /**
     * @param value
     */
    @JvmName("bejorebiyqdyxdoa")
    public suspend fun cloudwatchevents(`value`: Output<String>) {
        this.cloudwatchevents = value
    }

    /**
     * @param value
     */
    @JvmName("wmcadfnfrisglrmr")
    public suspend fun cloudwatchevidently(`value`: Output<String>) {
        this.cloudwatchevidently = value
    }

    /**
     * @param value
     */
    @JvmName("xpnubsypvvwvfnqm")
    public suspend fun cloudwatchlog(`value`: Output<String>) {
        this.cloudwatchlog = value
    }

    /**
     * @param value
     */
    @JvmName("sygguvutevqyavep")
    public suspend fun cloudwatchlogs(`value`: Output<String>) {
        this.cloudwatchlogs = value
    }

    /**
     * @param value
     */
    @JvmName("aaognqdujpcconys")
    public suspend fun cloudwatchobservabilityaccessmanager(`value`: Output<String>) {
        this.cloudwatchobservabilityaccessmanager = value
    }

    /**
     * @param value
     */
    @JvmName("fhkxcylodeuqwyqh")
    public suspend fun cloudwatchrum(`value`: Output<String>) {
        this.cloudwatchrum = value
    }

    /**
     * @param value
     */
    @JvmName("ukughcyuqrnntrep")
    public suspend fun codeartifact(`value`: Output<String>) {
        this.codeartifact = value
    }

    /**
     * @param value
     */
    @JvmName("plabkoklxiwgkryn")
    public suspend fun codebuild(`value`: Output<String>) {
        this.codebuild = value
    }

    /**
     * @param value
     */
    @JvmName("sylqbefkfgqmaxvk")
    public suspend fun codecatalyst(`value`: Output<String>) {
        this.codecatalyst = value
    }

    /**
     * @param value
     */
    @JvmName("eehcwjmetkhtujqx")
    public suspend fun codecommit(`value`: Output<String>) {
        this.codecommit = value
    }

    /**
     * @param value
     */
    @JvmName("tkbxuciholbvnpkm")
    public suspend fun codedeploy(`value`: Output<String>) {
        this.codedeploy = value
    }

    /**
     * @param value
     */
    @JvmName("domlpixjngpavwbs")
    public suspend fun codeguruprofiler(`value`: Output<String>) {
        this.codeguruprofiler = value
    }

    /**
     * @param value
     */
    @JvmName("gtrwuhtkeaegarav")
    public suspend fun codegurureviewer(`value`: Output<String>) {
        this.codegurureviewer = value
    }

    /**
     * @param value
     */
    @JvmName("iwlavrkubdqowqro")
    public suspend fun codepipeline(`value`: Output<String>) {
        this.codepipeline = value
    }

    /**
     * @param value
     */
    @JvmName("xiggjpncnglhsahh")
    public suspend fun codestarconnections(`value`: Output<String>) {
        this.codestarconnections = value
    }

    /**
     * @param value
     */
    @JvmName("vberegjjyxnvumkn")
    public suspend fun codestarnotifications(`value`: Output<String>) {
        this.codestarnotifications = value
    }

    /**
     * @param value
     */
    @JvmName("wnvhvlkwgcmlydck")
    public suspend fun cognitoidentity(`value`: Output<String>) {
        this.cognitoidentity = value
    }

    /**
     * @param value
     */
    @JvmName("swycpftxedpeujmv")
    public suspend fun cognitoidentityprovider(`value`: Output<String>) {
        this.cognitoidentityprovider = value
    }

    /**
     * @param value
     */
    @JvmName("ufjhrifqvhseeear")
    public suspend fun cognitoidp(`value`: Output<String>) {
        this.cognitoidp = value
    }

    /**
     * @param value
     */
    @JvmName("emcodijuxmrwgupr")
    public suspend fun comprehend(`value`: Output<String>) {
        this.comprehend = value
    }

    /**
     * @param value
     */
    @JvmName("nerldavbvqvgquox")
    public suspend fun computeoptimizer(`value`: Output<String>) {
        this.computeoptimizer = value
    }

    /**
     * @param value
     */
    @JvmName("pxcbiqwudruogour")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value
     */
    @JvmName("prkgdwotoiuqbyly")
    public suspend fun configservice(`value`: Output<String>) {
        this.configservice = value
    }

    /**
     * @param value
     */
    @JvmName("gdxbvhhjjsqglssi")
    public suspend fun connect(`value`: Output<String>) {
        this.connect = value
    }

    /**
     * @param value
     */
    @JvmName("yiagqkvqqxxbhvhl")
    public suspend fun connectcases(`value`: Output<String>) {
        this.connectcases = value
    }

    /**
     * @param value
     */
    @JvmName("lewvfubmsehljujf")
    public suspend fun controltower(`value`: Output<String>) {
        this.controltower = value
    }

    /**
     * @param value
     */
    @JvmName("teygrfcewxfeoaxr")
    public suspend fun costandusagereportservice(`value`: Output<String>) {
        this.costandusagereportservice = value
    }

    /**
     * @param value
     */
    @JvmName("wqhkvgcnrfwtgfyc")
    public suspend fun costexplorer(`value`: Output<String>) {
        this.costexplorer = value
    }

    /**
     * @param value
     */
    @JvmName("lffpdxwcirecyrdx")
    public suspend fun cur(`value`: Output<String>) {
        this.cur = value
    }

    /**
     * @param value
     */
    @JvmName("qfosqkelyfixgtlg")
    public suspend fun customerprofiles(`value`: Output<String>) {
        this.customerprofiles = value
    }

    /**
     * @param value
     */
    @JvmName("lrcmmfqxrthctfkn")
    public suspend fun databasemigration(`value`: Output<String>) {
        this.databasemigration = value
    }

    /**
     * @param value
     */
    @JvmName("kxjvodnnuguhoxww")
    public suspend fun databasemigrationservice(`value`: Output<String>) {
        this.databasemigrationservice = value
    }

    /**
     * @param value
     */
    @JvmName("bevwrdnrdfpydusd")
    public suspend fun dataexchange(`value`: Output<String>) {
        this.dataexchange = value
    }

    /**
     * @param value
     */
    @JvmName("dyxmwrwmfvuwicfs")
    public suspend fun datapipeline(`value`: Output<String>) {
        this.datapipeline = value
    }

    /**
     * @param value
     */
    @JvmName("ixhtkaqnlkralwjr")
    public suspend fun datasync(`value`: Output<String>) {
        this.datasync = value
    }

    /**
     * @param value
     */
    @JvmName("blebykstwmbhtjdg")
    public suspend fun dax(`value`: Output<String>) {
        this.dax = value
    }

    /**
     * @param value
     */
    @JvmName("jdkaaigtrlntftjl")
    public suspend fun deploy(`value`: Output<String>) {
        this.deploy = value
    }

    /**
     * @param value
     */
    @JvmName("lxcdybiphpwbbkxk")
    public suspend fun detective(`value`: Output<String>) {
        this.detective = value
    }

    /**
     * @param value
     */
    @JvmName("dcxwviffpfbysebs")
    public suspend fun devicefarm(`value`: Output<String>) {
        this.devicefarm = value
    }

    /**
     * @param value
     */
    @JvmName("msobuldlhwebjwiw")
    public suspend fun directconnect(`value`: Output<String>) {
        this.directconnect = value
    }

    /**
     * @param value
     */
    @JvmName("gpxarkuefrxslfqm")
    public suspend fun directoryservice(`value`: Output<String>) {
        this.directoryservice = value
    }

    /**
     * @param value
     */
    @JvmName("uljsatgxehijrigd")
    public suspend fun dlm(`value`: Output<String>) {
        this.dlm = value
    }

    /**
     * @param value
     */
    @JvmName("usubbghkauffkoga")
    public suspend fun dms(`value`: Output<String>) {
        this.dms = value
    }

    /**
     * @param value
     */
    @JvmName("odbysqchjmrhjtbr")
    public suspend fun docdb(`value`: Output<String>) {
        this.docdb = value
    }

    /**
     * @param value
     */
    @JvmName("rxuigbgqjccksybe")
    public suspend fun docdbelastic(`value`: Output<String>) {
        this.docdbelastic = value
    }

    /**
     * @param value
     */
    @JvmName("nfkwutpjtdvhcnpj")
    public suspend fun ds(`value`: Output<String>) {
        this.ds = value
    }

    /**
     * @param value
     */
    @JvmName("wnvmdhrgjxnaarkq")
    public suspend fun dynamodb(`value`: Output<String>) {
        this.dynamodb = value
    }

    /**
     * @param value
     */
    @JvmName("jqdtxmfpltppeqnm")
    public suspend fun ec2(`value`: Output<String>) {
        this.ec2 = value
    }

    /**
     * @param value
     */
    @JvmName("dpvgmbaqcevaruuf")
    public suspend fun ecr(`value`: Output<String>) {
        this.ecr = value
    }

    /**
     * @param value
     */
    @JvmName("kaytbmmggqyfnpvo")
    public suspend fun ecrpublic(`value`: Output<String>) {
        this.ecrpublic = value
    }

    /**
     * @param value
     */
    @JvmName("ragcfwdyxhxiqyda")
    public suspend fun ecs(`value`: Output<String>) {
        this.ecs = value
    }

    /**
     * @param value
     */
    @JvmName("frvyidlbbxvltgpq")
    public suspend fun efs(`value`: Output<String>) {
        this.efs = value
    }

    /**
     * @param value
     */
    @JvmName("wtwklwtwcncgccas")
    public suspend fun eks(`value`: Output<String>) {
        this.eks = value
    }

    /**
     * @param value
     */
    @JvmName("gplsxrfgcwbmsqdg")
    public suspend fun elasticache(`value`: Output<String>) {
        this.elasticache = value
    }

    /**
     * @param value
     */
    @JvmName("wvbcbnbimtftjqso")
    public suspend fun elasticbeanstalk(`value`: Output<String>) {
        this.elasticbeanstalk = value
    }

    /**
     * @param value
     */
    @JvmName("uwjovxjjoprhvtci")
    public suspend fun elasticloadbalancing(`value`: Output<String>) {
        this.elasticloadbalancing = value
    }

    /**
     * @param value
     */
    @JvmName("dwoehofuoiijwcxv")
    public suspend fun elasticloadbalancingv2(`value`: Output<String>) {
        this.elasticloadbalancingv2 = value
    }

    /**
     * @param value
     */
    @JvmName("dlbtqfkqdeaeuqmq")
    public suspend fun elasticsearch(`value`: Output<String>) {
        this.elasticsearch = value
    }

    /**
     * @param value
     */
    @JvmName("nhsivyduvkjqnypv")
    public suspend fun elasticsearchservice(`value`: Output<String>) {
        this.elasticsearchservice = value
    }

    /**
     * @param value
     */
    @JvmName("uvvanchsnpfhetax")
    public suspend fun elastictranscoder(`value`: Output<String>) {
        this.elastictranscoder = value
    }

    /**
     * @param value
     */
    @JvmName("pksjnkorbdqjsbnn")
    public suspend fun elb(`value`: Output<String>) {
        this.elb = value
    }

    /**
     * @param value
     */
    @JvmName("spgpytcocppkxxmc")
    public suspend fun elbv2(`value`: Output<String>) {
        this.elbv2 = value
    }

    /**
     * @param value
     */
    @JvmName("jthbcscdqpymhnse")
    public suspend fun emr(`value`: Output<String>) {
        this.emr = value
    }

    /**
     * @param value
     */
    @JvmName("ukgjssrjepmpylgd")
    public suspend fun emrcontainers(`value`: Output<String>) {
        this.emrcontainers = value
    }

    /**
     * @param value
     */
    @JvmName("yqgbpbhnglbjlhys")
    public suspend fun emrserverless(`value`: Output<String>) {
        this.emrserverless = value
    }

    /**
     * @param value
     */
    @JvmName("opetbpgjaxviufmi")
    public suspend fun es(`value`: Output<String>) {
        this.es = value
    }

    /**
     * @param value
     */
    @JvmName("sgjmqpowdxqxfumb")
    public suspend fun eventbridge(`value`: Output<String>) {
        this.eventbridge = value
    }

    /**
     * @param value
     */
    @JvmName("oohoekxwdikrveai")
    public suspend fun events(`value`: Output<String>) {
        this.events = value
    }

    /**
     * @param value
     */
    @JvmName("kbtcathrrlbfqopd")
    public suspend fun evidently(`value`: Output<String>) {
        this.evidently = value
    }

    /**
     * @param value
     */
    @JvmName("sullguqmcfeelktw")
    public suspend fun finspace(`value`: Output<String>) {
        this.finspace = value
    }

    /**
     * @param value
     */
    @JvmName("qdpjjcpueudjfuvn")
    public suspend fun firehose(`value`: Output<String>) {
        this.firehose = value
    }

    /**
     * @param value
     */
    @JvmName("vedjmxubtimovdpk")
    public suspend fun fis(`value`: Output<String>) {
        this.fis = value
    }

    /**
     * @param value
     */
    @JvmName("hbjffmohbffxkdrc")
    public suspend fun fms(`value`: Output<String>) {
        this.fms = value
    }

    /**
     * @param value
     */
    @JvmName("gnuuxapojjcarlss")
    public suspend fun fsx(`value`: Output<String>) {
        this.fsx = value
    }

    /**
     * @param value
     */
    @JvmName("qvriohyogiuhiyha")
    public suspend fun gamelift(`value`: Output<String>) {
        this.gamelift = value
    }

    /**
     * @param value
     */
    @JvmName("xuvfpcrymxuapmii")
    public suspend fun glacier(`value`: Output<String>) {
        this.glacier = value
    }

    /**
     * @param value
     */
    @JvmName("gyrdptqbworpiqnr")
    public suspend fun globalaccelerator(`value`: Output<String>) {
        this.globalaccelerator = value
    }

    /**
     * @param value
     */
    @JvmName("kkaetlhjigioojaq")
    public suspend fun glue(`value`: Output<String>) {
        this.glue = value
    }

    /**
     * @param value
     */
    @JvmName("fqmlntpuqcwnfmpe")
    public suspend fun grafana(`value`: Output<String>) {
        this.grafana = value
    }

    /**
     * @param value
     */
    @JvmName("gecvpclusavvsumv")
    public suspend fun greengrass(`value`: Output<String>) {
        this.greengrass = value
    }

    /**
     * @param value
     */
    @JvmName("omnkdriecpxjgekt")
    public suspend fun guardduty(`value`: Output<String>) {
        this.guardduty = value
    }

    /**
     * @param value
     */
    @JvmName("kyftljgtjopjiues")
    public suspend fun healthlake(`value`: Output<String>) {
        this.healthlake = value
    }

    /**
     * @param value
     */
    @JvmName("dlsyagvqwllckusx")
    public suspend fun iam(`value`: Output<String>) {
        this.iam = value
    }

    /**
     * @param value
     */
    @JvmName("yqjwmvnjwbxdglrq")
    public suspend fun identitystore(`value`: Output<String>) {
        this.identitystore = value
    }

    /**
     * @param value
     */
    @JvmName("dsxwxrlomrxrwtrw")
    public suspend fun imagebuilder(`value`: Output<String>) {
        this.imagebuilder = value
    }

    /**
     * @param value
     */
    @JvmName("xgeowmwbfbdahwbn")
    public suspend fun inspector(`value`: Output<String>) {
        this.inspector = value
    }

    /**
     * @param value
     */
    @JvmName("kvjugofgsgfedtqk")
    public suspend fun inspector2(`value`: Output<String>) {
        this.inspector2 = value
    }

    /**
     * @param value
     */
    @JvmName("qnpqiherepnvyhpq")
    public suspend fun inspectorv2(`value`: Output<String>) {
        this.inspectorv2 = value
    }

    /**
     * @param value
     */
    @JvmName("ofrnxbbvigfdbccd")
    public suspend fun internetmonitor(`value`: Output<String>) {
        this.internetmonitor = value
    }

    /**
     * @param value
     */
    @JvmName("miwgdscxyxhnowqu")
    public suspend fun iot(`value`: Output<String>) {
        this.iot = value
    }

    /**
     * @param value
     */
    @JvmName("vharugfjpxqwidag")
    public suspend fun iotanalytics(`value`: Output<String>) {
        this.iotanalytics = value
    }

    /**
     * @param value
     */
    @JvmName("wqhlfhqcdswjjpti")
    public suspend fun iotevents(`value`: Output<String>) {
        this.iotevents = value
    }

    /**
     * @param value
     */
    @JvmName("dpsjnyqbupoypqbm")
    public suspend fun ivs(`value`: Output<String>) {
        this.ivs = value
    }

    /**
     * @param value
     */
    @JvmName("ctnkijbsbdhwjyas")
    public suspend fun ivschat(`value`: Output<String>) {
        this.ivschat = value
    }

    /**
     * @param value
     */
    @JvmName("nwbessvkoxkrqoyp")
    public suspend fun kafka(`value`: Output<String>) {
        this.kafka = value
    }

    /**
     * @param value
     */
    @JvmName("xwqrlecpufexmymr")
    public suspend fun kafkaconnect(`value`: Output<String>) {
        this.kafkaconnect = value
    }

    /**
     * @param value
     */
    @JvmName("gbthcduhfbeljovt")
    public suspend fun kendra(`value`: Output<String>) {
        this.kendra = value
    }

    /**
     * @param value
     */
    @JvmName("oatpabftihprembs")
    public suspend fun keyspaces(`value`: Output<String>) {
        this.keyspaces = value
    }

    /**
     * @param value
     */
    @JvmName("fglvjsmglfuqvgcg")
    public suspend fun kinesis(`value`: Output<String>) {
        this.kinesis = value
    }

    /**
     * @param value
     */
    @JvmName("lovdrecxhnmginfp")
    public suspend fun kinesisanalytics(`value`: Output<String>) {
        this.kinesisanalytics = value
    }

    /**
     * @param value
     */
    @JvmName("qokqmnrlgftfwafr")
    public suspend fun kinesisanalyticsv2(`value`: Output<String>) {
        this.kinesisanalyticsv2 = value
    }

    /**
     * @param value
     */
    @JvmName("yrnmdkjmutasopml")
    public suspend fun kinesisvideo(`value`: Output<String>) {
        this.kinesisvideo = value
    }

    /**
     * @param value
     */
    @JvmName("uikhnttpyvdgunmb")
    public suspend fun kms(`value`: Output<String>) {
        this.kms = value
    }

    /**
     * @param value
     */
    @JvmName("alljxpsxqmkhoqno")
    public suspend fun lakeformation(`value`: Output<String>) {
        this.lakeformation = value
    }

    /**
     * @param value
     */
    @JvmName("gnfeclsdqkdacfol")
    public suspend fun lambda(`value`: Output<String>) {
        this.lambda = value
    }

    /**
     * @param value
     */
    @JvmName("qnwnagciormomqbl")
    public suspend fun lex(`value`: Output<String>) {
        this.lex = value
    }

    /**
     * @param value
     */
    @JvmName("nncqndtohsomcveb")
    public suspend fun lexmodelbuilding(`value`: Output<String>) {
        this.lexmodelbuilding = value
    }

    /**
     * @param value
     */
    @JvmName("xlkwdpwcdfxooppo")
    public suspend fun lexmodelbuildingservice(`value`: Output<String>) {
        this.lexmodelbuildingservice = value
    }

    /**
     * @param value
     */
    @JvmName("ufemkuqfcdkjmpsp")
    public suspend fun lexmodels(`value`: Output<String>) {
        this.lexmodels = value
    }

    /**
     * @param value
     */
    @JvmName("bpaqflskgplkfxbl")
    public suspend fun lexmodelsv2(`value`: Output<String>) {
        this.lexmodelsv2 = value
    }

    /**
     * @param value
     */
    @JvmName("mdodlbcvwnronkrb")
    public suspend fun lexv2models(`value`: Output<String>) {
        this.lexv2models = value
    }

    /**
     * @param value
     */
    @JvmName("nvxhrootjfrdojdf")
    public suspend fun licensemanager(`value`: Output<String>) {
        this.licensemanager = value
    }

    /**
     * @param value
     */
    @JvmName("hrbouhcuawewhkyp")
    public suspend fun lightsail(`value`: Output<String>) {
        this.lightsail = value
    }

    /**
     * @param value
     */
    @JvmName("iautfyjbrphoxvft")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("hkvxavmunkxedfsu")
    public suspend fun locationservice(`value`: Output<String>) {
        this.locationservice = value
    }

    /**
     * @param value
     */
    @JvmName("mkjeaphlljkynyin")
    public suspend fun logs(`value`: Output<String>) {
        this.logs = value
    }

    /**
     * @param value
     */
    @JvmName("aktofqguiyvqkmwm")
    public suspend fun macie2(`value`: Output<String>) {
        this.macie2 = value
    }

    /**
     * @param value
     */
    @JvmName("awrmgnkyvasbciko")
    public suspend fun managedgrafana(`value`: Output<String>) {
        this.managedgrafana = value
    }

    /**
     * @param value
     */
    @JvmName("qxlbcrxmjrukfuvx")
    public suspend fun mediaconnect(`value`: Output<String>) {
        this.mediaconnect = value
    }

    /**
     * @param value
     */
    @JvmName("bfwnwriklhistfup")
    public suspend fun mediaconvert(`value`: Output<String>) {
        this.mediaconvert = value
    }

    /**
     * @param value
     */
    @JvmName("dqdvwpumiqfaewyw")
    public suspend fun medialive(`value`: Output<String>) {
        this.medialive = value
    }

    /**
     * @param value
     */
    @JvmName("bvpjfvbcdjewhhcj")
    public suspend fun mediapackage(`value`: Output<String>) {
        this.mediapackage = value
    }

    /**
     * @param value
     */
    @JvmName("evxblopuxcqdsfuy")
    public suspend fun mediapackagev2(`value`: Output<String>) {
        this.mediapackagev2 = value
    }

    /**
     * @param value
     */
    @JvmName("ccesxjnjtotvbcby")
    public suspend fun mediastore(`value`: Output<String>) {
        this.mediastore = value
    }

    /**
     * @param value
     */
    @JvmName("uiivdkfxpmbpkyhf")
    public suspend fun memorydb(`value`: Output<String>) {
        this.memorydb = value
    }

    /**
     * @param value
     */
    @JvmName("slpgkqhmtlmxdiii")
    public suspend fun mq(`value`: Output<String>) {
        this.mq = value
    }

    /**
     * @param value
     */
    @JvmName("nuvokmxwhrhcqrnw")
    public suspend fun msk(`value`: Output<String>) {
        this.msk = value
    }

    /**
     * @param value
     */
    @JvmName("dmwcocjrmrlscsqh")
    public suspend fun mwaa(`value`: Output<String>) {
        this.mwaa = value
    }

    /**
     * @param value
     */
    @JvmName("vahikkbadtsfdeld")
    public suspend fun neptune(`value`: Output<String>) {
        this.neptune = value
    }

    /**
     * @param value
     */
    @JvmName("dkdrypdxeaejkqkq")
    public suspend fun networkfirewall(`value`: Output<String>) {
        this.networkfirewall = value
    }

    /**
     * @param value
     */
    @JvmName("vfiojgkopxjmfibb")
    public suspend fun networkmanager(`value`: Output<String>) {
        this.networkmanager = value
    }

    /**
     * @param value
     */
    @JvmName("pivxycjtpxktgqmk")
    public suspend fun oam(`value`: Output<String>) {
        this.oam = value
    }

    /**
     * @param value
     */
    @JvmName("xxqlnapmlnkoxitm")
    public suspend fun opensearch(`value`: Output<String>) {
        this.opensearch = value
    }

    /**
     * @param value
     */
    @JvmName("vrfltcndwcmkorev")
    public suspend fun opensearchingestion(`value`: Output<String>) {
        this.opensearchingestion = value
    }

    /**
     * @param value
     */
    @JvmName("vvixspqhmfseogcs")
    public suspend fun opensearchserverless(`value`: Output<String>) {
        this.opensearchserverless = value
    }

    /**
     * @param value
     */
    @JvmName("prqjvdusqifjihwm")
    public suspend fun opensearchservice(`value`: Output<String>) {
        this.opensearchservice = value
    }

    /**
     * @param value
     */
    @JvmName("hudfpkvsqajkhrtf")
    public suspend fun opsworks(`value`: Output<String>) {
        this.opsworks = value
    }

    /**
     * @param value
     */
    @JvmName("hosxvkbplwmxajnx")
    public suspend fun organizations(`value`: Output<String>) {
        this.organizations = value
    }

    /**
     * @param value
     */
    @JvmName("jaujjbspechyptoo")
    public suspend fun osis(`value`: Output<String>) {
        this.osis = value
    }

    /**
     * @param value
     */
    @JvmName("quuyyegnrcyyyruc")
    public suspend fun outposts(`value`: Output<String>) {
        this.outposts = value
    }

    /**
     * @param value
     */
    @JvmName("cvmghfnnysvtbkhq")
    public suspend fun pinpoint(`value`: Output<String>) {
        this.pinpoint = value
    }

    /**
     * @param value
     */
    @JvmName("fhptbklnsafjevdg")
    public suspend fun pipes(`value`: Output<String>) {
        this.pipes = value
    }

    /**
     * @param value
     */
    @JvmName("iwiffsjhehgbgirs")
    public suspend fun pricing(`value`: Output<String>) {
        this.pricing = value
    }

    /**
     * @param value
     */
    @JvmName("jxgjuvifistgugdo")
    public suspend fun prometheus(`value`: Output<String>) {
        this.prometheus = value
    }

    /**
     * @param value
     */
    @JvmName("felfdinmnbchjdid")
    public suspend fun prometheusservice(`value`: Output<String>) {
        this.prometheusservice = value
    }

    /**
     * @param value
     */
    @JvmName("jrsqmvgrwqgjhlgm")
    public suspend fun qldb(`value`: Output<String>) {
        this.qldb = value
    }

    /**
     * @param value
     */
    @JvmName("pagrxpfwyvpxncfl")
    public suspend fun quicksight(`value`: Output<String>) {
        this.quicksight = value
    }

    /**
     * @param value
     */
    @JvmName("kjsuccxnbqucnlgm")
    public suspend fun ram(`value`: Output<String>) {
        this.ram = value
    }

    /**
     * @param value
     */
    @JvmName("uddrexloamwelpfd")
    public suspend fun rbin(`value`: Output<String>) {
        this.rbin = value
    }

    /**
     * @param value
     */
    @JvmName("vydnpwjharaujjcc")
    public suspend fun rds(`value`: Output<String>) {
        this.rds = value
    }

    /**
     * @param value
     */
    @JvmName("auwyeacdtqhvdkrr")
    public suspend fun recyclebin(`value`: Output<String>) {
        this.recyclebin = value
    }

    /**
     * @param value
     */
    @JvmName("odecmjivyhiawpho")
    public suspend fun redshift(`value`: Output<String>) {
        this.redshift = value
    }

    /**
     * @param value
     */
    @JvmName("wojvflbcoyqsmlov")
    public suspend fun redshiftdata(`value`: Output<String>) {
        this.redshiftdata = value
    }

    /**
     * @param value
     */
    @JvmName("irlmynvjxbedrvov")
    public suspend fun redshiftdataapiservice(`value`: Output<String>) {
        this.redshiftdataapiservice = value
    }

    /**
     * @param value
     */
    @JvmName("eomhntfebcibovvw")
    public suspend fun redshiftserverless(`value`: Output<String>) {
        this.redshiftserverless = value
    }

    /**
     * @param value
     */
    @JvmName("dpmqldilyghsjful")
    public suspend fun resourceexplorer2(`value`: Output<String>) {
        this.resourceexplorer2 = value
    }

    /**
     * @param value
     */
    @JvmName("awrtnydtbeckqalo")
    public suspend fun resourcegroups(`value`: Output<String>) {
        this.resourcegroups = value
    }

    /**
     * @param value
     */
    @JvmName("bmqrduvishnsrxia")
    public suspend fun resourcegroupstagging(`value`: Output<String>) {
        this.resourcegroupstagging = value
    }

    /**
     * @param value
     */
    @JvmName("apyiapinieddppol")
    public suspend fun resourcegroupstaggingapi(`value`: Output<String>) {
        this.resourcegroupstaggingapi = value
    }

    /**
     * @param value
     */
    @JvmName("xtkmntchpprswwre")
    public suspend fun rolesanywhere(`value`: Output<String>) {
        this.rolesanywhere = value
    }

    /**
     * @param value
     */
    @JvmName("jewefyswvwwknjdf")
    public suspend fun route53(`value`: Output<String>) {
        this.route53 = value
    }

    /**
     * @param value
     */
    @JvmName("ftgkwhbuekmkpwol")
    public suspend fun route53domains(`value`: Output<String>) {
        this.route53domains = value
    }

    /**
     * @param value
     */
    @JvmName("mpqjqstylgyqntik")
    public suspend fun route53recoverycontrolconfig(`value`: Output<String>) {
        this.route53recoverycontrolconfig = value
    }

    /**
     * @param value
     */
    @JvmName("wifyakwljpcfuelt")
    public suspend fun route53recoveryreadiness(`value`: Output<String>) {
        this.route53recoveryreadiness = value
    }

    /**
     * @param value
     */
    @JvmName("nrrcqgntsgmeoagn")
    public suspend fun route53resolver(`value`: Output<String>) {
        this.route53resolver = value
    }

    /**
     * @param value
     */
    @JvmName("lyvchxippbcfdplb")
    public suspend fun rum(`value`: Output<String>) {
        this.rum = value
    }

    /**
     * @param value
     */
    @JvmName("wfxnjssittdtchyu")
    public suspend fun s3(`value`: Output<String>) {
        this.s3 = value
    }

    /**
     * @param value
     */
    @JvmName("tndfumoegpusrogt")
    public suspend fun s3api(`value`: Output<String>) {
        this.s3api = value
    }

    /**
     * @param value
     */
    @JvmName("vgbjevygurbllffj")
    public suspend fun s3control(`value`: Output<String>) {
        this.s3control = value
    }

    /**
     * @param value
     */
    @JvmName("rpexgxcnghudtsna")
    public suspend fun s3outposts(`value`: Output<String>) {
        this.s3outposts = value
    }

    /**
     * @param value
     */
    @JvmName("hxnncuxsoqqlnsom")
    public suspend fun sagemaker(`value`: Output<String>) {
        this.sagemaker = value
    }

    /**
     * @param value
     */
    @JvmName("atpllqysahodhtaj")
    public suspend fun scheduler(`value`: Output<String>) {
        this.scheduler = value
    }

    /**
     * @param value
     */
    @JvmName("giyoxpedgxhblvfa")
    public suspend fun schemas(`value`: Output<String>) {
        this.schemas = value
    }

    /**
     * @param value
     */
    @JvmName("pewniarbihrvaxsq")
    public suspend fun sdb(`value`: Output<String>) {
        this.sdb = value
    }

    /**
     * @param value
     */
    @JvmName("ryhkaryjlaxrbihy")
    public suspend fun secretsmanager(`value`: Output<String>) {
        this.secretsmanager = value
    }

    /**
     * @param value
     */
    @JvmName("farhrpcpvakuvoxl")
    public suspend fun securityhub(`value`: Output<String>) {
        this.securityhub = value
    }

    /**
     * @param value
     */
    @JvmName("qusfxpayufirfrbf")
    public suspend fun securitylake(`value`: Output<String>) {
        this.securitylake = value
    }

    /**
     * @param value
     */
    @JvmName("oibfrujbxaonlvmn")
    public suspend fun serverlessapplicationrepository(`value`: Output<String>) {
        this.serverlessapplicationrepository = value
    }

    /**
     * @param value
     */
    @JvmName("pbjdplmwgodomxek")
    public suspend fun serverlessapprepo(`value`: Output<String>) {
        this.serverlessapprepo = value
    }

    /**
     * @param value
     */
    @JvmName("omgpeeiqvmlccshw")
    public suspend fun serverlessrepo(`value`: Output<String>) {
        this.serverlessrepo = value
    }

    /**
     * @param value
     */
    @JvmName("vdnccxmktmukxwup")
    public suspend fun servicecatalog(`value`: Output<String>) {
        this.servicecatalog = value
    }

    /**
     * @param value
     */
    @JvmName("svciqfhjbvpbynhl")
    public suspend fun servicediscovery(`value`: Output<String>) {
        this.servicediscovery = value
    }

    /**
     * @param value
     */
    @JvmName("uqgthokapgulsmcq")
    public suspend fun servicequotas(`value`: Output<String>) {
        this.servicequotas = value
    }

    /**
     * @param value
     */
    @JvmName("mawtxskmvqmcxysu")
    public suspend fun ses(`value`: Output<String>) {
        this.ses = value
    }

    /**
     * @param value
     */
    @JvmName("oraxbhlwhfjkanat")
    public suspend fun sesv2(`value`: Output<String>) {
        this.sesv2 = value
    }

    /**
     * @param value
     */
    @JvmName("ikyshnpvnpdrcdbn")
    public suspend fun sfn(`value`: Output<String>) {
        this.sfn = value
    }

    /**
     * @param value
     */
    @JvmName("uflxiyjkdfyypftc")
    public suspend fun shield(`value`: Output<String>) {
        this.shield = value
    }

    /**
     * @param value
     */
    @JvmName("cugeeuqaatblpmah")
    public suspend fun signer(`value`: Output<String>) {
        this.signer = value
    }

    /**
     * @param value
     */
    @JvmName("xmaivfoxpckgutwd")
    public suspend fun simpledb(`value`: Output<String>) {
        this.simpledb = value
    }

    /**
     * @param value
     */
    @JvmName("ljucsknuftqewxtg")
    public suspend fun sns(`value`: Output<String>) {
        this.sns = value
    }

    /**
     * @param value
     */
    @JvmName("txfykuvqpdrxqmqv")
    public suspend fun sqs(`value`: Output<String>) {
        this.sqs = value
    }

    /**
     * @param value
     */
    @JvmName("jjvplyymavypibky")
    public suspend fun ssm(`value`: Output<String>) {
        this.ssm = value
    }

    /**
     * @param value
     */
    @JvmName("sovfdtojesntidkp")
    public suspend fun ssmcontacts(`value`: Output<String>) {
        this.ssmcontacts = value
    }

    /**
     * @param value
     */
    @JvmName("nscusqmfsuksseaa")
    public suspend fun ssmincidents(`value`: Output<String>) {
        this.ssmincidents = value
    }

    /**
     * @param value
     */
    @JvmName("lpefijeptmtvknrr")
    public suspend fun sso(`value`: Output<String>) {
        this.sso = value
    }

    /**
     * @param value
     */
    @JvmName("cmnumhqokmevbefx")
    public suspend fun ssoadmin(`value`: Output<String>) {
        this.ssoadmin = value
    }

    /**
     * @param value
     */
    @JvmName("ipddgmfgincjhtmj")
    public suspend fun stepfunctions(`value`: Output<String>) {
        this.stepfunctions = value
    }

    /**
     * @param value
     */
    @JvmName("tjknkouxayxatwcg")
    public suspend fun storagegateway(`value`: Output<String>) {
        this.storagegateway = value
    }

    /**
     * @param value
     */
    @JvmName("mtoncrklgrjiwerp")
    public suspend fun sts(`value`: Output<String>) {
        this.sts = value
    }

    /**
     * @param value
     */
    @JvmName("dndqfffmlwhncchm")
    public suspend fun swf(`value`: Output<String>) {
        this.swf = value
    }

    /**
     * @param value
     */
    @JvmName("kxfvypyutcaxgjov")
    public suspend fun synthetics(`value`: Output<String>) {
        this.synthetics = value
    }

    /**
     * @param value
     */
    @JvmName("qwvbxifrcwhkviit")
    public suspend fun timestreamwrite(`value`: Output<String>) {
        this.timestreamwrite = value
    }

    /**
     * @param value
     */
    @JvmName("ajnvmndlcnmwsedg")
    public suspend fun transcribe(`value`: Output<String>) {
        this.transcribe = value
    }

    /**
     * @param value
     */
    @JvmName("xgbdjdviutsomeql")
    public suspend fun transcribeservice(`value`: Output<String>) {
        this.transcribeservice = value
    }

    /**
     * @param value
     */
    @JvmName("xrvxvsuttswrdktu")
    public suspend fun transfer(`value`: Output<String>) {
        this.transfer = value
    }

    /**
     * @param value
     */
    @JvmName("nfbrinocalnwsptx")
    public suspend fun verifiedpermissions(`value`: Output<String>) {
        this.verifiedpermissions = value
    }

    /**
     * @param value
     */
    @JvmName("ufqxqjlijohdhurg")
    public suspend fun vpclattice(`value`: Output<String>) {
        this.vpclattice = value
    }

    /**
     * @param value
     */
    @JvmName("hghqvpcwbwtaestm")
    public suspend fun waf(`value`: Output<String>) {
        this.waf = value
    }

    /**
     * @param value
     */
    @JvmName("reggatrutvqminsy")
    public suspend fun wafregional(`value`: Output<String>) {
        this.wafregional = value
    }

    /**
     * @param value
     */
    @JvmName("japxqecbuygeyuil")
    public suspend fun wafv2(`value`: Output<String>) {
        this.wafv2 = value
    }

    /**
     * @param value
     */
    @JvmName("xhhntdjvsaptydqo")
    public suspend fun worklink(`value`: Output<String>) {
        this.worklink = value
    }

    /**
     * @param value
     */
    @JvmName("cgkktnideqorgppy")
    public suspend fun workspaces(`value`: Output<String>) {
        this.workspaces = value
    }

    /**
     * @param value
     */
    @JvmName("nxnjrworqsmcbwtf")
    public suspend fun xray(`value`: Output<String>) {
        this.xray = value
    }

    /**
     * @param value
     */
    @JvmName("rkrhpwaachwolpfq")
    public suspend fun accessanalyzer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessanalyzer = mapped
    }

    /**
     * @param value
     */
    @JvmName("bfxwddfsobuepmsj")
    public suspend fun account(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value
     */
    @JvmName("muvqipchrirrlxhg")
    public suspend fun acm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param value
     */
    @JvmName("yokyhyhesxxaddwf")
    public suspend fun acmpca(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acmpca = mapped
    }

    /**
     * @param value
     */
    @JvmName("xybwitimmmqmnhpe")
    public suspend fun amg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amg = mapped
    }

    /**
     * @param value
     */
    @JvmName("vgrknnycgvryapye")
    public suspend fun amp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amp = mapped
    }

    /**
     * @param value
     */
    @JvmName("mfmunfpoyodhsprg")
    public suspend fun amplify(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amplify = mapped
    }

    /**
     * @param value
     */
    @JvmName("wnpipkpceutjdklg")
    public suspend fun apigateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apigateway = mapped
    }

    /**
     * @param value
     */
    @JvmName("jeplpoifnnsbexin")
    public suspend fun apigatewayv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apigatewayv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("rlivkghprwbgqseq")
    public suspend fun appautoscaling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appautoscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("ctanpbdwekwlurir")
    public suspend fun appconfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appconfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("pwklenogyncygqxn")
    public suspend fun appfabric(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appfabric = mapped
    }

    /**
     * @param value
     */
    @JvmName("xdukcaciikucalmf")
    public suspend fun appflow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appflow = mapped
    }

    /**
     * @param value
     */
    @JvmName("etjsbndldqwgyhce")
    public suspend fun appintegrations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appintegrations = mapped
    }

    /**
     * @param value
     */
    @JvmName("olpjedcmkyuihrbx")
    public suspend fun appintegrationsservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appintegrationsservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("tbukjbiccghsghrv")
    public suspend fun applicationautoscaling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationautoscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("gmopevubltthijqm")
    public suspend fun applicationinsights(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationinsights = mapped
    }

    /**
     * @param value
     */
    @JvmName("fbsipkijceoxuwmq")
    public suspend fun appmesh(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appmesh = mapped
    }

    /**
     * @param value
     */
    @JvmName("qhgnngyuxdpowwjw")
    public suspend fun apprunner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apprunner = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjkclbwwvkhfavvu")
    public suspend fun appstream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appstream = mapped
    }

    /**
     * @param value
     */
    @JvmName("nqwwliashqocuyph")
    public suspend fun appsync(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appsync = mapped
    }

    /**
     * @param value
     */
    @JvmName("ysyepjwlepybdekb")
    public suspend fun athena(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.athena = mapped
    }

    /**
     * @param value
     */
    @JvmName("iuqufirgdllwkwua")
    public suspend fun auditmanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditmanager = mapped
    }

    /**
     * @param value
     */
    @JvmName("mxpwlqidgyjsffcu")
    public suspend fun autoscaling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("mnwblwwoweugwopg")
    public suspend fun autoscalingplans(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingplans = mapped
    }

    /**
     * @param value
     */
    @JvmName("yeexawyqlgqdquyq")
    public suspend fun backup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backup = mapped
    }

    /**
     * @param value
     */
    @JvmName("vumofumltfxekaiw")
    public suspend fun batch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batch = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypdoddraoscjhwlk")
    public suspend fun beanstalk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beanstalk = mapped
    }

    /**
     * @param value
     */
    @JvmName("odvukwutbvvfwrvu")
    public suspend fun bedrock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bedrock = mapped
    }

    /**
     * @param value
     */
    @JvmName("prirbmwtsamhiayo")
    public suspend fun budgets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgets = mapped
    }

    /**
     * @param value
     */
    @JvmName("bqccssnqmwuvkcop")
    public suspend fun ce(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ce = mapped
    }

    /**
     * @param value
     */
    @JvmName("bscimenstyeqvtvm")
    public suspend fun chime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chime = mapped
    }

    /**
     * @param value
     */
    @JvmName("wpfeqllcsjedsmdp")
    public suspend fun chimesdkmediapipelines(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chimesdkmediapipelines = mapped
    }

    /**
     * @param value
     */
    @JvmName("lbdpvwivewsdjvvp")
    public suspend fun chimesdkvoice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chimesdkvoice = mapped
    }

    /**
     * @param value
     */
    @JvmName("rbwivkrlygcectyb")
    public suspend fun cleanrooms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanrooms = mapped
    }

    /**
     * @param value
     */
    @JvmName("baimnwqelrcmijov")
    public suspend fun cloud9(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloud9 = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjuachqkyfbmrabx")
    public suspend fun cloudcontrol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudcontrol = mapped
    }

    /**
     * @param value
     */
    @JvmName("amxvnuyvggoblgpm")
    public suspend fun cloudcontrolapi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudcontrolapi = mapped
    }

    /**
     * @param value
     */
    @JvmName("mslwhngpoxgoshje")
    public suspend fun cloudformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudformation = mapped
    }

    /**
     * @param value
     */
    @JvmName("uirpyqovcaggwief")
    public suspend fun cloudfront(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudfront = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvnukiqxuoglgiek")
    public suspend fun cloudhsm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudhsm = mapped
    }

    /**
     * @param value
     */
    @JvmName("cpcybuhkfaclkuwh")
    public suspend fun cloudhsmv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudhsmv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("uftnrwyogaiqqpwk")
    public suspend fun cloudsearch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudsearch = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktcqltqjffeyasli")
    public suspend fun cloudtrail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudtrail = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqhyeosynygovowc")
    public suspend fun cloudwatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatch = mapped
    }

    /**
     * @param value
     */
    @JvmName("kpclgfxleuibllnl")
    public suspend fun cloudwatchevents(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchevents = mapped
    }

    /**
     * @param value
     */
    @JvmName("nfbjyfknwthjhysh")
    public suspend fun cloudwatchevidently(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchevidently = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwccchojwykawxhx")
    public suspend fun cloudwatchlog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchlog = mapped
    }

    /**
     * @param value
     */
    @JvmName("vqchsxrupfvkoeww")
    public suspend fun cloudwatchlogs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchlogs = mapped
    }

    /**
     * @param value
     */
    @JvmName("qvmvvijqawbkqoqi")
    public suspend fun cloudwatchobservabilityaccessmanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchobservabilityaccessmanager = mapped
    }

    /**
     * @param value
     */
    @JvmName("yetiqbhcwnubxquo")
    public suspend fun cloudwatchrum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchrum = mapped
    }

    /**
     * @param value
     */
    @JvmName("anbcbhmxoamoltai")
    public suspend fun codeartifact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeartifact = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqrfvkbattilgdbm")
    public suspend fun codebuild(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codebuild = mapped
    }

    /**
     * @param value
     */
    @JvmName("rodrhbgcacaoivpy")
    public suspend fun codecatalyst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecatalyst = mapped
    }

    /**
     * @param value
     */
    @JvmName("vxqeltttkvaessvp")
    public suspend fun codecommit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecommit = mapped
    }

    /**
     * @param value
     */
    @JvmName("gjijshreqawwymyf")
    public suspend fun codedeploy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codedeploy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xudrfsveifcifado")
    public suspend fun codeguruprofiler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeguruprofiler = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrovvrahqndavegu")
    public suspend fun codegurureviewer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codegurureviewer = mapped
    }

    /**
     * @param value
     */
    @JvmName("gulmsrjfrcyjgquo")
    public suspend fun codepipeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codepipeline = mapped
    }

    /**
     * @param value
     */
    @JvmName("gqoxvyppebsomrjl")
    public suspend fun codestarconnections(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codestarconnections = mapped
    }

    /**
     * @param value
     */
    @JvmName("japwkxvfofdqhtkb")
    public suspend fun codestarnotifications(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codestarnotifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("iagqoaweyacsofht")
    public suspend fun cognitoidentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoidentity = mapped
    }

    /**
     * @param value
     */
    @JvmName("hojbeueyyspdfruh")
    public suspend fun cognitoidentityprovider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoidentityprovider = mapped
    }

    /**
     * @param value
     */
    @JvmName("ksofsomvvjdntpqf")
    public suspend fun cognitoidp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoidp = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfrbixfmjdqrjvrc")
    public suspend fun comprehend(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comprehend = mapped
    }

    /**
     * @param value
     */
    @JvmName("widyykmgocxjloet")
    public suspend fun computeoptimizer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeoptimizer = mapped
    }

    /**
     * @param value
     */
    @JvmName("yqjeiuixjuvtjgcf")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value
     */
    @JvmName("pdmfvrvcdqriqkik")
    public suspend fun configservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("jvitecmpuiwhfjja")
    public suspend fun connect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connect = mapped
    }

    /**
     * @param value
     */
    @JvmName("armqgpkgcfadgbip")
    public suspend fun connectcases(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectcases = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtchucsvsghdjufu")
    public suspend fun controltower(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controltower = mapped
    }

    /**
     * @param value
     */
    @JvmName("jgfpoyluoafigxfv")
    public suspend fun costandusagereportservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costandusagereportservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbppgmnohyujvmyw")
    public suspend fun costexplorer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costexplorer = mapped
    }

    /**
     * @param value
     */
    @JvmName("utwpyouttrvkcupb")
    public suspend fun cur(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cur = mapped
    }

    /**
     * @param value
     */
    @JvmName("lilbaxtdtosxcsbi")
    public suspend fun customerprofiles(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerprofiles = mapped
    }

    /**
     * @param value
     */
    @JvmName("nelsvpksqvwndvnm")
    public suspend fun databasemigration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasemigration = mapped
    }

    /**
     * @param value
     */
    @JvmName("aomovhyxkawdbpbt")
    public suspend fun databasemigrationservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasemigrationservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("pdnlmquhcqurgveq")
    public suspend fun dataexchange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataexchange = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktsvvpshfcsmfpih")
    public suspend fun datapipeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datapipeline = mapped
    }

    /**
     * @param value
     */
    @JvmName("bkmrfugtxdvcfynr")
    public suspend fun datasync(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasync = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhpaccoxfrvbplmr")
    public suspend fun dax(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dax = mapped
    }

    /**
     * @param value
     */
    @JvmName("tepmgctwopvvkkbv")
    public suspend fun deploy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploy = mapped
    }

    /**
     * @param value
     */
    @JvmName("caygcyycamiyyhsf")
    public suspend fun detective(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detective = mapped
    }

    /**
     * @param value
     */
    @JvmName("xrynvrkeerlmtsgt")
    public suspend fun devicefarm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devicefarm = mapped
    }

    /**
     * @param value
     */
    @JvmName("ywnrfrsmslfatqgf")
    public suspend fun directconnect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directconnect = mapped
    }

    /**
     * @param value
     */
    @JvmName("ltcssriochjkwjhb")
    public suspend fun directoryservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvreeqwliglttexr")
    public suspend fun dlm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dlm = mapped
    }

    /**
     * @param value
     */
    @JvmName("dprwlhkveeakeakr")
    public suspend fun dms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dms = mapped
    }

    /**
     * @param value
     */
    @JvmName("itlocgdnmpjmvwge")
    public suspend fun docdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docdb = mapped
    }

    /**
     * @param value
     */
    @JvmName("hqkvqwsjywulwxxt")
    public suspend fun docdbelastic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docdbelastic = mapped
    }

    /**
     * @param value
     */
    @JvmName("tilobuoiveygghqe")
    public suspend fun ds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ds = mapped
    }

    /**
     * @param value
     */
    @JvmName("rnsusposfpyotbam")
    public suspend fun dynamodb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodb = mapped
    }

    /**
     * @param value
     */
    @JvmName("epylxnoltsmcnjho")
    public suspend fun ec2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("itcvuklymsioqigc")
    public suspend fun ecr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecr = mapped
    }

    /**
     * @param value
     */
    @JvmName("jpfgcoavlagnugcx")
    public suspend fun ecrpublic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrpublic = mapped
    }

    /**
     * @param value
     */
    @JvmName("kwlpghygdhfqjxyp")
    public suspend fun ecs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecs = mapped
    }

    /**
     * @param value
     */
    @JvmName("locwynhghcasdrpj")
    public suspend fun efs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efs = mapped
    }

    /**
     * @param value
     */
    @JvmName("gchdmgyvcpvuadgt")
    public suspend fun eks(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eks = mapped
    }

    /**
     * @param value
     */
    @JvmName("odapolpcpjtqncrc")
    public suspend fun elasticache(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticache = mapped
    }

    /**
     * @param value
     */
    @JvmName("srciyowvqhgliyvq")
    public suspend fun elasticbeanstalk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticbeanstalk = mapped
    }

    /**
     * @param value
     */
    @JvmName("mcriyxfrowvsncml")
    public suspend fun elasticloadbalancing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticloadbalancing = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmjcglwnuvvskawa")
    public suspend fun elasticloadbalancingv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticloadbalancingv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("itjgbndekichrwnv")
    public suspend fun elasticsearch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param value
     */
    @JvmName("ojwarxlqormouarj")
    public suspend fun elasticsearchservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("jiyausfqjtiekurm")
    public suspend fun elastictranscoder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elastictranscoder = mapped
    }

    /**
     * @param value
     */
    @JvmName("acoedmwjfgntdade")
    public suspend fun elb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elb = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqkxiehublmopgqk")
    public suspend fun elbv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elbv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmorkgwebyhjhksu")
    public suspend fun emr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emr = mapped
    }

    /**
     * @param value
     */
    @JvmName("jkqrnoravseyqlmb")
    public suspend fun emrcontainers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emrcontainers = mapped
    }

    /**
     * @param value
     */
    @JvmName("kwivuyducfrbeatj")
    public suspend fun emrserverless(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emrserverless = mapped
    }

    /**
     * @param value
     */
    @JvmName("jldrkbyhkqraifkh")
    public suspend fun es(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.es = mapped
    }

    /**
     * @param value
     */
    @JvmName("lamdflwrwcfcmfaj")
    public suspend fun eventbridge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventbridge = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjgbwynbxxsanlpr")
    public suspend fun events(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value
     */
    @JvmName("fcmoqvhlttcbqugq")
    public suspend fun evidently(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evidently = mapped
    }

    /**
     * @param value
     */
    @JvmName("opcwmudrflvgigrs")
    public suspend fun finspace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finspace = mapped
    }

    /**
     * @param value
     */
    @JvmName("utnmkcmabxjasxml")
    public suspend fun firehose(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehose = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptqrdjakmcayrwqb")
    public suspend fun fis(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fis = mapped
    }

    /**
     * @param value
     */
    @JvmName("wuahsqrnegphuvsi")
    public suspend fun fms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fms = mapped
    }

    /**
     * @param value
     */
    @JvmName("xpmmwlymjgiqlhlq")
    public suspend fun fsx(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsx = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvtjnpeyfucjighw")
    public suspend fun gamelift(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gamelift = mapped
    }

    /**
     * @param value
     */
    @JvmName("fyirjwbneykomvri")
    public suspend fun glacier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glacier = mapped
    }

    /**
     * @param value
     */
    @JvmName("taasrmklqpqekass")
    public suspend fun globalaccelerator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalaccelerator = mapped
    }

    /**
     * @param value
     */
    @JvmName("lcowxqpbacfmsxbs")
    public suspend fun glue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glue = mapped
    }

    /**
     * @param value
     */
    @JvmName("yyyljooqttbxutbr")
    public suspend fun grafana(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafana = mapped
    }

    /**
     * @param value
     */
    @JvmName("kwapkghqsfgsinie")
    public suspend fun greengrass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greengrass = mapped
    }

    /**
     * @param value
     */
    @JvmName("amnqltutkypnbtkl")
    public suspend fun guardduty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guardduty = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgjitnrbantpgirr")
    public suspend fun healthlake(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthlake = mapped
    }

    /**
     * @param value
     */
    @JvmName("nbvgavrubtwbbimv")
    public suspend fun iam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iam = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaruqewrffwbnrhw")
    public suspend fun identitystore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identitystore = mapped
    }

    /**
     * @param value
     */
    @JvmName("pjedbfvhmvuevomc")
    public suspend fun imagebuilder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagebuilder = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvvskhfewbvnbsgk")
    public suspend fun inspector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inspector = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjbntmcxokuibwde")
    public suspend fun inspector2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inspector2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("ytbwtvhwfnoufajx")
    public suspend fun inspectorv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inspectorv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("sbvlolvmpsrotrjq")
    public suspend fun internetmonitor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetmonitor = mapped
    }

    /**
     * @param value
     */
    @JvmName("fpftydmormikwlva")
    public suspend fun iot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iot = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvufxdjijyfvwkqr")
    public suspend fun iotanalytics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotanalytics = mapped
    }

    /**
     * @param value
     */
    @JvmName("diildkgvgskcvlav")
    public suspend fun iotevents(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotevents = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvdqeosciavydbbc")
    public suspend fun ivs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ivs = mapped
    }

    /**
     * @param value
     */
    @JvmName("xhcdsxptjkccbcos")
    public suspend fun ivschat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ivschat = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvfmgotfbinvmjve")
    public suspend fun kafka(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafka = mapped
    }

    /**
     * @param value
     */
    @JvmName("jdxkonupyccuuljb")
    public suspend fun kafkaconnect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaconnect = mapped
    }

    /**
     * @param value
     */
    @JvmName("xvlqmkccrcflqvyf")
    public suspend fun kendra(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kendra = mapped
    }

    /**
     * @param value
     */
    @JvmName("dpmrktawyuknfvja")
    public suspend fun keyspaces(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyspaces = mapped
    }

    /**
     * @param value
     */
    @JvmName("fvyngvjokiilokia")
    public suspend fun kinesis(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesis = mapped
    }

    /**
     * @param value
     */
    @JvmName("grwhdoekejctciso")
    public suspend fun kinesisanalytics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisanalytics = mapped
    }

    /**
     * @param value
     */
    @JvmName("uwxbmadbksetbnwu")
    public suspend fun kinesisanalyticsv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisanalyticsv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("ykboxncflcpvwxdr")
    public suspend fun kinesisvideo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisvideo = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbhrnbnsmmckpgls")
    public suspend fun kms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kms = mapped
    }

    /**
     * @param value
     */
    @JvmName("ngbiavlaltmqihad")
    public suspend fun lakeformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lakeformation = mapped
    }

    /**
     * @param value
     */
    @JvmName("ofywqyuvubfsiijg")
    public suspend fun lambda(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    /**
     * @param value
     */
    @JvmName("taovhbntjhnigwaj")
    public suspend fun lex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lex = mapped
    }

    /**
     * @param value
     */
    @JvmName("prltqwbevpyilqhu")
    public suspend fun lexmodelbuilding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexmodelbuilding = mapped
    }

    /**
     * @param value
     */
    @JvmName("shcdwkxldasasean")
    public suspend fun lexmodelbuildingservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexmodelbuildingservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("btngbhpeaxkbemaj")
    public suspend fun lexmodels(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexmodels = mapped
    }

    /**
     * @param value
     */
    @JvmName("upgcrjjwlgxgitlb")
    public suspend fun lexmodelsv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexmodelsv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvwyiedbksmpiudg")
    public suspend fun lexv2models(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexv2models = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcyrrldbgylaipqq")
    public suspend fun licensemanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licensemanager = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujhyrspjwdtukskm")
    public suspend fun lightsail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lightsail = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjhqsotvdkbnsgxt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("qpalbuurmfixwjku")
    public suspend fun locationservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("mhwyujhtmnvjefol")
    public suspend fun logs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value
     */
    @JvmName("lekiddrnwrqxawsb")
    public suspend fun macie2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macie2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("itpefbjaektfdigj")
    public suspend fun managedgrafana(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedgrafana = mapped
    }

    /**
     * @param value
     */
    @JvmName("jenfajgjjqodwqar")
    public suspend fun mediaconnect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaconnect = mapped
    }

    /**
     * @param value
     */
    @JvmName("ymrrbjvnuldmttnb")
    public suspend fun mediaconvert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaconvert = mapped
    }

    /**
     * @param value
     */
    @JvmName("fsbapilupiyoipfh")
    public suspend fun medialive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.medialive = mapped
    }

    /**
     * @param value
     */
    @JvmName("fnichimdpjwldixg")
    public suspend fun mediapackage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediapackage = mapped
    }

    /**
     * @param value
     */
    @JvmName("didutiutmjfqpimg")
    public suspend fun mediapackagev2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediapackagev2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvajropssivnyoew")
    public suspend fun mediastore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediastore = mapped
    }

    /**
     * @param value
     */
    @JvmName("twwyttfeanwlpvid")
    public suspend fun memorydb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorydb = mapped
    }

    /**
     * @param value
     */
    @JvmName("yxlmkynrgclybpnq")
    public suspend fun mq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mq = mapped
    }

    /**
     * @param value
     */
    @JvmName("volqbqcpxfqgrmgq")
    public suspend fun msk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msk = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvpancqbgykwcrnc")
    public suspend fun mwaa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mwaa = mapped
    }

    /**
     * @param value
     */
    @JvmName("jraickvnaeaxdgsa")
    public suspend fun neptune(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neptune = mapped
    }

    /**
     * @param value
     */
    @JvmName("ppaagglakgidacue")
    public suspend fun networkfirewall(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkfirewall = mapped
    }

    /**
     * @param value
     */
    @JvmName("cnejlvciqvuxcnmk")
    public suspend fun networkmanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkmanager = mapped
    }

    /**
     * @param value
     */
    @JvmName("mfkesermmsggphbw")
    public suspend fun oam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oam = mapped
    }

    /**
     * @param value
     */
    @JvmName("qninjxvegoyavtye")
    public suspend fun opensearch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearch = mapped
    }

    /**
     * @param value
     */
    @JvmName("gtwwfiubuteqpxgp")
    public suspend fun opensearchingestion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchingestion = mapped
    }

    /**
     * @param value
     */
    @JvmName("hoqpqperetonovmb")
    public suspend fun opensearchserverless(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchserverless = mapped
    }

    /**
     * @param value
     */
    @JvmName("kppjspfiplesbfht")
    public suspend fun opensearchservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("ctovtixhfbpwkmmk")
    public suspend fun opsworks(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opsworks = mapped
    }

    /**
     * @param value
     */
    @JvmName("plpbtglrbgmqxsuo")
    public suspend fun organizations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizations = mapped
    }

    /**
     * @param value
     */
    @JvmName("epktkxmdvcbwedil")
    public suspend fun osis(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osis = mapped
    }

    /**
     * @param value
     */
    @JvmName("evhlvntqcjbuffsp")
    public suspend fun outposts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outposts = mapped
    }

    /**
     * @param value
     */
    @JvmName("ctapjslgpopyojcx")
    public suspend fun pinpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmcceaydtbylslyi")
    public suspend fun pipes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipes = mapped
    }

    /**
     * @param value
     */
    @JvmName("kkwjtiqbkxicnudc")
    public suspend fun pricing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricing = mapped
    }

    /**
     * @param value
     */
    @JvmName("cckolknxuljttkkq")
    public suspend fun prometheus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheus = mapped
    }

    /**
     * @param value
     */
    @JvmName("rrfmfanmtwdumexp")
    public suspend fun prometheusservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqaowouiuvqaxjtg")
    public suspend fun qldb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qldb = mapped
    }

    /**
     * @param value
     */
    @JvmName("cimaynsimvyaaoit")
    public suspend fun quicksight(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quicksight = mapped
    }

    /**
     * @param value
     */
    @JvmName("cutammkpbnfscklt")
    public suspend fun ram(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ram = mapped
    }

    /**
     * @param value
     */
    @JvmName("tmsdvmjvwvinxueg")
    public suspend fun rbin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rbin = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktbhxrpcuwampthu")
    public suspend fun rds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rds = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvvfrpchmjchwmrg")
    public suspend fun recyclebin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recyclebin = mapped
    }

    /**
     * @param value
     */
    @JvmName("ieqyntywalwecssk")
    public suspend fun redshift(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshift = mapped
    }

    /**
     * @param value
     */
    @JvmName("hxwaihddtvlpaqrv")
    public suspend fun redshiftdata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftdata = mapped
    }

    /**
     * @param value
     */
    @JvmName("xkeeavdqdbotfmfa")
    public suspend fun redshiftdataapiservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftdataapiservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("hxrdkhtmbldfgune")
    public suspend fun redshiftserverless(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftserverless = mapped
    }

    /**
     * @param value
     */
    @JvmName("gmaqphwicscelobq")
    public suspend fun resourceexplorer2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceexplorer2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("vypgyjlhocxegjkq")
    public suspend fun resourcegroups(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcegroups = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewmundeykaogjvqq")
    public suspend fun resourcegroupstagging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcegroupstagging = mapped
    }

    /**
     * @param value
     */
    @JvmName("beojcvqlvsfuhkfo")
    public suspend fun resourcegroupstaggingapi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcegroupstaggingapi = mapped
    }

    /**
     * @param value
     */
    @JvmName("kguqrqggemcwjnmf")
    public suspend fun rolesanywhere(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rolesanywhere = mapped
    }

    /**
     * @param value
     */
    @JvmName("nupqwgtjujixksiy")
    public suspend fun route53(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route53 = mapped
    }

    /**
     * @param value
     */
    @JvmName("klmrochqtmrenhnh")
    public suspend fun route53domains(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route53domains = mapped
    }

    /**
     * @param value
     */
    @JvmName("xfpuuojrjfrleahd")
    public suspend fun route53recoverycontrolconfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route53recoverycontrolconfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("jyvelktxswoxjgme")
    public suspend fun route53recoveryreadiness(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route53recoveryreadiness = mapped
    }

    /**
     * @param value
     */
    @JvmName("qsubthrcbyvkyuky")
    public suspend fun route53resolver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.route53resolver = mapped
    }

    /**
     * @param value
     */
    @JvmName("qnryagpwdexhgici")
    public suspend fun rum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rum = mapped
    }

    /**
     * @param value
     */
    @JvmName("ansgsuinpsacdbxg")
    public suspend fun s3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param value
     */
    @JvmName("cqpvsfyjwhudixda")
    public suspend fun s3api(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3api = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxnotecbscnodrol")
    public suspend fun s3control(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3control = mapped
    }

    /**
     * @param value
     */
    @JvmName("elfmorvfpgithswr")
    public suspend fun s3outposts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3outposts = mapped
    }

    /**
     * @param value
     */
    @JvmName("iaoycgewwkrghtex")
    public suspend fun sagemaker(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemaker = mapped
    }

    /**
     * @param value
     */
    @JvmName("dedabweqwiswqljv")
    public suspend fun scheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduler = mapped
    }

    /**
     * @param value
     */
    @JvmName("vfkmcixfhdiaupia")
    public suspend fun schemas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemas = mapped
    }

    /**
     * @param value
     */
    @JvmName("gwjokiygecdstqke")
    public suspend fun sdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sdb = mapped
    }

    /**
     * @param value
     */
    @JvmName("okmqvqdikeruhgwp")
    public suspend fun secretsmanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsmanager = mapped
    }

    /**
     * @param value
     */
    @JvmName("vlsxxjwcyrbyhpyw")
    public suspend fun securityhub(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityhub = mapped
    }

    /**
     * @param value
     */
    @JvmName("xivnycucyisqvvou")
    public suspend fun securitylake(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitylake = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhifvgvupbiyiidw")
    public suspend fun serverlessapplicationrepository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessapplicationrepository = mapped
    }

    /**
     * @param value
     */
    @JvmName("imwnjoveuqkkobhi")
    public suspend fun serverlessapprepo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessapprepo = mapped
    }

    /**
     * @param value
     */
    @JvmName("byvhiavbxuqjkvsg")
    public suspend fun serverlessrepo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessrepo = mapped
    }

    /**
     * @param value
     */
    @JvmName("qmlyalxdjooijest")
    public suspend fun servicecatalog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicecatalog = mapped
    }

    /**
     * @param value
     */
    @JvmName("ulfhqgwibqemfexg")
    public suspend fun servicediscovery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicediscovery = mapped
    }

    /**
     * @param value
     */
    @JvmName("phovgrvspuychisl")
    public suspend fun servicequotas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicequotas = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmrrtfxhlbecayqj")
    public suspend fun ses(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ses = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivqobrfsxyhjksbo")
    public suspend fun sesv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sesv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwshikpbqmexxspf")
    public suspend fun sfn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sfn = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktvlxcjrqcsrjbug")
    public suspend fun shield(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shield = mapped
    }

    /**
     * @param value
     */
    @JvmName("iixaqjyafpakpbmr")
    public suspend fun signer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signer = mapped
    }

    /**
     * @param value
     */
    @JvmName("ratfjuafjqxxbnxf")
    public suspend fun simpledb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpledb = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwbsqfxusvhfhohm")
    public suspend fun sns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param value
     */
    @JvmName("jgvtwkeuqtahggfh")
    public suspend fun sqs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjgyakorqawalnyx")
    public suspend fun ssm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssm = mapped
    }

    /**
     * @param value
     */
    @JvmName("nyuqlrxshdlrmtlo")
    public suspend fun ssmcontacts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmcontacts = mapped
    }

    /**
     * @param value
     */
    @JvmName("bcfgnetcgkelvevt")
    public suspend fun ssmincidents(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmincidents = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkpmvjhjvsyrjoqv")
    public suspend fun sso(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sso = mapped
    }

    /**
     * @param value
     */
    @JvmName("fkijhjumpefncrsj")
    public suspend fun ssoadmin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoadmin = mapped
    }

    /**
     * @param value
     */
    @JvmName("lnqiqhxucytuoynm")
    public suspend fun stepfunctions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepfunctions = mapped
    }

    /**
     * @param value
     */
    @JvmName("lpoxkpubpsnqvgbo")
    public suspend fun storagegateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storagegateway = mapped
    }

    /**
     * @param value
     */
    @JvmName("gmyvhialacgxmjnr")
    public suspend fun sts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sts = mapped
    }

    /**
     * @param value
     */
    @JvmName("bndwayywednmdcpo")
    public suspend fun swf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swf = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvjwdbxyrqsppmxs")
    public suspend fun synthetics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synthetics = mapped
    }

    /**
     * @param value
     */
    @JvmName("vaykaxhtrawxwxkx")
    public suspend fun timestreamwrite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestreamwrite = mapped
    }

    /**
     * @param value
     */
    @JvmName("auahsmpntssphtkl")
    public suspend fun transcribe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transcribe = mapped
    }

    /**
     * @param value
     */
    @JvmName("qfkwvgtpemifojay")
    public suspend fun transcribeservice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transcribeservice = mapped
    }

    /**
     * @param value
     */
    @JvmName("bydglhtjravcawfe")
    public suspend fun transfer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transfer = mapped
    }

    /**
     * @param value
     */
    @JvmName("swqmeekrinaccpxe")
    public suspend fun verifiedpermissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedpermissions = mapped
    }

    /**
     * @param value
     */
    @JvmName("mfcoekumjdwrvhiw")
    public suspend fun vpclattice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpclattice = mapped
    }

    /**
     * @param value
     */
    @JvmName("bocttwvryskqbtse")
    public suspend fun waf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waf = mapped
    }

    /**
     * @param value
     */
    @JvmName("pmlfyfwjswojxjeb")
    public suspend fun wafregional(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafregional = mapped
    }

    /**
     * @param value
     */
    @JvmName("vcqiprisvnfjcuek")
    public suspend fun wafv2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("xidibyallbukqxna")
    public suspend fun worklink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.worklink = mapped
    }

    /**
     * @param value
     */
    @JvmName("lvopwifrxjydseeu")
    public suspend fun workspaces(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaces = mapped
    }

    /**
     * @param value
     */
    @JvmName("rbjwjhdfduvrvxad")
    public suspend fun xray(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xray = mapped
    }

    internal fun build(): ProviderEndpointArgs = ProviderEndpointArgs(
        accessanalyzer = accessanalyzer,
        account = account,
        acm = acm,
        acmpca = acmpca,
        amg = amg,
        amp = amp,
        amplify = amplify,
        apigateway = apigateway,
        apigatewayv2 = apigatewayv2,
        appautoscaling = appautoscaling,
        appconfig = appconfig,
        appfabric = appfabric,
        appflow = appflow,
        appintegrations = appintegrations,
        appintegrationsservice = appintegrationsservice,
        applicationautoscaling = applicationautoscaling,
        applicationinsights = applicationinsights,
        appmesh = appmesh,
        apprunner = apprunner,
        appstream = appstream,
        appsync = appsync,
        athena = athena,
        auditmanager = auditmanager,
        autoscaling = autoscaling,
        autoscalingplans = autoscalingplans,
        backup = backup,
        batch = batch,
        beanstalk = beanstalk,
        bedrock = bedrock,
        budgets = budgets,
        ce = ce,
        chime = chime,
        chimesdkmediapipelines = chimesdkmediapipelines,
        chimesdkvoice = chimesdkvoice,
        cleanrooms = cleanrooms,
        cloud9 = cloud9,
        cloudcontrol = cloudcontrol,
        cloudcontrolapi = cloudcontrolapi,
        cloudformation = cloudformation,
        cloudfront = cloudfront,
        cloudhsm = cloudhsm,
        cloudhsmv2 = cloudhsmv2,
        cloudsearch = cloudsearch,
        cloudtrail = cloudtrail,
        cloudwatch = cloudwatch,
        cloudwatchevents = cloudwatchevents,
        cloudwatchevidently = cloudwatchevidently,
        cloudwatchlog = cloudwatchlog,
        cloudwatchlogs = cloudwatchlogs,
        cloudwatchobservabilityaccessmanager = cloudwatchobservabilityaccessmanager,
        cloudwatchrum = cloudwatchrum,
        codeartifact = codeartifact,
        codebuild = codebuild,
        codecatalyst = codecatalyst,
        codecommit = codecommit,
        codedeploy = codedeploy,
        codeguruprofiler = codeguruprofiler,
        codegurureviewer = codegurureviewer,
        codepipeline = codepipeline,
        codestarconnections = codestarconnections,
        codestarnotifications = codestarnotifications,
        cognitoidentity = cognitoidentity,
        cognitoidentityprovider = cognitoidentityprovider,
        cognitoidp = cognitoidp,
        comprehend = comprehend,
        computeoptimizer = computeoptimizer,
        config = config,
        configservice = configservice,
        connect = connect,
        connectcases = connectcases,
        controltower = controltower,
        costandusagereportservice = costandusagereportservice,
        costexplorer = costexplorer,
        cur = cur,
        customerprofiles = customerprofiles,
        databasemigration = databasemigration,
        databasemigrationservice = databasemigrationservice,
        dataexchange = dataexchange,
        datapipeline = datapipeline,
        datasync = datasync,
        dax = dax,
        deploy = deploy,
        detective = detective,
        devicefarm = devicefarm,
        directconnect = directconnect,
        directoryservice = directoryservice,
        dlm = dlm,
        dms = dms,
        docdb = docdb,
        docdbelastic = docdbelastic,
        ds = ds,
        dynamodb = dynamodb,
        ec2 = ec2,
        ecr = ecr,
        ecrpublic = ecrpublic,
        ecs = ecs,
        efs = efs,
        eks = eks,
        elasticache = elasticache,
        elasticbeanstalk = elasticbeanstalk,
        elasticloadbalancing = elasticloadbalancing,
        elasticloadbalancingv2 = elasticloadbalancingv2,
        elasticsearch = elasticsearch,
        elasticsearchservice = elasticsearchservice,
        elastictranscoder = elastictranscoder,
        elb = elb,
        elbv2 = elbv2,
        emr = emr,
        emrcontainers = emrcontainers,
        emrserverless = emrserverless,
        es = es,
        eventbridge = eventbridge,
        events = events,
        evidently = evidently,
        finspace = finspace,
        firehose = firehose,
        fis = fis,
        fms = fms,
        fsx = fsx,
        gamelift = gamelift,
        glacier = glacier,
        globalaccelerator = globalaccelerator,
        glue = glue,
        grafana = grafana,
        greengrass = greengrass,
        guardduty = guardduty,
        healthlake = healthlake,
        iam = iam,
        identitystore = identitystore,
        imagebuilder = imagebuilder,
        inspector = inspector,
        inspector2 = inspector2,
        inspectorv2 = inspectorv2,
        internetmonitor = internetmonitor,
        iot = iot,
        iotanalytics = iotanalytics,
        iotevents = iotevents,
        ivs = ivs,
        ivschat = ivschat,
        kafka = kafka,
        kafkaconnect = kafkaconnect,
        kendra = kendra,
        keyspaces = keyspaces,
        kinesis = kinesis,
        kinesisanalytics = kinesisanalytics,
        kinesisanalyticsv2 = kinesisanalyticsv2,
        kinesisvideo = kinesisvideo,
        kms = kms,
        lakeformation = lakeformation,
        lambda = lambda,
        lex = lex,
        lexmodelbuilding = lexmodelbuilding,
        lexmodelbuildingservice = lexmodelbuildingservice,
        lexmodels = lexmodels,
        lexmodelsv2 = lexmodelsv2,
        lexv2models = lexv2models,
        licensemanager = licensemanager,
        lightsail = lightsail,
        location = location,
        locationservice = locationservice,
        logs = logs,
        macie2 = macie2,
        managedgrafana = managedgrafana,
        mediaconnect = mediaconnect,
        mediaconvert = mediaconvert,
        medialive = medialive,
        mediapackage = mediapackage,
        mediapackagev2 = mediapackagev2,
        mediastore = mediastore,
        memorydb = memorydb,
        mq = mq,
        msk = msk,
        mwaa = mwaa,
        neptune = neptune,
        networkfirewall = networkfirewall,
        networkmanager = networkmanager,
        oam = oam,
        opensearch = opensearch,
        opensearchingestion = opensearchingestion,
        opensearchserverless = opensearchserverless,
        opensearchservice = opensearchservice,
        opsworks = opsworks,
        organizations = organizations,
        osis = osis,
        outposts = outposts,
        pinpoint = pinpoint,
        pipes = pipes,
        pricing = pricing,
        prometheus = prometheus,
        prometheusservice = prometheusservice,
        qldb = qldb,
        quicksight = quicksight,
        ram = ram,
        rbin = rbin,
        rds = rds,
        recyclebin = recyclebin,
        redshift = redshift,
        redshiftdata = redshiftdata,
        redshiftdataapiservice = redshiftdataapiservice,
        redshiftserverless = redshiftserverless,
        resourceexplorer2 = resourceexplorer2,
        resourcegroups = resourcegroups,
        resourcegroupstagging = resourcegroupstagging,
        resourcegroupstaggingapi = resourcegroupstaggingapi,
        rolesanywhere = rolesanywhere,
        route53 = route53,
        route53domains = route53domains,
        route53recoverycontrolconfig = route53recoverycontrolconfig,
        route53recoveryreadiness = route53recoveryreadiness,
        route53resolver = route53resolver,
        rum = rum,
        s3 = s3,
        s3api = s3api,
        s3control = s3control,
        s3outposts = s3outposts,
        sagemaker = sagemaker,
        scheduler = scheduler,
        schemas = schemas,
        sdb = sdb,
        secretsmanager = secretsmanager,
        securityhub = securityhub,
        securitylake = securitylake,
        serverlessapplicationrepository = serverlessapplicationrepository,
        serverlessapprepo = serverlessapprepo,
        serverlessrepo = serverlessrepo,
        servicecatalog = servicecatalog,
        servicediscovery = servicediscovery,
        servicequotas = servicequotas,
        ses = ses,
        sesv2 = sesv2,
        sfn = sfn,
        shield = shield,
        signer = signer,
        simpledb = simpledb,
        sns = sns,
        sqs = sqs,
        ssm = ssm,
        ssmcontacts = ssmcontacts,
        ssmincidents = ssmincidents,
        sso = sso,
        ssoadmin = ssoadmin,
        stepfunctions = stepfunctions,
        storagegateway = storagegateway,
        sts = sts,
        swf = swf,
        synthetics = synthetics,
        timestreamwrite = timestreamwrite,
        transcribe = transcribe,
        transcribeservice = transcribeservice,
        transfer = transfer,
        verifiedpermissions = verifiedpermissions,
        vpclattice = vpclattice,
        waf = waf,
        wafregional = wafregional,
        wafv2 = wafv2,
        worklink = worklink,
        workspaces = workspaces,
        xray = xray,
    )
}
